/*
 * Decompiled with CFR 0.152.
 */
package explorer.batch.acp;

import explorer.batch.CentralResult;
import explorer.batch.ResultDisplay;
import explorer.batch.acp.InterfaceTestACP;
import explorer.compute.compute.projection.PMFactory;
import explorer.compute.compute.projection.PMPCA;
import explorer.compute.compute.projection.conditionning.ConditioningFactory;
import explorer.data.SourceAttrVal;
import java.io.PrintStream;

public class TestACP
implements InterfaceTestACP {
    private PMPCA acp;
    private int nbAttACP;
    private String name;
    private int detailAff = 0;

    public TestACP(SourceAttrVal src, boolean centrage, int normalisation, String _name) {
        this.setParameters(src, centrage, normalisation, _name);
    }

    public TestACP() {
    }

    @Override
    public void setParameters(SourceAttrVal src, boolean centrage, int normalisation, String _name) {
        this.nbAttACP = src.getNbAttACP();
        this.acp = PMFactory.getSingleton().createPMPCA(src, ConditioningFactory.createConditioning(normalisation, centrage));
        this.name = _name;
    }

    @Override
    public synchronized CentralResult run(int[] cross, int nbg, boolean affichage, int knn) {
        long begin = System.currentTimeMillis();
        CentralResult resultats = new CentralResult();
        this.acp.setCrossValidation(cross, nbg);
        this.acp.calculer();
        this.acp.creerProjection();
        if (this.name.equals("Brut")) {
            System.out.print("ACPnr  ");
        }
        if (this.name.equals("Red")) {
            System.out.print("ACP ");
        }
        this.acp.test(cross, nbg, affichage, knn);
        float[] ve = this.acp.getVarEx();
        long end = System.currentTimeMillis();
        float time = (float)(end - begin) / 1000.0f;
        int i = 0;
        while (i < this.nbAttACP) {
            resultats.addResult("acp" + this.name + "(" + i + ")" + "knn" + knn, "Taux", this.acp.getTauxCorrect(i));
            resultats.addResult("acp" + this.name + "(" + i + ")" + "knn" + knn, "VarEx", ve[i]);
            resultats.addResult("acp" + this.name + "(" + i + ")" + "knn" + knn, "VarInter", this.acp.getVarianceInter(i));
            resultats.addResult("acp" + this.name + "(" + i + ")" + "knn" + knn, "VarIntra", this.acp.getVarianceIntra(i));
            ++i;
        }
        resultats.addResult("acp" + this.name + "knn" + knn, "AutoDim", this.acp.getNbDimAutoDim());
        resultats.addResult("acp" + this.name + "knn" + knn, "TauxApp", this.acp.getTauxCorrectAppAutoDim());
        resultats.addResult("acp" + this.name + "knn" + knn, "TauxTest", this.acp.getTauxCorrectTestAutoDim());
        resultats.addResult("acp" + this.name + "knn" + knn, "Time", time);
        return resultats;
    }

    public void affiche(CentralResult res, PrintStream psout, int verbose, int knn) {
        ResultDisplay resultats = new ResultDisplay(res, psout, verbose);
        resultats.afficherln("-------------------------------------------------------", psout, verbose);
        if (this.detailAff == 1) {
            if (this.name.equals("Brut")) {
                resultats.afficherln("Knn = " + knn + " ACP non centr\u00e9e, non r\u00e9duite :", psout, verbose);
            }
            if (this.name.equals("Red")) {
                resultats.afficherln("Knn = " + knn + " ACP centr\u00e9e, r\u00e9duite :", psout, verbose);
            }
            resultats.afficher(" Taux : ", psout, verbose);
            int i = 0;
            while (i < this.nbAttACP) {
                resultats.afficheMoyenne("acp" + this.name + "(" + i + ")" + "knn" + knn, "Taux");
                ++i;
            }
            resultats.afficherln(psout, verbose);
            resultats.afficheMethodeType("acp" + this.name + "knn" + knn, "AutoDim");
            resultats.afficheMethodeType("acp" + this.name + "knn" + knn, "TauxApp");
            resultats.afficheMethodeType("acp" + this.name + "knn" + knn, "TauxTest");
            resultats.afficheMethodeType("acp" + this.name + "knn" + knn, "Time");
            resultats.afficherln(psout, verbose);
        } else {
            if (this.name.equals("Brut")) {
                resultats.afficher("Knn = " + knn + " ACP non centree, non r\u00e9duite :", psout, verbose);
            }
            if (this.name.equals("Red")) {
                resultats.afficher("Knn = " + knn + " ACP centree, r\u00e9duite :", psout, verbose);
            }
            String out = resultats.formatFloat(resultats.getMoyenne("acp" + this.name + "knn" + knn, "TauxTest"));
            out = String.valueOf(out) + " +/- " + resultats.formatFloat(resultats.getEcartType("acp" + this.name + "knn" + knn, "TauxTest"));
            out = String.valueOf(out) + "  ( " + resultats.formatFloat(resultats.getMoyenne("acp" + this.name + "knn" + knn, "TauxApp"));
            out = String.valueOf(out) + " +/- " + resultats.formatFloat(resultats.getEcartType("acp" + this.name + "knn" + knn, "TauxApp")) + " )";
            resultats.afficherln(out, psout, verbose);
            out = "Training time : " + resultats.formatFloat(resultats.getMoyenne("acp" + this.name + "knn" + knn, "Time"));
            out = String.valueOf(out) + " +/- " + resultats.formatFloat(resultats.getEcartType("acp" + this.name + "knn" + knn, "Time"));
            resultats.afficherln(out, psout, verbose);
        }
    }
}

