/*
 * Decompiled with CFR 0.152.
 */
package explorer.batch.ardp;

import explorer.batch.CentralResult;
import explorer.batch.ResultDisplay;
import explorer.batch.ardp.InterfaceTestARDp;
import explorer.compute.compute.projection.PMARDp;
import explorer.compute.compute.projection.PMFactory;
import explorer.compute.compute.projection.conditionning.Conditioning;
import explorer.compute.compute.projection.conditionning.ConditioningFactory;
import explorer.data.SourceAttrVal;
import java.io.PrintStream;

public class TestARDp
implements InterfaceTestARDp {
    private PMARDp ardp;
    private int nbAttACP;
    private SourceAttrVal src;
    private boolean centrage;
    private int normalisation;
    private String name;
    private int sigmaMax = 10;
    private int detailAff = 0;
    private float ardpDiff;
    private int sigmaMin = 0;

    public TestARDp(SourceAttrVal src, boolean _centrage, int _normalisation, String _name) {
        this.src = src;
        this.nbAttACP = src.getNbAttACP();
        this.centrage = _centrage;
        this.normalisation = _normalisation;
        this.name = _name;
        this.ardpDiff = 0.0f;
    }

    public TestARDp(SourceAttrVal src, boolean _centrage, int _normalisation, String _name, float diff) {
        this.src = src;
        this.nbAttACP = src.getNbAttACP();
        this.centrage = _centrage;
        this.normalisation = _normalisation;
        this.name = _name;
        this.ardpDiff = diff;
    }

    public TestARDp() {
    }

    @Override
    public synchronized void setParameters(SourceAttrVal src, boolean _centrage, int _normalisation, String _name, float diff) {
        this.src = src;
        this.nbAttACP = src.getNbAttACP();
        this.centrage = _centrage;
        this.normalisation = _normalisation;
        this.name = _name;
        this.ardpDiff = diff;
    }

    @Override
    public int getSigmaMin() {
        return this.sigmaMin;
    }

    @Override
    public synchronized void setSigmaMin(int sigmaMin) {
        this.sigmaMin = sigmaMin;
    }

    @Override
    public float getArdpDiff() {
        return this.ardpDiff;
    }

    @Override
    public synchronized void setArdpDiff(float ardpDiff) {
        this.ardpDiff = ardpDiff;
    }

    @Override
    public synchronized CentralResult run(int[] cross, int nbg, boolean affichage, int knn) {
        long begin = System.currentTimeMillis();
        long end = 0L;
        float tauxM = -1.0f;
        float tauxT = 0.0f;
        int errM = 0;
        CentralResult resultats = new CentralResult();
        int j = this.sigmaMin;
        while (j < this.sigmaMax) {
            Conditioning c = ConditioningFactory.createConditioning(this.normalisation, this.centrage);
            this.ardp = PMFactory.getSingleton().createPMARDp(this.src, c, this.ardpDiff);
            this.ardp.setAff(false);
            if (this.ardp.isAff()) {
                System.out.print("ARDp  ");
            }
            this.ardp.setParameterValue(PMARDp.param_sigma, (float)j * 1.0f);
            this.ardp.setCrossValidation(cross, nbg);
            this.ardp.calculer();
            this.ardp.creerProjection();
            if (this.ardp.isAff()) {
                System.out.print(String.valueOf(j) + " ");
            }
            this.ardp.test(cross, nbg, false, knn);
            float[] ve = this.ardp.getVarEx();
            end = System.currentTimeMillis();
            int i = 0;
            while (i < this.nbAttACP) {
                resultats.addResult("ardp" + this.name + "-" + j + " (" + i + ")" + "ardpDiff" + this.ardpDiff + "knn" + knn + "SigmaMin" + this.sigmaMin, "Taux", this.ardp.getTauxCorrect(i));
                resultats.addResult("ardp" + this.name + "-" + j + " (" + i + ")" + "ardpDiff" + this.ardpDiff + "knn" + knn + "SigmaMin" + this.sigmaMin, "VarEx", ve[i]);
                resultats.addResult("ardp" + this.name + "-" + j + " (" + i + ")" + "ardpDiff" + this.ardpDiff + "knn" + knn + "SigmaMin" + this.sigmaMin, "VarInter", this.ardp.getVarianceInter(i));
                resultats.addResult("ardp" + this.name + "-" + j + " (" + i + ")" + "ardpDiff" + this.ardpDiff + "knn" + knn + "SigmaMin" + this.sigmaMin, "VarIntra", this.ardp.getVarianceIntra(i));
                ++i;
            }
            resultats.addResult("ardp" + this.name + "-" + j + "ardpDiff" + this.ardpDiff + "knn" + knn + "SigmaMin" + this.sigmaMin, "AutoDim", this.ardp.getNbDimAutoDim());
            float errA = this.ardp.getTauxCorrectAppAutoDim();
            resultats.addResult("ardp" + this.name + "-" + j + "ardpDiff" + this.ardpDiff + "knn" + knn + "SigmaMin" + this.sigmaMin, "TauxApp", errA);
            float errT = this.ardp.getTauxCorrectTestAutoDim();
            resultats.addResult("ardp" + this.name + "-" + j + "ardpDiff" + this.ardpDiff + "knn" + knn + "SigmaMin" + this.sigmaMin, "TauxTest", errT);
            if (tauxM == -1.0f || errA > tauxM) {
                errM = j;
                tauxM = errA;
                tauxT = errT;
            }
            ++j;
        }
        float time = 0.0f;
        if (end != 0L) {
            time = (float)(end - begin) / 1000.0f;
        }
        resultats.addResult("ardp" + this.name + "ardpDiff" + this.ardpDiff + "knn" + knn + "SigmaMin" + this.sigmaMin, "bestW", errM);
        resultats.addResult("ardp" + this.name + "ardpDiff" + this.ardpDiff + "knn" + knn + "SigmaMin" + this.sigmaMin, "Taux", tauxT);
        resultats.addResult("ardp" + this.name + "ardpDiff" + this.ardpDiff + "knn" + knn + "SigmaMin" + this.sigmaMin, "Time", time);
        return resultats;
    }

    public void affiche(CentralResult res, PrintStream psout, int verbose, int knn, float ardp, int sigmin) {
        ResultDisplay resultats = new ResultDisplay(res, psout, verbose);
        resultats.afficherln("-------------------------------------------------------", psout, verbose);
        if (this.detailAff == 2) {
            resultats.afficherln("ARDp " + this.name + ":  (ARDpDiff=" + ardp + ")", psout, verbose);
            int j = 0;
            while (j < this.sigmaMax) {
                resultats.afficherln("w=" + j + " :   ", psout, verbose);
                int i = 0;
                while (i < this.nbAttACP) {
                    resultats.afficheMethodeType("ardp" + this.name + "-" + j + " (" + i + ")" + "ardpDiff" + ardp + "knn" + knn + "SigmaMin" + sigmin, "Taux");
                    ++i;
                }
                resultats.afficheMethodeType("ardp" + this.name + "-" + j + "ardpDiff" + ardp + "knn" + knn + "SigmaMin" + sigmin, "AutoDim");
                resultats.afficheMethodeType("ardp" + this.name + "-" + j + "ardpDiff" + ardp + "knn" + knn + "SigmaMin" + sigmin, "TauxApp");
                resultats.afficheMethodeType("ardp" + this.name + "-" + j + "ardpDiff" + ardp + "knn" + knn + "SigmaMin" + sigmin, "TauxTest");
                resultats.afficherln(psout, verbose);
                ++j;
            }
            resultats.afficheMethodeType("ardp" + this.name + "ardpDiff" + ardp + "knn" + knn + "SigmaMin" + sigmin, "bestW");
            resultats.afficheMethodeType("ardp" + this.name + "ardpDiff" + ardp + "knn" + knn + "SigmaMin" + sigmin, "Taux");
            resultats.afficheMethodeType("ardp" + this.name + "ardpDiff" + ardp + "knn" + knn + "SigmaMin" + sigmin, "Time");
        } else if (this.detailAff == 1) {
            resultats.afficherln("ARDp " + this.name + ":  (ARDpDiff=" + ardp + ")", psout, verbose);
            resultats.afficheMethodeType("ardp" + this.name + "ardpDiff" + ardp + "knn" + knn + "SigmaMin" + sigmin, "bestW");
            resultats.afficheMethodeType("ardp" + this.name + "ardpDiff" + ardp + "knn" + knn + "SigmaMin" + sigmin, "Taux");
            resultats.afficheMethodeType("ardp" + this.name + "ardpDiff" + ardp + "knn" + knn + "SigmaMin" + sigmin, "Time");
        } else if (this.detailAff == 0) {
            resultats.afficher("ARDp " + this.name + ":  (ARDpDiff=" + ardp + ")", psout, verbose);
            String out = resultats.formatFloat(resultats.getMoyenne("ardp" + this.name + "ardpDiff" + ardp + "knn" + knn + "SigmaMin" + sigmin, "Taux"));
            out = String.valueOf(out) + " +/- " + resultats.formatFloat(resultats.getEcartType("ardp" + this.name + "ardpDiff" + ardp + "knn" + knn + "SigmaMin" + sigmin, "Taux"));
            resultats.afficherln(out, psout, verbose);
            out = "Training time : " + resultats.formatFloat(resultats.getMoyenne("ardp" + this.name + "ardpDiff" + ardp + "knn" + knn + "SigmaMin" + sigmin, "Time"));
            out = String.valueOf(out) + " +/- " + resultats.formatFloat(resultats.getEcartType("ardp" + this.name + "ardpDiff" + ardp + "knn" + knn + "SigmaMin" + sigmin, "Time"));
            resultats.afficherln(out, psout, verbose);
        }
    }
}

