/*
 * Decompiled with CFR 0.152.
 */
package explorer.batch.lmnn;

import explorer.batch.CentralResult;
import explorer.batch.ResultDisplay;
import explorer.batch.lmnn.InterfaceTestLMNN;
import explorer.compute.compute.LMNN;
import explorer.data.SourceAttrVal;
import java.io.IOException;
import java.io.PrintStream;

public class TestLMNN
implements InterfaceTestLMNN {
    private LMNN lmnn;
    private int detailAff = 0;

    public TestLMNN() {
        this.lmnn = null;
    }

    public TestLMNN(SourceAttrVal d) {
        this.lmnn = new LMNN(d);
    }

    @Override
    public synchronized void setParameters(SourceAttrVal d) {
        this.lmnn = new LMNN(d);
    }

    @Override
    public synchronized CentralResult run(int[] cross, int n, boolean aff, int knn) {
        System.out.println("Pour Knn = " + knn + " nbg = " + n);
        this.lmnn.setMatrice(cross, n);
        CentralResult resultats = new CentralResult();
        try {
            this.lmnn.calculer(knn);
            resultats.addResult("LMNN Euclidean, knn" + knn, "TauxTraining", 100.0f - this.lmnn.getKnnerrITr());
            resultats.addResult("LMNN Euclidean, knn" + knn, "TauxTesting", 100.0f - this.lmnn.getKnnerrITe());
            resultats.addResult("LMNN Malhalanobis, knn" + knn, "TauxTraining", 100.0f - this.lmnn.getKnnerrLTr());
            resultats.addResult("LMNN Malhalanobis, knn" + knn, "TauxTesting", 100.0f - this.lmnn.getKnnerrLTe());
            resultats.addResult("Energy classification, knn" + knn, "TauxError", 100.0f - this.lmnn.getEnerr());
            resultats.addResult("LMNN Training, knn" + knn, "Time", this.lmnn.getTime());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resultats;
    }

    public void affiche(CentralResult res, PrintStream psout, int verbose, int knn) {
        ResultDisplay resultats = new ResultDisplay(res, psout, verbose);
        resultats.afficherln("-------------------------------------------------------", psout, verbose);
        if (this.detailAff == 1) {
            resultats.afficherln(psout, verbose);
            resultats.afficheMethodeType("LMNN Euclidean, knn" + knn, "TauxTraining");
            resultats.afficherln("--------------------------------------------------------", psout, verbose);
            resultats.afficheMethodeType("LMNN Euclidean, knn" + knn, "TauxTesting");
            resultats.afficherln("--------------------------------------------------------", psout, verbose);
            resultats.afficheMethodeType("LMNN Malhalanobis, knn" + knn, "TauxTraining");
            resultats.afficherln("--------------------------------------------------------", psout, verbose);
            resultats.afficheMethodeType("LMNN Malhalanobis, knn" + knn, "TauxTesting");
            resultats.afficherln("--------------------------------------------------------", psout, verbose);
            resultats.afficheMethodeType("Energy classification, knn" + knn, "TauxError");
            resultats.afficherln("--------------------------------------------------------", psout, verbose);
            resultats.afficheMethodeType("LMNN Training, knn" + knn, "Time");
        } else {
            String out = "Knn = " + knn;
            resultats.afficherln(out, psout, verbose);
            out = "LMNN Euclidean : " + resultats.formatFloat(resultats.getMoyenne("LMNN Euclidean, knn" + knn, "TauxTesting"));
            out = String.valueOf(out) + " +/- " + resultats.formatFloat(resultats.getEcartType("LMNN Euclidean, knn" + knn, "TauxTesting"));
            out = String.valueOf(out) + "  ( " + resultats.formatFloat(resultats.getMoyenne("LMNN Euclidean, knn" + knn, "TauxTraining"));
            out = String.valueOf(out) + " +/- " + resultats.formatFloat(resultats.getEcartType("LMNN Euclidean, knn" + knn, "TauxTraining")) + " )";
            resultats.afficherln(out, psout, verbose);
            out = "LMNN Malhalanobis : " + resultats.formatFloat(resultats.getMoyenne("LMNN Malhalanobis, knn" + knn, "TauxTesting"));
            out = String.valueOf(out) + " +/- " + resultats.formatFloat(resultats.getEcartType("LMNN Malhalanobis, knn" + knn, "TauxTesting"));
            out = String.valueOf(out) + "  ( " + resultats.formatFloat(resultats.getMoyenne("LMNN Malhalanobis, knn" + knn, "TauxTraining"));
            out = String.valueOf(out) + " +/- " + resultats.formatFloat(resultats.getEcartType("LMNN Malhalanobis, knn" + knn, "TauxTraining")) + " )";
            resultats.afficherln(out, psout, verbose);
            out = "Energy classification : " + resultats.formatFloat(resultats.getMoyenne("Energy classification, knn" + knn, "TauxError"));
            out = String.valueOf(out) + " +/- " + resultats.formatFloat(resultats.getEcartType("Energy classification, knn" + knn, "TauxError"));
            resultats.afficherln(out, psout, verbose);
            out = "LMNN Training Time : " + resultats.formatFloat(resultats.getMoyenne("LMNN Training, knn" + knn, "Time"));
            out = String.valueOf(out) + " +/- " + resultats.formatFloat(resultats.getEcartType("LMNN Training, knn" + knn, "Time"));
            resultats.afficherln(out, psout, verbose);
        }
    }

    @Override
    public synchronized int getDetailAff() {
        return this.detailAff;
    }

    @Override
    public synchronized void setDetailAff(int detailAff) {
        this.detailAff = detailAff;
    }
}

