/*
 * Decompiled with CFR 0.152.
 */
package explorer.bridge;

import explorer.data.Common;
import explorer.data.DataManager;
import explorer.data.SourceAttrVal;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import json.JSONArray;
import json.JSONException;
import json.JSONObject;
import lib3d4j.data.DescriptionData;

public class SocketControler
implements Runnable {
    private static final int DEFAULT_PORT = 50000;
    private ServerSocket listener;
    private boolean finished = false;
    private DescriptionData dd = DataManager.getSingleton().getCompAttr();

    public SocketControler() {
        this(50000);
    }

    public SocketControler(int port) {
        try {
            this.listener = new ServerSocket(port);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Socket controller started on port " + port);
        new Thread(this).start();
    }

    public void stop() {
        this.finished = true;
    }

    @Override
    public void run() {
        try {
            while (!this.finished) {
                String nextcmd;
                System.out.println("Socket controller waiting for a client");
                Socket client = this.listener.accept();
                System.out.println("Socket controller client connected");
                InputStream input = client.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                while (!this.finished && (nextcmd = reader.readLine()) != null) {
                    int nbobj;
                    JSONArray jsoa;
                    JSONObject jso = new JSONObject(nextcmd);
                    String cmdName = jso.getString("msg");
                    if (cmdName.equals("set-data")) {
                        jsoa = jso.getJSONArray("val");
                        nbobj = jsoa.length();
                        if (nbobj == 0) continue;
                        int nbdim = jsoa.getJSONArray(0).length();
                        float[][] data = new float[nbobj][nbdim];
                        int i = 0;
                        while (i < nbobj) {
                            JSONArray line = jsoa.getJSONArray(i);
                            nbdim = line.length();
                            int j = 0;
                            while (j < nbdim) {
                                data[i][j] = (float)line.getDouble(j);
                                ++j;
                            }
                            ++i;
                        }
                        SourceAttrVal src = DataManager.getSingleton().createSourceAttrVal(data);
                        Common.getSingleton().postLoad(null, src);
                        continue;
                    }
                    if (cmdName.equals("set-classes")) {
                        jsoa = jso.getJSONArray("val");
                        nbobj = jsoa.length();
                        if (nbobj == 0) continue;
                        float[] fres = new float[nbobj];
                        int i = 0;
                        while (i < nbobj) {
                            fres[i] = jsoa.getInt(i);
                            ++i;
                        }
                        int nbclas = jso.getInt("nbclasses");
                        if (nbclas == 0) continue;
                        ArrayList<Object> classes = new ArrayList<Object>();
                        int i2 = 0;
                        while (i2 < nbclas) {
                            classes.add("" + i2);
                            ++i2;
                        }
                        this.dd.dropColumn("AUTO_SOCKIN");
                        this.dd.addColumn(fres, classes, "AUTO_SOCKIN");
                        DataManager.getSingleton().setClassAttribute("AUTO_SOCKIN");
                        DataManager.getSingleton().setColorAttribute("AUTO_SOCKIN");
                        continue;
                    }
                    if (!cmdName.equals("set-classes-fast") || (nbobj = (jsoa = jso.getJSONArray("val")).length()) == 0) continue;
                    int rank = 0;
                    int att = this.dd.getColumnIndex("AUTO_SOCKIN");
                    if (att == -1) {
                        System.out.println("no class atttribute defined");
                        continue;
                    }
                    int[] objlarge = new int[nbobj];
                    int[] vallarge = new int[nbobj];
                    int cpt = 0;
                    int i = 0;
                    while (i < nbobj) {
                        int val = jsoa.getInt(i);
                        if (val < 0) {
                            rank += -val;
                        } else {
                            objlarge[cpt] = rank++;
                            vallarge[cpt] = val;
                            ++cpt;
                        }
                        ++i;
                    }
                    int[] objs = Arrays.copyOf(objlarge, cpt);
                    int[] vals = Arrays.copyOf(vallarge, cpt);
                    this.dd.setParamValues(objs, att, vals);
                }
                System.out.println("socket controller client deconnected");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        System.out.println("Socket controller stoppped");
    }
}

