/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.classification;

import explorer.batch.Test;
import explorer.compute.classification.AbstractExploration;
import explorer.compute.compute.projection.PMAttrVal;
import explorer.compute.compute.projection.PMFactory;
import explorer.compute.tools.OutilsStatistiques;
import explorer.data.Common;
import explorer.data.SourceAttrVal;
import lib3d4j.compute.tools.OutilsAlgebre;

public class ExplorationEllipsoidale
extends AbstractExploration {
    int nbClasse = 0;
    int nbTotal = 0;
    public static int nbMinProcheVoisins;
    public static float distanceMax;

    public ExplorationEllipsoidale(Common c, SourceAttrVal src, int[] dims, String nom) {
        this.parent = c;
        this.src = src;
        this.dims = dims;
        this.resultatClassification = new boolean[40][];
        int nbCrop = 0;
        while (nbCrop < 40) {
            if (nbCrop == 10) {
                int i = 0;
                ++i;
            }
            int[] cross = Test.loadGen(this.dd.getNbDescrObjects(), String.valueOf(nom) + ".CV_" + (nbCrop + 1));
            this.visuGlobale = PMFactory.getSingleton().createPMAV(src, numeroMethode);
            this.visuGlobale.setCrossValidation(cross, 1);
            this.visuGlobale.calculer();
            this.visuGlobale.initialiserDataProjected(dims);
            int cptTest = 0;
            int i = 0;
            while (i < this.dd.getNbDescrObjects()) {
                if (cross[i] == 1) {
                    ++cptTest;
                }
                ++i;
            }
            this.indiceTest = new int[cptTest];
            this.indiceAppr = new int[this.dd.getNbDescrObjects() - cptTest];
            cptTest = 0;
            int cptApp = 0;
            int i2 = 0;
            while (i2 < this.dd.getNbDescrObjects()) {
                if (cross[i2] == 1) {
                    this.indiceTest[cptTest] = i2;
                    ++cptTest;
                } else {
                    this.indiceAppr[cptApp] = i2;
                    ++cptApp;
                }
                ++i2;
            }
            this.apprendre(dims);
            boolean[] testLocal = this.tester(dims);
            this.resultatClassification[nbCrop] = testLocal;
            ++nbCrop;
        }
        this.genererStatistiques();
    }

    public PMAttrVal decouperSousVisualisation(float[] point) {
        float[][] pointsVisuGlobale = this.visuGlobale.getDataProjectedActifs();
        PMAttrVal pm = PMFactory.getSingleton().createPMAV(this.src, numeroMethode);
        int i = 0;
        while (i < this.indiceTest.length) {
            pm.setActivite(this.indiceTest[i], false);
            ++i;
        }
        float[] longueursEllipse = new float[this.dims.length];
        int i2 = 0;
        while (i2 < this.dims.length) {
            float[] dimLocale = new float[this.dims.length];
            dimLocale[this.dims[i2]] = 1.0f;
            longueursEllipse[i2] = distanceMax * OutilsAlgebre.meanDistanceToCenterAlongAxes(pointsVisuGlobale, dimLocale);
            ++i2;
        }
        i2 = 0;
        while (i2 < pointsVisuGlobale.length) {
            pm.setActivite(this.indiceAppr[i2], OutilsAlgebre.isInEllipsoid(pointsVisuGlobale[i2], point, longueursEllipse));
            ++i2;
        }
        return pm;
    }

    public void apprendre(int[] dims) {
    }

    public boolean[] tester(int[] dims) {
        boolean[] b = new boolean[this.indiceTest.length];
        int i = 0;
        while (i < this.indiceTest.length) {
            b[i] = this.tester(this.indiceTest[i], dims);
            ++i;
        }
        return b;
    }

    @Override
    public int tester(float[] pointEspaceInitial) {
        float[] point = this.visuGlobale.projection(pointEspaceInitial, this.dims);
        PMAttrVal visuLocale = this.decouperSousVisualisation(point);
        ++this.nbTotal;
        if (visuLocale.getNbActifs() <= nbMinProcheVoisins) {
            return this.dd.getClassIndice(this.visuGlobale.numeroPlusProcheActif(point));
        }
        ++this.nbClasse;
        visuLocale.calculer();
        visuLocale.initialiserDataProjected(this.dims);
        return this.dd.getClassIndice(visuLocale.numeroPlusProcheActif(visuLocale.projection(pointEspaceInitial, this.dims)));
    }

    @Override
    public void genererStatistiques() {
        float pourcentageBienPlace = OutilsStatistiques.pourcentageVrai(this.resultatClassification);
        System.out.println(" " + pourcentageBienPlace + " " + numeroMethode + " " + nbMinProcheVoisins);
    }

    public void supprimerVisuLocale(int i) {
        PMAttrVal[] pm = new PMAttrVal[this.visuLocales.length - 1];
        int j = 0;
        while (j < i) {
            pm[j] = this.visuLocales[j];
            ++j;
        }
        j = i + 1;
        while (j < pm.length + 1) {
            pm[j - 1] = this.visuLocales[j];
            ++j;
        }
        this.visuLocales = pm;
    }
}

