/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.classification;

import java.util.ArrayList;
import java.util.Arrays;
import lib3d4j.compute.tools.OutilsAlgebre;

public class Minkowski {
    protected float[][] points;
    protected int[] classe;
    protected int nbclasses;
    protected int nbpoints;
    protected float meandist = 0.0f;
    protected float defthresh = 60.0f;
    protected float stepthresh = 0.1f;
    protected float[][] md;
    protected boolean[][] graph;
    protected int[] degree;

    public Minkowski(float[][] p) {
        this.points = p;
        this.nbpoints = p.length;
        this.meandist = 0.0f;
        float maxdist = 0.0f;
        this.md = new float[this.nbpoints][this.nbpoints];
        int i = 0;
        while (i < this.nbpoints) {
            this.md[i][i] = 0.0f;
            int j = i + 1;
            while (j < this.nbpoints) {
                float f = OutilsAlgebre.distance(this.points[i], this.points[j]);
                this.md[j][i] = f;
                this.md[i][j] = f;
                this.meandist += f;
                if (maxdist < this.md[i][j]) {
                    maxdist = this.md[i][j];
                }
                ++j;
            }
            ++i;
        }
        this.meandist /= (float)(this.nbpoints * this.nbpoints / 2 - this.nbpoints);
        this.defthresh = this.meandist;
        this.stepthresh = (maxdist - this.meandist) / 10.0f;
    }

    public Minkowski(float[][] p, int nbclasses) {
        this(p);
        float tr = this.defthresh;
        this.compute(tr);
        if (this.nbclasses != nbclasses) {
            boolean dirsup = this.nbclasses > nbclasses;
            int cpt = 0;
            do {
                if (this.nbclasses > nbclasses) {
                    if (!dirsup) break;
                    tr += this.stepthresh;
                } else {
                    if (dirsup) break;
                    tr -= this.stepthresh;
                }
                System.out.println("tr " + tr);
                this.compute(tr);
            } while (cpt < 20 && this.nbclasses != nbclasses);
        }
    }

    public Minkowski(float[][] p, float thresh) {
        this(p);
        this.compute(thresh);
    }

    public int compute(float thresh) {
        int i;
        int colorn;
        int i2;
        int j;
        int maxidx = 0;
        int maxdeg = 0;
        this.graph = new boolean[this.nbpoints][this.nbpoints];
        this.degree = new int[this.nbpoints];
        int i3 = 0;
        while (i3 < this.nbpoints) {
            this.graph[i3][i3] = false;
            j = i3 + 1;
            while (j < this.nbpoints) {
                boolean bl = this.md[i3][j] >= thresh;
                this.graph[j][i3] = bl;
                this.graph[i3][j] = bl;
                ++j;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < this.nbpoints) {
            this.degree[i3] = 0;
            j = 0;
            while (j < this.nbpoints) {
                if (this.graph[i3][j]) {
                    int n = i3;
                    this.degree[n] = this.degree[n] + 1;
                }
                ++j;
            }
            if (this.degree[i3] > maxdeg) {
                maxdeg = this.degree[i3];
                maxidx = i3;
            }
            ++i3;
        }
        this.nbclasses = maxdeg + 1;
        this.classe = new int[this.nbpoints];
        Arrays.fill(this.classe, -1);
        int[] T = new int[this.nbpoints];
        Arrays.fill(T, -1);
        T[0] = maxidx;
        this.classe[maxidx] = 0;
        int tlast = 1;
        ArrayList<Integer> domcol = new ArrayList<Integer>();
        do {
            int j2;
            int vi = T[0];
            int q = 0;
            int[] colors = new int[this.degree[vi] + 1];
            int nbcols = 1;
            colors[0] = this.classe[vi];
            i2 = 0;
            while (i2 < this.nbpoints) {
                if (this.graph[vi][i2] && (colorn = this.classe[i2]) != -1) {
                    j2 = 1;
                    while (j2 < nbcols) {
                        if (colors[j2] == colorn) break;
                        ++j2;
                    }
                    if (j2 == nbcols) {
                        colors[nbcols++] = colorn;
                    }
                }
                ++i2;
            }
            boolean[] usedvi = new boolean[this.nbclasses];
            Arrays.fill(usedvi, false);
            int j3 = 0;
            while (j3 < nbcols) {
                usedvi[colors[j3]] = true;
                ++j3;
            }
            int vj = 0;
            while (vj < this.nbpoints) {
                if (this.graph[vi][vj] && this.classe[vj] == -1) {
                    int k = q + 1;
                    boolean[] usedvj = new boolean[this.nbclasses];
                    Arrays.fill(usedvi, false);
                    int j4 = 0;
                    while (j4 < this.nbpoints) {
                        if (this.graph[vj][j4] && this.classe[j4] != -1) {
                            usedvj[this.classe[j4]] = true;
                        }
                        ++j4;
                    }
                    while (k < this.nbclasses && usedvi[k] && usedvj[k]) {
                        ++k;
                    }
                    q = k;
                    if (q < this.nbclasses) {
                        this.classe[vj] = q;
                    } else {
                        k = 0;
                        while (k < this.nbclasses && usedvj[k]) {
                            ++k;
                        }
                        this.classe[vj] = k;
                    }
                    T[tlast++] = vj;
                    int ti = 1;
                    while (ti < tlast) {
                        int tj = ti;
                        while (tj - 1 > 0 && this.degree[T[tj - 1]] < this.degree[T[ti]]) {
                            --tj;
                        }
                        if (ti != tj) {
                            int temp = T[ti];
                            int tk = ti;
                            while (tk > tj) {
                                T[tk] = T[tk - 1];
                                --tk;
                            }
                            T[tj] = temp;
                        }
                        ++ti;
                    }
                }
                ++vj;
            }
            usedvi = new boolean[this.nbclasses];
            Arrays.fill(usedvi, false);
            i2 = 0;
            while (i2 < this.nbpoints) {
                if (vi == i2 || this.graph[vi][i2]) {
                    usedvi[this.classe[i2]] = true;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < this.nbclasses) {
                if (!usedvi[i2]) break;
                ++i2;
            }
            if (i2 == this.nbclasses) {
                domcol.add(this.classe[vi]);
            }
            i2 = 0;
            while (T[i2] != vi) {
                ++i2;
            }
            j2 = i2;
            while (j2 < this.nbpoints - 1) {
                T[j2] = T[j2 + 1];
                ++j2;
            }
            T[this.nbpoints - 1] = -1;
        } while (--tlast > 0);
        int outclass = 0;
        boolean out = false;
        if (!domcol.isEmpty()) {
            outclass = (Integer)domcol.get(0);
            out = true;
        } else {
            int[] card = new int[this.nbclasses];
            Arrays.fill(card, 0);
            int[] j5 = this.classe;
            i2 = this.classe.length;
            colorn = 0;
            while (colorn < i2) {
                int cl = j5[colorn];
                if (cl != -1) {
                    int n = cl;
                    card[n] = card[n] + 1;
                } else {
                    out = true;
                }
                ++colorn;
            }
            if (out) {
                outclass = 0;
                int outcard = card[0];
                i = 1;
                while (i < this.nbclasses) {
                    if (card[i] > outcard) {
                        outcard = card[i];
                        outclass = i;
                    }
                    ++i;
                }
            }
        }
        if (out) {
            int i4 = 0;
            while (i4 < this.nbpoints) {
                if (this.classe[i4] == -1) {
                    this.classe[i4] = outclass;
                }
                ++i4;
            }
        }
        int nbndm = 0;
        boolean[] ndm = new boolean[this.nbclasses];
        i = 0;
        while (i < this.nbclasses) {
            ndm[i] = !domcol.contains(i);
            if (ndm[i]) {
                ++nbndm;
            }
            ++i;
        }
        if (nbndm > 0) {
            int maxN = this.nbclasses - 1;
            boolean[] inL = new boolean[this.nbclasses];
            Arrays.fill(inL, true);
            int cardL = this.nbclasses;
            do {
                int j6;
                int q = maxN;
                while (!ndm[q]) {
                    --q;
                }
                maxN = q - 1;
                inL[q] = false;
                --cardL;
                ndm[q] = false;
                --nbndm;
                int vi = 0;
                while (vi < this.nbpoints) {
                    if (this.classe[vi] == q) {
                        boolean[] kset = Arrays.copyOf(inL, this.nbclasses);
                        j6 = 0;
                        while (j6 < this.nbpoints) {
                            if (this.graph[vi][j6]) {
                                kset[this.classe[j6]] = false;
                            }
                            ++j6;
                        }
                        int jstart = 0;
                        while (jstart < this.nbpoints && !kset[this.classe[jstart]]) {
                            ++jstart;
                        }
                        float mindist = this.md[vi][jstart];
                        int mincol = this.classe[jstart];
                        int j7 = jstart + 1;
                        while (j7 < this.nbpoints) {
                            if (kset[this.classe[j7]] && this.md[vi][j7] < mindist) {
                                mindist = this.md[vi][j7];
                                mincol = this.classe[j7];
                            }
                            ++j7;
                        }
                        this.classe[vi] = mincol;
                    }
                    ++vi;
                }
                int vj = 0;
                while (vj < this.nbpoints) {
                    if (ndm[this.classe[vj]]) {
                        boolean[] colN = new boolean[this.nbclasses];
                        Arrays.fill(colN, false);
                        j6 = 0;
                        while (j6 < this.nbpoints) {
                            if (this.graph[vj][j6]) {
                                colN[this.classe[j6]] = true;
                            }
                            ++j6;
                        }
                        int nbcv = 0;
                        int i5 = 0;
                        while (i5 < this.nbclasses) {
                            if (colN[i5]) {
                                ++nbcv;
                            }
                            ++i5;
                        }
                        if (nbcv == cardL - 1) {
                            domcol.add(this.classe[vj]);
                            ndm[this.classe[vj]] = false;
                            --nbndm;
                        }
                    }
                    ++vj;
                }
            } while (nbndm > 0);
        }
        int[] remcols = new int[domcol.size()];
        int i6 = 0;
        while (i6 < domcol.size()) {
            remcols[i6] = (Integer)domcol.get(i6);
            ++i6;
        }
        Arrays.sort(remcols);
        int maxcol = remcols[remcols.length - 1];
        int[] conv = new int[maxcol + 1];
        int newclass = 0;
        int[] nArray = remcols;
        int n = remcols.length;
        int n2 = 0;
        while (n2 < n) {
            int rem = nArray[n2];
            conv[rem] = newclass++;
            ++n2;
        }
        int i7 = 0;
        while (i7 < this.nbpoints) {
            this.classe[i7] = conv[this.classe[i7]];
            ++i7;
        }
        this.print(this.classe);
        this.nbclasses = newclass;
        System.out.println("nbclasses " + this.nbclasses);
        return this.nbclasses;
    }

    public int[] getClasses() {
        return this.classe;
    }

    public int getNbClasses() {
        return this.nbclasses;
    }

    private void print(int[] g) {
        int[] nArray = g;
        int n = g.length;
        int n2 = 0;
        while (n2 < n) {
            int elem = nArray[n2];
            System.out.print(String.valueOf(elem) + " ");
            ++n2;
        }
        System.out.println();
    }
}

