/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.classification;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class Octree {
    public static final int NODE = 0;
    public static final int MINUS = 1;
    public static final int PLUS = 2;
    public static final int EMPTY = 3;
    public static float xmin = -1.0f;
    public static float xsize = 2.0f;
    public static float ymin = -1.0f;
    public static float ysize = 2.0f;
    public static float zmin = -1.0f;
    public static float zsize = 2.0f;
    public static int MAXDEPTH = 5;
    static Hashtable<Long, Octree> index;
    protected int depth;
    protected float x;
    protected float y;
    protected float z;
    protected long indice;
    protected int sign;
    protected Octree[] children;

    public Octree(List<float[]> plus, List<float[]> minus) {
        this(plus, minus, 0, xmin, ymin, zmin, 0L);
    }

    public Octree(List<float[]> plus, List<float[]> minus, int depth, float x, float y, float z, long indice) {
        this.depth = depth;
        this.x = x;
        this.y = y;
        this.z = z;
        this.indice = indice;
        this.children = null;
        int cardPlus = plus.size();
        int cardMinus = minus.size();
        if (cardMinus == 0 && cardPlus == 0) {
            this.sign = 3;
        } else if (depth == MAXDEPTH) {
            this.sign = cardMinus == 0 && cardPlus == 0 ? 3 : (cardMinus > cardPlus ? 1 : 2);
        } else {
            this.sign = 0;
            float step = (float)Math.pow(2.0, depth + 1);
            float midX = x + xsize / step;
            float midY = y + ysize / step;
            float midZ = z + zsize / step;
            ArrayList[] subPlus = new ArrayList[8];
            int i = 0;
            while (i < 8) {
                subPlus[i] = new ArrayList();
                ++i;
            }
            for (float[] plusElem : plus) {
                int indiceP = 0;
                if (plusElem[0] > midX) {
                    ++indiceP;
                }
                if (plusElem[1] > midY) {
                    indiceP += 2;
                }
                if (plusElem[2] > midZ) {
                    indiceP += 4;
                }
                subPlus[indiceP].add(plusElem);
            }
            ArrayList[] subMinus = new ArrayList[8];
            int i2 = 0;
            while (i2 < 8) {
                subMinus[i2] = new ArrayList();
                ++i2;
            }
            for (float[] minusElem : minus) {
                int indiceM = 0;
                if (minusElem[0] > midX) {
                    ++indiceM;
                }
                if (minusElem[1] > midY) {
                    indiceM += 2;
                }
                if (minusElem[2] > midZ) {
                    indiceM += 4;
                }
                subMinus[indiceM].add(minusElem);
            }
            this.children = new Octree[8];
            int nbplus = 0;
            int nbminus = 0;
            int i3 = 0;
            while (i3 < 8) {
                float subX = x + ((i3 & 1) != 0 ? midX - x : 0.0f);
                float subY = y + ((i3 & 2) != 0 ? midY - y : 0.0f);
                float subZ = z + ((i3 & 4) != 0 ? midZ - z : 0.0f);
                this.children[i3] = new Octree(subPlus[i3], subMinus[i3], depth + 1, subX, subY, subZ, indice << 3 & (long)i3);
                if (this.children[i3].sign == 2) {
                    ++nbplus;
                } else if (this.children[i3].sign == 1) {
                    ++nbminus;
                }
                ++i3;
            }
            if (nbplus == 8) {
                this.sign = 2;
            } else if (nbminus == 8) {
                this.sign = 1;
            }
        }
    }

    public List<float[]> getCubesByCenter() {
        ArrayList<float[]> cubes = new ArrayList<float[]>();
        if (this.sign == 0) {
            Octree[] octreeArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                Octree child = octreeArray[n2];
                List<float[]> cubesfils = child.getCubesByCenter();
                for (float[] cf : cubesfils) {
                    cubes.add(cf);
                }
                ++n2;
            }
        } else if (this.sign == 2) {
            float[] coord = new float[6];
            float step = xsize / (float)Math.pow(2.0, this.depth + 1);
            coord[0] = this.x + step;
            coord[1] = this.y + step;
            coord[2] = this.z + step;
            coord[4] = coord[5] = step;
            coord[3] = coord[5];
            System.out.println(String.valueOf(coord[0]) + " " + coord[1] + " " + coord[2] + " " + step);
            cubes.add(coord);
        }
        return cubes;
    }

    public String toString() {
        return this.trace("");
    }

    private long getIndiceNeighbourg(int x, int y, int z, long indice) {
        long exp;
        boolean depth = false;
        long indiceN = indice;
        if (x == 1) {
            exp = 1L;
            while ((indiceN & exp) != 0L) {
                indiceN ^= exp;
                exp <<= 3;
            }
            indiceN |= exp;
        } else if (x == -1) {
            exp = 1L;
            while ((indiceN & exp) == 0L) {
                indiceN |= exp;
                exp <<= 3;
            }
            indiceN ^= exp;
        }
        if (y == 1) {
            exp = 2L;
            while ((indiceN & exp) != 0L) {
                indiceN ^= exp;
                exp <<= 3;
            }
            indiceN |= exp;
        } else if (y == -1) {
            exp = 2L;
            while ((indiceN & exp) == 0L) {
                indiceN |= exp;
                exp <<= 3;
            }
            indiceN ^= exp;
        }
        if (z == 1) {
            exp = 4L;
            while ((indiceN & exp) != 0L) {
                indiceN ^= exp;
                exp <<= 3;
            }
            indiceN |= exp;
        } else if (z == -1) {
            exp = 4L;
            while ((indiceN & exp) == 0L) {
                indiceN |= exp;
                exp <<= 3;
            }
            indiceN ^= exp;
        }
        return indiceN;
    }

    protected String trace(String dt) {
        dt = String.valueOf(dt) + ".";
        switch (this.sign) {
            case 3: {
                return String.valueOf(dt) + " /";
            }
            case 2: {
                return String.valueOf(dt) + " +";
            }
            case 1: {
                return String.valueOf(dt) + " -";
            }
        }
        StringBuffer retour = new StringBuffer();
        Octree[] octreeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            Octree child = octreeArray[n2];
            retour.append(child.trace(dt));
            retour.append("\n");
            ++n2;
        }
        return retour.toString();
    }

    public static Octree getFromIndex(long indice) {
        return index.get(new Long(indice));
    }

    public static void addInIndex(Octree o) {
        index.put(new Long(o.indice), o);
    }

    public static void main(String[] args) {
    }
}

