/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.classification.dbscan;

import explorer.compute.classification.dbscan.RTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DBSCAN {
    private static int UNVISITED = -1;
    private static int VISITED = 0;
    private static int NOISE = 0;
    protected float[][] points;
    private int[] classes;
    float rayon = 0.12f;
    int pointsMin = 4;
    private int indexClust = 0;
    private RTree rt;

    public DBSCAN(float[][] p) {
        this.points = p;
        this.initClass();
    }

    public DBSCAN(float[][] p, float r, int m) {
        this.points = p;
        this.rayon = r;
        this.pointsMin = m;
        this.initClass();
        this.rt = new RTree(this.listePoints(this.points), this.pointsMin, this.rayon);
    }

    public ArrayList<float[]> listePoints(float[][] points) {
        ArrayList<float[]> pts = new ArrayList<float[]>();
        int i = 0;
        while (i < points.length) {
            float[] f = new float[]{points[i][0], points[i][1], points[i][2], i};
            pts.add(f);
            ++i;
        }
        return pts;
    }

    private void initClass() {
        this.classes = new int[this.points.length];
        Arrays.fill(this.classes, UNVISITED);
    }

    public void repartition() {
        this.indexClust = 1;
        int i = 0;
        while (i < this.points.length) {
            if (this.classes[i] == UNVISITED) {
                this.classes[i] = VISITED;
                List<Integer> voisins = this.regionQuery(i);
                if (voisins.size() >= this.pointsMin) {
                    this.expandCluster(i, voisins, this.indexClust);
                    ++this.indexClust;
                }
            }
            ++i;
        }
    }

    private void expandCluster(int p, List<Integer> vp, int c) {
        this.classes[p] = c;
        int vpcount = 0;
        while (vpcount < vp.size()) {
            int pprime = vp.get(vpcount);
            if (this.classes[pprime] == UNVISITED) {
                this.classes[pprime] = VISITED;
                List<Integer> vprime = this.regionQuery(pprime);
                if (vprime.size() >= this.pointsMin) {
                    for (int psec : vprime) {
                        if (vp.contains(psec)) continue;
                        vp.add(psec);
                    }
                }
            }
            if (this.classes[pprime] == VISITED) {
                this.classes[pprime] = c;
            }
            ++vpcount;
        }
    }

    private List<Integer> regionQuery(int p) {
        return this.rt.getVoisins(this.points[p], p);
    }

    public int[] getClasses() {
        return this.classes;
    }

    public int getNbClasses() {
        return this.indexClust;
    }
}

