/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.classification.dbscan;

import java.util.ArrayList;
import java.util.List;

public class RTree {
    private int capacite;
    private float radius;
    private float sqRadius;
    private Node root;

    public RTree(List<float[]> points, int max, float r) {
        this.capacite = max;
        this.radius = r;
        this.sqRadius = r * r;
        this.root = new LeafNode(new Point(points.get(0), 0));
        int i = 1;
        while (i < points.size()) {
            this.root = this.root.insert(new Point(points.get(i), i));
            ++i;
        }
    }

    public List<Integer> getVoisins(float[] point, int index) {
        return this.root.getNeighbors(new Point(point, index), new ArrayList<Integer>());
    }

    public String toString() {
        return this.root.toString(0);
    }

    private class InternalNode
    extends Node {
        private List<Node> children;

        public InternalNode() {
            this.children = new ArrayList<Node>();
        }

        public InternalNode(Node n) {
            this();
            this.children.add(n);
            this.dims = (float[][])n.dims.clone();
            this.center = (float[])n.center.clone();
        }

        @Override
        protected Node insertInternal(Point point) {
            Node added;
            this.fitPoint(point.coords);
            Node nearest = this.children.get(0);
            float dnearest = nearest.sqDistance(point.coords);
            if (dnearest > 0.0f) {
                int i = 1;
                while (i < this.children.size()) {
                    Node child = this.children.get(i);
                    float dc = child.sqDistance(point.coords);
                    if (dc < dnearest) {
                        nearest = child;
                        dnearest = dc;
                        if (dnearest == 0.0f) break;
                    }
                    ++i;
                }
            }
            if ((added = nearest.insertInternal(point)) == null) {
                return null;
            }
            if (this.children.size() < RTree.this.capacite) {
                this.children.add(added);
                return null;
            }
            int rankFirst = 0;
            int rankSecond = 0;
            double dist = 0.0;
            int i = 0;
            while (i < RTree.this.capacite) {
                float[] point1 = this.children.get((int)i).center;
                int j = i + 1;
                while (j < RTree.this.capacite) {
                    float[] point2 = this.children.get((int)j).center;
                    double distij = Math.sqrt((point1[0] - point2[0]) * (point1[0] - point2[0]) + (point1[1] - point2[1]) * (point1[1] - point2[1]) + (point1[2] - point2[2]) * (point1[2] - point2[2]));
                    if (distij > dist) {
                        dist = distij;
                        rankFirst = i;
                        rankSecond = j;
                    }
                    ++j;
                }
                ++i;
            }
            InternalNode n2 = new InternalNode(this.children.remove(rankSecond));
            InternalNode n1 = new InternalNode(this.children.remove(rankFirst));
            for (Node p : this.children) {
                if (n1.sqDistance(p.center) < n2.sqDistance(p.center)) {
                    n1.addNode(p);
                    continue;
                }
                n2.addNode(p);
            }
            if (n1.sqDistance(added.center) < n2.sqDistance(added.center)) {
                n1.addNode(added);
            } else {
                n2.addNode(added);
            }
            this.children = n1.children;
            this.dims = n1.dims;
            this.center = n1.center;
            return n2;
        }

        @Override
        public List<Integer> getNeighbors(Point point, List<Integer> list) {
            for (Node n : this.children) {
                if (!n.potentialNeighbors(point.coords)) continue;
                list = n.getNeighbors(point, list);
            }
            return list;
        }

        public void addNode(Node n) {
            this.children.add(n);
            int i = 0;
            while (i < 3) {
                if (n.dims[i][0] < this.dims[i][0]) {
                    this.dims[i][0] = n.dims[i][0];
                }
                if (n.dims[i][1] > this.dims[i][1]) {
                    this.dims[i][1] = n.dims[i][1];
                }
                this.center[i] = (this.dims[i][1] - this.dims[i][0]) / 2.0f;
                ++i;
            }
        }

        @Override
        public String toString(int offset) {
            StringBuilder res = new StringBuilder();
            int i = 0;
            while (i < offset) {
                res.append(" ");
                ++i;
            }
            res.append("I" + super.toString() + "\n");
            for (Node n : this.children) {
                res.append(String.valueOf(n.toString(offset + 2)) + "\n");
            }
            return res.toString();
        }
    }

    private class LeafNode
    extends Node {
        private List<Point> children;

        public LeafNode(Point p) {
            this.children = new ArrayList<Point>(RTree.this.capacite);
            this.children.add(p);
            int i = 0;
            while (i < 3) {
                float f = p.coords[i];
                this.dims[i][1] = f;
                this.dims[i][0] = f;
                this.center[i] = f;
                ++i;
            }
        }

        @Override
        protected Node insertInternal(Point point) {
            this.fitPoint(point.coords);
            if (this.children.size() < RTree.this.capacite) {
                this.children.add(point);
                return null;
            }
            int rankFirst = 0;
            int rankSecond = 0;
            double dist = 0.0;
            int i = 0;
            while (i < RTree.this.capacite) {
                float[] point1 = this.children.get((int)i).coords;
                int j = i + 1;
                while (j < RTree.this.capacite) {
                    float[] point2 = this.children.get((int)j).coords;
                    double distij = (point1[0] - point2[0]) * (point1[0] - point2[0]) + (point1[1] - point2[1]) * (point1[1] - point2[1]) + (point1[2] - point2[2]) * (point1[2] - point2[2]);
                    if (distij > dist) {
                        dist = distij;
                        rankFirst = i;
                        rankSecond = j;
                    }
                    ++j;
                }
                ++i;
            }
            LeafNode n2 = new LeafNode(this.children.remove(rankSecond));
            LeafNode n1 = new LeafNode(this.children.remove(rankFirst));
            for (Point p : this.children) {
                if (n1.sqDistance(p.coords) < n2.sqDistance(p.coords)) {
                    n1.insertInternal(p);
                    continue;
                }
                n2.insertInternal(p);
            }
            if (n1.sqDistance(point.coords) < n2.sqDistance(point.coords)) {
                n1.insertInternal(point);
            } else {
                n2.insertInternal(point);
            }
            this.children = n1.children;
            this.dims = n1.dims;
            this.center = n1.center;
            return n2;
        }

        @Override
        public List<Integer> getNeighbors(Point point, List<Integer> list) {
            for (Point p : this.children) {
                if (p.index == point.index || !((p.coords[0] - point.coords[0]) * (p.coords[0] - point.coords[0]) + (p.coords[1] - point.coords[1]) * (p.coords[1] - point.coords[1]) + (p.coords[2] - point.coords[2]) * (p.coords[2] - point.coords[2]) <= RTree.this.sqRadius)) continue;
                list.add(p.index);
            }
            return list;
        }

        @Override
        public String toString(int offset) {
            StringBuilder res = new StringBuilder();
            int i = 0;
            while (i < offset) {
                res.append(" ");
                ++i;
            }
            res.append("L" + super.toString() + "\n");
            i = 0;
            while (i < offset) {
                res.append(" ");
                ++i;
            }
            for (Point p : this.children) {
                res.append(p.toString());
            }
            return res.toString();
        }
    }

    private abstract class Node {
        protected float[][] dims = new float[3][2];
        float[] center = new float[3];

        protected float sqDistance(float[] point) {
            if (point[0] >= this.dims[0][0] && point[0] <= this.dims[0][1] && point[1] >= this.dims[1][0] && point[1] <= this.dims[1][1] && point[2] >= this.dims[2][0] && point[2] <= this.dims[2][1]) {
                return 0.0f;
            }
            float d = 0.0f;
            int i = 0;
            while (i < 3) {
                d += (this.center[i] - point[i]) * (this.center[i] - point[i]);
                ++i;
            }
            return d;
        }

        public Node insert(Point point) {
            Node added = this.insertInternal(point);
            if (added != null) {
                InternalNode newroot = new InternalNode(this);
                newroot.addNode(added);
                return newroot;
            }
            return this;
        }

        protected abstract Node insertInternal(Point var1);

        public abstract List<Integer> getNeighbors(Point var1, List<Integer> var2);

        protected boolean potentialNeighbors(float[] point) {
            return point[0] >= this.dims[0][0] - RTree.this.radius && point[0] <= this.dims[0][1] + RTree.this.radius && point[1] >= this.dims[1][0] - RTree.this.radius && point[1] <= this.dims[1][1] + RTree.this.radius && point[2] >= this.dims[2][0] - RTree.this.radius && point[2] <= this.dims[2][1] + RTree.this.radius;
        }

        protected void fitPoint(float[] point) {
            int i = 0;
            while (i < 3) {
                if (this.dims[i][0] > point[i]) {
                    this.dims[i][0] = point[i];
                }
                if (this.dims[i][1] < point[i]) {
                    this.dims[i][1] = point[i];
                }
                this.center[i] = (this.dims[i][1] - this.dims[i][0]) / 2.0f;
                ++i;
            }
        }

        public String toString() {
            return "";
        }

        public abstract String toString(int var1);
    }

    private class Point {
        float[] coords;
        int index;

        public Point(float[] coords, int index) {
            this.coords = coords;
            this.index = index;
        }

        public String toString() {
            return "[" + this.index + "]";
        }
    }
}

