/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.classification.klustaKwik;

import explorer.compute.classification.klustaKwik.KlustaKwik;
import explorer.compute.classification.klustaKwik.KlustaSave;
import java.util.Vector;

public class KK {
    int nDims;
    int nDims2;
    int nStartingClusters;
    int nClustersAlive;
    int nPoints;
    int NoisePoint;
    boolean FullStep;
    float penaltyMix;
    float[] Data;
    float[] Weight;
    float[] Mean;
    float[] Cov;
    float[] LogP;
    int[] Class;
    int[] OldClass;
    int[] Class2;
    int[] BestClass;
    boolean[] ClassAlive;
    int[] AliveIndex;
    KlustaSave kSv;

    public KK(KlustaSave k) {
        this.kSv = k;
        this.AllocateArrays();
    }

    void AllocateArrays() {
        this.nDims2 = this.nDims * this.nDims;
        this.FullStep = true;
        this.NoisePoint = 1;
        this.Data = new float[this.nPoints * this.nDims];
        this.Weight = new float[100];
        this.Mean = new float[100 * this.nDims];
        this.Cov = new float[100 * this.nDims2];
        this.LogP = new float[100 * this.nPoints];
        int c = 0;
        while (c < 100) {
            int p = 0;
            while (p < this.nPoints) {
                this.LogP[c * this.nPoints + p] = 0.0f;
                ++p;
            }
            ++c;
        }
        this.Class = new int[this.nPoints];
        this.OldClass = new int[this.nPoints];
        this.Class2 = new int[this.nPoints];
        this.BestClass = new int[this.nPoints];
        this.ClassAlive = new boolean[100];
        this.AliveIndex = new int[100];
    }

    void AlocateCholeskyVecs() {
        this.kSv.pChol = new Vector();
        int i = 0;
        while (i < 100) {
            this.kSv.pChol.add(new float[this.nDims2]);
            ++i;
        }
        this.kSv.pBestChol = new Vector();
        i = 0;
        while (i < 100) {
            this.kSv.pBestChol.add(new float[this.nDims2]);
            ++i;
        }
    }

    void Reindex() {
        this.AliveIndex[0] = 0;
        this.nClustersAlive = 1;
        int c = 1;
        while (c < 100) {
            if (this.ClassAlive[c]) {
                this.AliveIndex[this.nClustersAlive] = c;
                ++this.nClustersAlive;
            }
            ++c;
        }
    }

    void LoadData(float[][] dav) {
        int i;
        int nFeatures;
        float max = 0.0f;
        float min = 0.0f;
        this.nPoints = dav.length;
        int UseLen = nFeatures = dav[0].length;
        this.kSv.nDims = this.nDims = dav[0].length;
        this.AllocateArrays();
        this.AlocateCholeskyVecs();
        int p = 0;
        while (p < this.nPoints) {
            int j = 0;
            i = 0;
            while (i < nFeatures) {
                this.Data[p * this.nDims + j] = dav[p][i];
                ++j;
                ++i;
            }
            ++p;
        }
        i = 0;
        while (i < this.nDims) {
            min = 1.0E32f;
            max = -1.0E32f;
            p = 0;
            while (p < this.nPoints) {
                float val = this.Data[p * this.nDims + i];
                if (val > max) {
                    max = val;
                }
                if (val < min) {
                    min = val;
                }
                ++p;
            }
            this.kSv.dataMin.add(Float.valueOf(min));
            this.kSv.dataMax.add(Float.valueOf(max));
            p = 0;
            while (p < this.nPoints) {
                this.Data[p * this.nDims + i] = (this.Data[p * this.nDims + i] - min) / (max - min);
                ++p;
            }
            i = 0;
            while (i < 100) {
                this.kSv.BestAliveIndex.add(new Integer(0));
                ++i;
            }
            ++i;
        }
    }

    float Penalty(int n) {
        if (n == 1) {
            return 0.0f;
        }
        int nParams = (this.nDims * (this.nDims + 1) / 2 + this.nDims + 1) * (n - 1);
        return (float)(1.0 - (double)this.penaltyMix) * (float)nParams * 2.0f + this.penaltyMix * ((float)nParams * (float)Math.log(this.nPoints) / 2.0f);
    }

    void MStep() {
        int j;
        int i;
        int[] nClassMembers = new int[100];
        float[] Vec2Mean = new float[this.nDims];
        int c = 0;
        while (c < 100) {
            nClassMembers[c] = 0;
            i = 0;
            while (i < this.nDims) {
                this.Mean[c * this.nDims + i] = 0.0f;
                ++i;
            }
            i = 0;
            while (i < this.nDims) {
                j = i;
                while (j < this.nDims) {
                    this.Cov[c * this.nDims2 + i * this.nDims + j] = 0.0f;
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.nDims) {
                j = 0;
                while (j < i) {
                    this.Cov[c * this.nDims2 + i * this.nDims + j] = 0.0f;
                    ++j;
                }
                ++i;
            }
            ++c;
        }
        System.out.print("");
        int p = 0;
        while (p < this.nPoints) {
            int n = this.Class[p];
            nClassMembers[n] = nClassMembers[n] + 1;
            ++p;
        }
        int cc = 0;
        while (cc < this.nClustersAlive) {
            c = this.AliveIndex[cc];
            if (c > 0 && nClassMembers[c] <= this.nDims) {
                this.ClassAlive[c] = false;
            }
            ++cc;
        }
        this.Reindex();
        cc = 0;
        while (cc < this.nClustersAlive) {
            c = this.AliveIndex[cc];
            this.Weight[c] = c == 0 ? ((float)nClassMembers[c] + (float)this.NoisePoint) / (float)(this.nPoints + this.NoisePoint) : (float)nClassMembers[c] / (float)(this.nPoints + this.NoisePoint);
            ++cc;
        }
        this.Reindex();
        p = 0;
        while (p < this.nPoints) {
            c = this.Class[p];
            i = 0;
            while (i < this.nDims) {
                int n = c * this.nDims + i;
                this.Mean[n] = this.Mean[n] + this.Data[p * this.nDims + i];
                ++i;
            }
            ++p;
        }
        cc = 0;
        while (cc < this.nClustersAlive) {
            c = this.AliveIndex[cc];
            if (nClassMembers[c] != 0) {
                i = 0;
                while (i < this.nDims) {
                    int n = c * this.nDims + i;
                    this.Mean[n] = this.Mean[n] / (float)nClassMembers[c];
                    ++i;
                }
            }
            ++cc;
        }
        p = 0;
        while (p < this.nPoints) {
            c = this.Class[p];
            i = 0;
            while (i < this.nDims) {
                Vec2Mean[i] = this.Data[p * this.nDims + i] - this.Mean[c * this.nDims + i];
                ++i;
            }
            i = 0;
            while (i < this.nDims) {
                j = i;
                while (j < this.nDims) {
                    int n = c * this.nDims2 + i * this.nDims + j;
                    this.Cov[n] = this.Cov[n] + Vec2Mean[i] * Vec2Mean[j];
                    ++j;
                }
                ++i;
            }
            ++p;
        }
        cc = 0;
        while (cc < this.nClustersAlive) {
            c = this.AliveIndex[cc];
            if (nClassMembers[c] > 1) {
                i = 0;
                while (i < this.nDims) {
                    j = i;
                    while (j < this.nDims) {
                        int n = c * this.nDims2 + i * this.nDims + j;
                        this.Cov[n] = this.Cov[n] / (float)(nClassMembers[c] - 1);
                        ++j;
                    }
                    ++i;
                }
            }
            ++cc;
        }
    }

    void EStep() {
        int cEStepCalls = 0;
        float[] Vec2Mean = new float[this.nDims];
        float[] Root = new float[this.nDims];
        float[] OptPtrLogP = new float[1];
        int[] OptPtrClass = this.Class;
        int[] OptPtrOldClass = this.OldClass;
        boolean Xdeb = false;
        boolean Ydeb = false;
        this.kSv.cEStepCallsLast = ++cEStepCalls;
        int nSkipped = 0;
        int p = 0;
        while (p < this.nPoints) {
            this.LogP[p * 100 + 0] = (float)(-Math.log(this.Weight[0]));
            ++p;
        }
        int cc = 1;
        while (cc < this.nClustersAlive) {
            int c = this.AliveIndex[cc];
            float[] f = new float[this.Cov.length - c * this.nDims2];
            int i = c * this.nDims2;
            while (i < this.Cov.length) {
                f[i - c * this.nDims2] = this.Cov[i];
                ++i;
            }
            if (this.Cholesky(f, this.kSv.pChol.get(c), this.nDims)) {
                i = c * this.nDims2;
                while (i < this.Cov.length) {
                    this.Cov[i] = f[i - c * this.nDims2];
                    ++i;
                }
                this.ClassAlive[c] = false;
            } else {
                Xdeb = false;
                float LogRootDet = 0.0f;
                i = 0;
                while (i < this.nDims) {
                    LogRootDet = (float)((double)LogRootDet + Math.log(this.kSv.pChol.get(c)[i * this.nDims + i]));
                    ++i;
                }
                p = 0;
                while (p < this.nPoints) {
                    Ydeb = Xdeb && p == 0;
                    OptPtrLogP = this.LogP;
                    if (!this.FullStep && OptPtrClass[p] == OptPtrOldClass[p] && OptPtrLogP[c + p * 100] - OptPtrLogP[OptPtrClass[p] + p * 100] > KlustaKwik.DistThresh) {
                        ++nSkipped;
                    } else {
                        float Mahal = 0.0f;
                        i = 0;
                        while (i < this.nDims) {
                            Vec2Mean[i] = this.Data[p * this.nDims + i] - this.Mean[c * this.nDims + i];
                            ++i;
                        }
                        this.TriSolve(this.kSv.pChol.get(c), Vec2Mean, Root, this.nDims);
                        i = 0;
                        while (i < this.nDims) {
                            Mahal += Root[i] * Root[i];
                            ++i;
                        }
                        OptPtrLogP[c + p * 100] = Mahal / 2.0f + LogRootDet - (float)Math.log(this.Weight[c]) + (float)Math.log(Math.PI * 2) * (float)this.nDims / 2.0f;
                    }
                    ++p;
                }
            }
            ++cc;
        }
    }

    void CStep() {
        float SecondScore = 0.0f;
        int p = 0;
        while (p < this.nPoints) {
            this.OldClass[p] = this.Class[p];
            float BestScore = 1.0E32f;
            SecondScore = 1.0E32f;
            int SecondClass = 0;
            int TopClass = 0;
            int cc = 0;
            while (cc < this.nClustersAlive) {
                int c = this.AliveIndex[cc];
                float ThisScore = this.LogP[p * 100 + c];
                if (ThisScore < BestScore) {
                    SecondClass = TopClass;
                    TopClass = c;
                    SecondScore = BestScore;
                    BestScore = ThisScore;
                } else if (ThisScore < SecondScore) {
                    SecondClass = c;
                    SecondScore = ThisScore;
                }
                ++cc;
            }
            this.Class[p] = TopClass;
            this.Class2[p] = SecondClass;
            ++p;
        }
    }

    void ConsiderDeletion() {
        int CandidateClass = 0;
        float[] DeletionLoss = new float[100];
        int c = 0;
        while (c < 100) {
            DeletionLoss[c] = this.ClassAlive[c] ? 0.0f : 1.0E32f;
            ++c;
        }
        int p = 0;
        while (p < this.nPoints) {
            int n = this.Class[p];
            DeletionLoss[n] = DeletionLoss[n] + (this.LogP[p * 100 + this.Class2[p]] - this.LogP[p * 100 + this.Class[p]]);
            ++p;
        }
        float Loss = 1.0E32f;
        c = 1;
        while (c < 100) {
            if (DeletionLoss[c] < Loss) {
                Loss = DeletionLoss[c];
                CandidateClass = c;
            }
            ++c;
        }
        float DeltaPen = this.Penalty(this.nClustersAlive) - this.Penalty(this.nClustersAlive - 1);
        if (Loss < DeltaPen) {
            this.ClassAlive[CandidateClass] = false;
            p = 0;
            while (p < this.nPoints) {
                if (this.Class[p] == CandidateClass) {
                    this.Class[p] = this.Class2[p];
                }
                ++p;
            }
        }
        this.Reindex();
    }

    public int TrySplits() {
        int DidSplit = 0;
        KK K2 = new KK(this.kSv);
        KK K3 = new KK(this.kSv);
        if (this.nClustersAlive >= 99) {
            return 0;
        }
        K3.nDims = this.nDims;
        K3.nPoints = this.nPoints;
        K3.AllocateArrays();
        K3.penaltyMix = 0.0f;
        int i = 0;
        while (i < this.nDims * this.nPoints) {
            K3.Data[i] = this.Data[i];
            ++i;
        }
        float Score = this.ComputeScore();
        int cc = 1;
        while (cc < this.nClustersAlive) {
            int c = this.AliveIndex[cc];
            K2.nPoints = 0;
            int p = 0;
            while (p < this.nPoints) {
                if (this.Class[p] == c) {
                    ++K2.nPoints;
                }
                ++p;
            }
            if (K2.nPoints != 0) {
                K2.nDims = this.nDims;
                K2.AllocateArrays();
                K2.penaltyMix = 0.0f;
                K2.NoisePoint = 0;
                int p2 = 0;
                p = 0;
                while (p < this.nPoints) {
                    if (this.Class[p] == c) {
                        int d = 0;
                        while (d < this.nDims) {
                            K2.Data[p2 * this.nDims + d] = this.Data[p * this.nDims + d];
                            ++d;
                        }
                        ++p2;
                    }
                    ++p;
                }
                int UnusedCluster = -1;
                int c2 = 1;
                while (c2 < 100) {
                    if (!this.ClassAlive[c2]) {
                        UnusedCluster = c2;
                        break;
                    }
                    ++c2;
                }
                if (UnusedCluster == -1) {
                    return DidSplit;
                }
                K2.nStartingClusters = 2;
                float UnsplitScore = K2.CEM(false);
                K2.nStartingClusters = 3;
                float SplitScore = K2.CEM(false);
                if (SplitScore < UnsplitScore) {
                    c2 = 0;
                    while (c2 < 100) {
                        K3.ClassAlive[c2] = false;
                        ++c2;
                    }
                    p2 = 0;
                    p = 0;
                    while (p < this.nPoints) {
                        if (this.Class[p] == c) {
                            if (K2.Class[p2] == 1) {
                                K3.Class[p] = c;
                            } else if (K2.Class[p2] == 2) {
                                K3.Class[p] = UnusedCluster;
                            } else {
                                ++p2;
                            }
                        } else {
                            K3.Class[p] = this.Class[p];
                        }
                        K3.ClassAlive[K3.Class[p]] = true;
                        ++p;
                    }
                    K3.Reindex();
                    K3.MStep();
                    K3.EStep();
                    float NewScore = K3.ComputeScore();
                    if (NewScore < Score) {
                        DidSplit = 1;
                        c2 = 0;
                        while (c2 < 100) {
                            this.ClassAlive[c2] = K3.ClassAlive[c2];
                            ++c2;
                        }
                        p = 0;
                        while (p < this.nPoints) {
                            this.Class[p] = K3.Class[p];
                            ++p;
                        }
                    }
                }
            }
            ++cc;
        }
        return DidSplit;
    }

    float ComputeScore() {
        float Score = this.Penalty(this.nClustersAlive);
        int p = 0;
        while (p < this.nPoints) {
            Score += this.LogP[p * 100 + this.Class[p]];
            ++p;
        }
        return Score;
    }

    float CEM(boolean Recurse) {
        int DidSplit;
        boolean LastStepFull;
        int nChanged;
        int p;
        int[] OldClass = new int[this.nPoints];
        float Score = 0.0f;
        if (this.nStartingClusters > 1) {
            p = 0;
            while (p < this.nPoints) {
                this.Class[p] = (int)(Math.random() * (double)this.nStartingClusters);
                ++p;
            }
        } else {
            p = 0;
            while (p < this.nPoints) {
                this.Class[p] = 0;
                ++p;
            }
        }
        int c = 0;
        while (c < 100) {
            this.ClassAlive[c] = c < this.nStartingClusters;
            ++c;
        }
        this.Reindex();
        int Iter = 0;
        this.FullStep = true;
        do {
            p = 0;
            while (p < this.nPoints) {
                OldClass[p] = this.Class[p];
                ++p;
            }
            this.MStep();
            this.EStep();
            this.CStep();
            if (Recurse) {
                this.ConsiderDeletion();
            }
            nChanged = 0;
            p = 0;
            while (p < this.nPoints) {
                if (OldClass[p] != this.Class[p]) {
                    ++nChanged;
                }
                ++p;
            }
            float OldScore = Score;
            Score = this.ComputeScore();
            LastStepFull = this.FullStep;
            boolean bl = this.FullStep = (float)nChanged > 0.05f * (float)this.nPoints || nChanged == 0 || ++Iter % 10 == 0;
            if (Iter > 500) break;
            DidSplit = Recurse && (Iter % 50 == 49 || nChanged == 0 && LastStepFull) ? this.TrySplits() : 0;
        } while (nChanged > 0 || !LastStepFull || DidSplit > 0);
        return Score;
    }

    void SaveBestMeans() {
        int i;
        float[] f;
        int c = 0;
        this.kSv.cEStepCallsSave = this.kSv.cEStepCallsLast;
        this.kSv.nDimsBest = this.nDims;
        this.kSv.nBestClustersAlive = this.nClustersAlive;
        if (this.kSv.BestWeight.length < this.Weight.length) {
            f = new float[this.Weight.length];
            i = 0;
            while (i < this.kSv.BestWeight.length) {
                f[i] = this.kSv.BestWeight[i];
                ++i;
            }
            this.kSv.BestWeight = f;
        }
        if (this.kSv.BestMean.length < this.Mean.length) {
            f = new float[this.Mean.length];
            i = 0;
            while (i < this.kSv.BestMean.length) {
                f[i] = this.kSv.BestMean[i];
                ++i;
            }
            this.kSv.BestMean = f;
        }
        int cc = 0;
        while (cc < this.nClustersAlive) {
            c = this.AliveIndex[cc];
            this.kSv.BestAliveIndex.set(cc, c);
            this.kSv.BestWeight[cc] = this.Weight[c];
            i = 0;
            while (i < this.nDims) {
                this.kSv.BestMean[cc * this.nDims + i] = this.Mean[c * this.nDims + i];
                ++i;
            }
            ++cc;
        }
        cc = 1;
        while (cc < this.kSv.nBestClustersAlive) {
            c = this.kSv.BestAliveIndex.get(cc);
            i = 0;
            while (i < this.kSv.nDimsBest) {
                int j = 0;
                while (j <= i) {
                    this.kSv.pBestChol.get((int)c)[i * this.kSv.nDimsBest + j] = this.kSv.pChol.get(c)[i * this.kSv.nDimsBest + j];
                    ++j;
                }
                ++i;
            }
            ++cc;
        }
    }

    boolean Cholesky(float[] m_In, float[] m_Out, int D) {
        float[] In = new float[D * D];
        int i = 0;
        while (i < D * D) {
            In[i] = m_In[i];
            ++i;
        }
        float[] Out = new float[D * D];
        i = 0;
        while (i < D * D) {
            Out[i] = 0.0f;
            ++i;
        }
        i = 0;
        while (i < D) {
            int j = i;
            while (j < D) {
                float sum = In[i * D + j];
                int k = i - 1;
                while (k >= 0) {
                    sum -= Out[i * D + k] * Out[j * D + k];
                    --k;
                }
                if (i == j) {
                    if (sum <= 0.0f) {
                        return true;
                    }
                    Out[i * D + i] = (float)Math.sqrt(sum);
                } else {
                    Out[j * D + i] = sum / Out[i * D + i];
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < D * D) {
            m_Out[i] = Out[i];
            ++i;
        }
        return false;
    }

    void TriSolve(float[] M, float[] x, float[] Out, int D) {
        int i = 0;
        while (i < D) {
            float sum = x[i];
            int j = i - 1;
            while (j >= 0) {
                sum -= M[i * D + j] * Out[j];
                --j;
            }
            Out[i] = sum / M[i * D + i];
            ++i;
        }
    }
}

