/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.compute;

import explorer.compute.compute.MatlabExec;
import explorer.data.DataManager;
import explorer.data.SourceAttrVal;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import lib3d4j.data.DescriptionData;

public class LMNN {
    private Vector<Integer> ytr;
    private Vector<Integer> yte;
    private Vector<Float[]> xtr;
    private Vector<Float[]> xte;
    private SourceAttrVal dt;
    private int nbAttACP;
    private int nbObjects;
    private float knnerrITr;
    private float knnerrITe;
    private float knnerrLTr;
    private float knnerrLTe;
    private float enerr;
    private float time;

    public LMNN(SourceAttrVal d) {
        this.dt = d;
        this.nbAttACP = d.getNbAttACP();
        this.nbObjects = d.getNbObjects();
    }

    public void calculer(int knn) throws IOException {
        this.genererMat();
        this.genererResultLMNN(knn);
        this.readResult();
    }

    private synchronized void readResult() {
        try {
            FileReader res = new FileReader("LMNNTest\\ResultLMNN.rtf");
            int b = 0;
            String aux = "";
            while (b != -1 && b != 46 && (b <= 47 || b >= 58)) {
                b = res.read();
            }
            while (b == 46 || b > 47 && b < 58) {
                aux = String.valueOf(aux) + (char)b;
                b = res.read();
            }
            this.knnerrITr = Float.parseFloat(aux);
            System.out.println("knnerrITr" + aux);
            b = res.read();
            aux = "";
            while (b == 46 || b > 47 && b < 58) {
                aux = String.valueOf(aux) + (char)b;
                b = res.read();
            }
            System.out.println("knnerrITe" + aux);
            this.knnerrITe = Float.parseFloat(aux);
            b = res.read();
            aux = "";
            while (b == 46 || b > 47 && b < 58) {
                aux = String.valueOf(aux) + (char)b;
                b = res.read();
            }
            System.out.println("knnerrLTr" + aux);
            this.knnerrLTr = Float.parseFloat(aux);
            b = res.read();
            aux = "";
            while (b == 46 || b > 47 && b < 58) {
                aux = String.valueOf(aux) + (char)b;
                b = res.read();
            }
            System.out.println("knnerrLTe" + aux);
            this.knnerrLTe = Float.parseFloat(aux);
            b = res.read();
            aux = "";
            while (b == 46 || b > 47 && b < 58) {
                aux = String.valueOf(aux) + (char)b;
                b = res.read();
            }
            System.out.println("enerr" + aux);
            this.enerr = Float.parseFloat(aux);
            b = res.read();
            aux = "";
            while (b == 46 || b > 47 && b < 58) {
                aux = String.valueOf(aux) + (char)b;
                b = res.read();
            }
            System.out.println("time" + aux);
            this.time = Float.parseFloat(aux);
            b = res.read();
            aux = "";
            while (b == 46 || b > 47 && b < 58) {
                aux = String.valueOf(aux) + (char)b;
                b = res.read();
            }
            res.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Impossible de lire fichier de resultat LMNN");
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private synchronized void genererResultLMNN(int knn) {
        MatlabExec.clear();
        String[] cmd = new String[]{"matlab", "-r", "MatlabExec('ResultLMNN.rtf'," + knn + ")"};
        MatlabExec.exec(cmd);
        File fic = new File("LMNNTest/XTestLMNN.m");
        if (fic.delete()) {
            fic = new File("LMNNTest/YTestLMNN.m");
            if (fic.delete() && (fic = new File("LMNNTest/XTrainLMNN.m")).delete() && (fic = new File("LMNNTest/YTrainLMNN.m")).delete()) {
                System.out.println("Fichiers .m supprimes.");
            }
        } else {
            System.out.println("Probleme de suppression des fichiers .m .");
        }
    }

    public synchronized void setMatrice(int[] cross, int n) {
        DescriptionData dd = DataManager.getSingleton().getCompAttr();
        this.xtr = new Vector();
        this.xte = new Vector();
        this.ytr = new Vector();
        this.yte = new Vector();
        int j = 0;
        while (j < this.nbObjects) {
            int i;
            if (cross[j] == n) {
                this.xte.add(new Float[this.nbAttACP]);
                i = 0;
                while (i < this.nbAttACP) {
                    this.xte.get((int)(this.xte.size() - 1))[i] = Float.valueOf(this.dt.getAttrValue(j, i));
                    ++i;
                }
                this.yte.add(dd.getClassIndice(j));
            } else {
                this.xtr.add(new Float[this.nbAttACP]);
                i = 0;
                while (i < this.nbAttACP) {
                    this.xtr.get((int)(this.xtr.size() - 1))[i] = Float.valueOf(this.dt.getAttrValue(j, i));
                    ++i;
                }
                this.ytr.add(dd.getClassIndice(j));
            }
            ++j;
        }
    }

    private synchronized void genererMatX() throws IOException {
        FileWriter xtefile = new FileWriter("LMNNTest\\XTestLMNN.m");
        FileWriter xtrfile = new FileWriter("LMNNTest\\XTrainLMNN.m");
        int i = 0;
        while (i < this.nbAttACP) {
            int j = 0;
            while (j < this.xtr.size()) {
                xtrfile.write(String.valueOf(String.valueOf(this.xtr.get(j)[i])) + "\t");
                ++j;
            }
            j = 0;
            while (j < this.xte.size()) {
                xtefile.write(String.valueOf(String.valueOf(this.xte.get(j)[i])) + "\t");
                ++j;
            }
            xtrfile.write("\r");
            xtefile.write("\r");
            ++i;
        }
        xtrfile.close();
        xtefile.close();
    }

    private synchronized void genererMatY() throws IOException {
        FileWriter ytefile = new FileWriter("LMNNTest\\YTestLMNN.m");
        FileWriter ytrfile = new FileWriter("LMNNTest\\YTrainLMNN.m");
        int i = 0;
        while (i < this.yte.size()) {
            ytefile.write(String.valueOf(String.valueOf(this.yte.get(i))) + "\t");
            ++i;
        }
        i = 0;
        while (i < this.ytr.size()) {
            ytrfile.write(String.valueOf(String.valueOf(this.ytr.get(i))) + "\t");
            ++i;
        }
        ytefile.close();
        ytrfile.close();
    }

    private synchronized void genererMat() throws IOException {
        this.genererMatX();
        this.genererMatY();
    }

    public float getKnnerrITr() {
        return this.knnerrITr;
    }

    public synchronized void setKnnerrITr(float knnerrITr) {
        this.knnerrITr = knnerrITr;
    }

    public float getKnnerrITe() {
        return this.knnerrITe;
    }

    public synchronized void setKnnerrITe(float knnerrITe) {
        this.knnerrITe = knnerrITe;
    }

    public float getKnnerrLTr() {
        return this.knnerrLTr;
    }

    public synchronized void setKnnerrLTr(float knnerrLTr) {
        this.knnerrLTr = knnerrLTr;
    }

    public float getKnnerrLTe() {
        return this.knnerrLTe;
    }

    public synchronized void setKnnerrLTe(float knnerrLTe) {
        this.knnerrLTe = knnerrLTe;
    }

    public float getEnerr() {
        return this.enerr;
    }

    public synchronized void setEnerr(float enerr) {
        this.enerr = enerr;
    }

    public float getTime() {
        return this.time;
    }

    public synchronized void setTime(float time) {
        this.time = time;
    }

    public String toString() {
        String res = "";
        int i = 0;
        while (i < this.nbAttACP) {
            int j = 0;
            while (j < this.xtr.size()) {
                res = String.valueOf(res) + String.valueOf(this.xtr.get(j)[i]) + "\t";
                ++j;
            }
            res = String.valueOf(res) + "\n";
            ++i;
        }
        return res;
    }
}

