/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.compute.constraints;

import explorer.compute.compute.constraints.AbstractConstraint;
import explorer.compute.compute.constraints.ConstraintTrace;
import explorer.compute.compute.projection.Projection;

public class C3Constraint
extends AbstractConstraint {
    private static int idGenerator = 1;
    private static float rho = 1.0f;
    private static float epsilon = 0.05f;
    private int objA;
    private int objB;
    private int objC;
    private float distance;
    private int delta;

    private static synchronized int getNextId() {
        return idGenerator++;
    }

    public C3Constraint(String s, Projection p) {
        super(p);
        String[] elements = s.split(" ");
        this.set(Integer.parseInt(elements[4]), Integer.parseInt(elements[6]), Integer.parseInt(elements[8]), Float.parseFloat(elements[10]), elements[9].equals(">"));
        this.init(true);
    }

    public C3Constraint(int a, int b, int c, float d, boolean greater, Projection p) {
        super(p);
        this.set(a, b, c, d, greater);
        this.init(true);
    }

    public void modify(int a, int b, int c, float d, boolean greater) {
        this.set(a, b, c, d, greater);
        this.init(false);
    }

    private void set(int a, int b, int c, float d, boolean greater) {
        this.objA = a;
        this.objB = b;
        this.objC = c;
        this.distance = d;
        this.delta = greater ? -1 : 1;
    }

    private void init(boolean creation) {
        if (creation) {
            this.id = C3Constraint.getNextId();
        }
        this.cConstant = (double)rho * (Math.pow(this.distanceProj(this.objA, this.objC), 2.0) - (double)(this.distance * this.distance) * Math.pow(this.distanceProj(this.objA, this.objB), 2.0));
    }

    @Override
    public void afficher() {
        System.out.print("d(x" + this.objA + " ,x" + this.objC + ") ");
        if (this.delta == 1) {
            System.out.print("<");
        } else {
            System.out.print(">");
        }
        System.out.print(String.valueOf(this.distance) + "*d(x" + this.objA + " ,x" + this.objB + ") ");
        System.out.print("   (" + this.distanceProj(this.objA, this.objC) + " / " + this.distanceProj(this.objA, this.objB) + "):" + this.distanceProj(this.objA, this.objC) / this.distanceProj(this.objA, this.objB));
        System.out.println("   " + this.cConstant);
    }

    @Override
    public void updateConstantC() {
        double f = (double)rho * (Math.pow(this.distanceProj(this.objA, this.objC), 2.0) - (double)(this.distance * this.distance) * Math.pow(this.distanceProj(this.objA, this.objB), 2.0));
        this.cConstant = this.newConstanteC(this.cConstant, f);
    }

    private double newConstanteC(double anc, double f) {
        if ((double)this.delta * f > 0.0 && (double)this.delta * anc > 0.0 && Math.abs(f) > Math.abs(anc)) {
            return f;
        }
        if (f * anc < 0.0) {
            return (double)-0.1f * anc;
        }
        return anc;
    }

    @Override
    public boolean ContraintePasRespectee() {
        return !(Math.abs((this.distanceProj(this.objA, this.objC) - this.distance * this.distanceProj(this.objA, this.objB)) * (float)this.delta) < epsilon);
    }

    @Override
    public boolean ContraintePasRespectee_old() {
        return !((this.distanceProj(this.objA, this.objC) - this.distance * this.distanceProj(this.objA, this.objB)) * (float)this.delta < 0.0f);
    }

    @Override
    public float volumeContraintePasRespectee() {
        if (!((this.distanceProj(this.objA, this.objC) - this.distance * this.distanceProj(this.objA, this.objB)) * (float)this.delta < 0.0f)) {
            return (this.distanceProj(this.objA, this.objC) - this.distance * this.distanceProj(this.objA, this.objB)) * (float)this.delta;
        }
        return 0.0f;
    }

    @Override
    public double ValeurAdditionneeALaMatrice(float[][] dataOrigine, int i, int j, int nbObjects) {
        return this.cConstant / (1.0 * (double)nbObjects) * (double)((dataOrigine[this.objA][i] - dataOrigine[this.objC][i]) * (dataOrigine[this.objA][j] - dataOrigine[this.objC][j]) - this.distance * this.distance * ((dataOrigine[this.objA][i] - dataOrigine[this.objB][i]) * (dataOrigine[this.objA][j] - dataOrigine[this.objB][j])));
    }

    @Override
    public boolean fitTrace(ConstraintTrace ct) {
        if (ct instanceof C3Trace) {
            C3Trace c3t = (C3Trace)ct;
            return this.objA == c3t.objA && this.objB == c3t.objB;
        }
        return false;
    }

    public String toString() {
        String sign = this.delta == 1 ? " < " : " > ";
        return "An |  : " + this.objA + " - " + this.objB + " - " + this.objC + sign + this.distance;
    }

    public int getA() {
        return this.objA;
    }

    public int getB() {
        return this.objB;
    }

    public int getC() {
        return this.objC;
    }

    public static class C3Trace
    implements ConstraintTrace {
        int objA;
        int objB;

        public C3Trace(int a, int b) {
            this.objA = a;
            this.objB = b;
        }
    }
}

