/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.compute.projection;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import explorer.compute.compute.projection.PMAttrVal;
import explorer.compute.compute.projection.PMFactory;
import explorer.data.Common;
import explorer.data.SourceAttrVal;

public class PMARDp
extends PMAttrVal {
    public static int param_sigma = 0;
    protected float sigma;
    protected float ARDpDiff;
    protected boolean aff = false;

    @Override
    public void retourPremiereProjection3D(int[] axes) {
    }

    public boolean isAff() {
        return this.aff;
    }

    public void setAff(boolean aff) {
        this.aff = aff;
    }

    public PMARDp(SourceAttrVal src) {
        super(src, PMFactory.ARDp);
        this.ARDpDiff = 0.0f;
    }

    public PMARDp(SourceAttrVal src, float diff) {
        super(src, PMFactory.ARDp);
        this.ARDpDiff = diff;
    }

    @Override
    public int getNbDimensions() {
        return this.nbTermes;
    }

    @Override
    public void setParameterValue(int indice, float valeur) {
        if (indice == param_sigma) {
            this.sigma = valeur;
        }
    }

    public void setDiff(float diff) {
    }

    public void setSigma(float s) {
        this.sigma = s;
    }

    public float getSigma() {
        return this.sigma;
    }

    @Override
    public void calculer() {
        int j;
        int m;
        int n;
        this.initDataOrigine();
        this.condition.condition(this.dataOrigine);
        this.calculerMoyennes();
        double[][] matrice = new double[this.nbTermes][this.nbTermes];
        String anomalie = "";
        float[][] distance = null;
        if (this.nbObjects < 1000) {
            distance = new float[this.nbObjects][this.nbObjects];
            if (this.sigma != 0.0f) {
                n = 0;
                while (n < this.nbObjects) {
                    m = n + 1;
                    while (m < this.nbObjects) {
                        if (this.dd.getClassIndice(n) != this.dd.getClassIndice(m) && this.actifs[n] && this.actifs[m]) {
                            distance[n][m] = this.distpts(n, m, this.nbTermes);
                            distance[m][n] = distance[n][m];
                        }
                        ++m;
                    }
                    ++n;
                }
            }
        }
        matrice = new double[this.nbTermes][this.nbTermes];
        int i = 0;
        while (i < this.nbTermes) {
            j = i;
            while (j < this.nbTermes) {
                matrice[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        n = 0;
        while (n < this.nbObjects) {
            m = n + 1;
            while (m < this.nbObjects) {
                float w;
                if (this.dd.getClassIndice(n) != this.dd.getClassIndice(m) && this.actifs[n] && this.actifs[m]) {
                    w = 1.0f;
                    if (this.sigma != 0.0f) {
                        w = distance != null ? distance[n][m] : this.distpts(n, m, this.nbTermes);
                        if (w == 0.0f) {
                            w = 1.0f;
                        }
                        w = (float)Math.pow(w, -(this.sigma * 2.0f));
                    }
                    i = 0;
                    while (i < this.nbTermes) {
                        j = i;
                        while (j < this.nbTermes) {
                            double[] dArray = matrice[i];
                            int n2 = j;
                            dArray[n2] = dArray[n2] + (double)(w * (this.dataOrigine[n][j] - this.dataOrigine[m][j]) * (this.dataOrigine[n][i] - this.dataOrigine[m][i]));
                            ++j;
                        }
                        ++i;
                    }
                } else if (this.ARDpDiff > 0.0f && this.actifs[n] && this.actifs[m]) {
                    w = 1.0f;
                    if (this.sigma != 0.0f) {
                        w = distance != null ? distance[n][m] : this.distpts(n, m, this.nbTermes);
                        if (w == 0.0f) {
                            w = 1.0f;
                        }
                        w = (float)Math.pow(w, -(this.sigma * 2.0f));
                    }
                    i = 0;
                    while (i < this.nbTermes) {
                        j = i;
                        while (j < this.nbTermes) {
                            double[] dArray = matrice[i];
                            int n3 = j;
                            dArray[n3] = dArray[n3] - (double)(this.ARDpDiff * w * (this.dataOrigine[n][j] - this.dataOrigine[m][j]) * (this.dataOrigine[n][i] - this.dataOrigine[m][i]));
                            ++j;
                        }
                        ++i;
                    }
                }
                ++m;
            }
            ++n;
        }
        i = 0;
        while (i < this.nbTermes) {
            j = i;
            while (j < this.nbTermes) {
                matrice[i][j] = matrice[i][j] / (double)(1.0f * (float)this.nbActifs);
                matrice[j][i] = matrice[i][j];
                ++j;
            }
            ++i;
        }
        if (!anomalie.equals("")) {
            System.out.println("Anomalies d'\ufffdtiquetage:\n" + anomalie);
        }
        Matrix M = new Matrix(matrice);
        this.ed = new EigenvalueDecomposition(M, Common.getSingleton());
        this.initialiserDataProjected();
    }

    @Override
    public void creerProjection() {
        double[][] vp = this.ed.getV2();
        this.dataProjected = new float[this.nbObjects][this.getNbDimensions()];
        int i = 0;
        while (i < this.nbObjects) {
            int j = 0;
            while (j < this.getNbDimensions()) {
                float ss = 0.0f;
                int k = 0;
                while (k < this.nbTermes) {
                    ss = (float)((double)ss + vp[k][j] * (double)this.dataOrigine[i][k]);
                    ++k;
                }
                this.dataProjected[i][j] = ss;
                ++j;
            }
            ++i;
        }
    }

    @Override
    public float[] getAxisProjection(int rank) {
        float[] axisProj = new float[this.nbObjects];
        double[][] vp = this.ed.getV2();
        int i = 0;
        while (i < this.nbObjects) {
            axisProj[i] = 0.0f;
            int k = 0;
            while (k < this.nbTermes) {
                int n = i;
                axisProj[n] = (float)((double)axisProj[n] + vp[k][rank] * (double)this.dataOrigine[i][k]);
                ++k;
            }
            ++i;
        }
        return axisProj;
    }

    @Override
    public float[] projection(int rank, int[] dims) {
        double[][] vp = this.ed.getV2();
        float[] res = new float[dims.length];
        int j = 0;
        while (j < dims.length) {
            float ss = 0.0f;
            int k = 0;
            while (k < this.nbTermes) {
                ss = (float)((double)ss + vp[k][dims[j]] * (double)this.dataOrigine[rank][k]);
                ++k;
            }
            res[j] = ss;
            ++j;
        }
        return res;
    }

    @Override
    public float[] projection(float[] coord, int[] dims) {
        double[][] vp = this.ed.getV2();
        float[] res = new float[dims.length];
        int j = 0;
        while (j < dims.length) {
            float ss = 0.0f;
            int k = 0;
            while (k < this.nbTermes) {
                ss = (float)((double)ss + vp[k][dims[j]] * (double)coord[k]);
                ++k;
            }
            res[j] = ss;
            ++j;
        }
        return res;
    }

    @Override
    public float[] getPointVariable(int var, int[] dims) {
        double[][] vp = this.ed.getV2();
        double[] iv = this.ed.getRealEigenvalues();
        float[] res = new float[dims.length];
        int j = 0;
        while (j < dims.length) {
            res[j] = 0.0f;
            ++j;
        }
        j = 0;
        while (j < dims.length) {
            int n = j;
            res[n] = (float)((double)res[n] + Math.sqrt(iv[dims[j]]) * vp[var][dims[j]]);
            ++j;
        }
        return res;
    }

    private float distpts(int i, int j, int nb) {
        float som = 0.0f;
        int n = 0;
        while (n < nb) {
            som += (this.dataOrigine[i][n] - this.dataOrigine[j][n]) * (this.dataOrigine[i][n] - this.dataOrigine[j][n]);
            ++n;
        }
        double d = som;
        d = Math.sqrt(d);
        return (float)d;
    }
}

