/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.compute.projection;

import explorer.compute.compute.projection.PMException;
import explorer.compute.compute.projection.PMFactory;
import explorer.compute.compute.projection.ProjectiveMethod;
import explorer.data.Source3DCoord;

public class PMDirect
extends ProjectiveMethod {
    public PMDirect(Source3DCoord s) throws PMException {
        super(s, PMFactory.DIRECT);
        if (s == null) {
            throw new PMException();
        }
        this.src = s;
        this.nbTermes = 3;
    }

    @Override
    public void calculer() {
        int nbobj = this.src.getNbObjects();
        this.dataProjected3D = (float[][])((Source3DCoord)this.src).getCoords().clone();
        this.dataProjected = this.dataProjected3D;
    }

    @Override
    public float[][] creerProjection3D(int[] axes) {
        return this.dataProjected3D;
    }

    @Override
    public void retourPremiereProjection3D(int[] axes) {
    }

    @Override
    public void creerProjection() {
        this.dataProjected3D = ((Source3DCoord)this.src).getCoords();
        this.dataProjected = this.dataProjected3D;
    }

    @Override
    public float[] projection(int rank, int[] dims) {
        return this.dataProjected[rank];
    }

    @Override
    public float[] projection(float[] coord, int[] dims) {
        if (dims.length > 3) {
            return null;
        }
        int[] nArray = dims;
        int n = dims.length;
        int n2 = 0;
        while (n2 < n) {
            int dim = nArray[n2];
            if (dim > 2) {
                return null;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public float[] getAxisProjection(int rank) {
        float[] axisProj = new float[this.nbObjects];
        int i = 0;
        while (i < this.nbObjects) {
            axisProj[i] = this.dataProjected[i][rank];
            ++i;
        }
        return axisProj;
    }

    @Override
    public float[] getPointVariable(int var, int[] dims) {
        return null;
    }

    @Override
    public int getNbDimensions() {
        return 3;
    }

    @Override
    public float getDistance(int a, int b) {
        double dist = 0.0;
        int i = 0;
        while (i < this.nbTermes) {
            dist += (double)((this.dataProjected[a][i] - this.dataProjected[b][i]) * (this.dataProjected[a][i] - this.dataProjected[b][i]));
            ++i;
        }
        return (float)Math.sqrt(dist);
    }
}

