/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.compute.projection;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import explorer.compute.compute.projection.PMKNNPCA;
import explorer.data.Common;
import explorer.data.SourceAttrVal;
import java.util.Random;

public class PMKNNPCA_Boost
extends PMKNNPCA {
    double[][] matrice;
    double coef_red = 0.8;
    boolean aff = true;
    EigenvalueDecomposition edMax = null;
    EigenvalueDecomposition edTmp = null;
    private float[] Dt = null;

    public PMKNNPCA_Boost(SourceAttrVal src) {
        super(src);
    }

    public void setAffichage(boolean affiche) {
        this.aff = affiche;
    }

    public void calculer(Common parent) {
        float err0;
        this.knn = 5.0f;
        float errmax = err0 = this.iteration0(parent);
        this.creerProjection();
        this.edMax = this.ed;
        int i = 1;
        while (i < 21) {
            float err = this.iterationN(parent, i);
            if (errmax < err) {
                errmax = err;
                this.edMax = this.edTmp;
            }
            this.creerProjection();
            ++i;
        }
        this.ed = this.edMax;
        if (this.aff) {
            System.out.println("final: " + errmax + " /" + err0);
        }
    }

    public float iteration0(Common parent) {
        int j;
        int m;
        int n;
        this.initDataOrigine();
        this.condition.condition(this.dataOrigine);
        this.calculerMoyennes();
        this.matrice = new double[this.nbTermes][this.nbTermes];
        this.Dt = new float[this.nbObjects];
        int i = 0;
        while (i < this.nbObjects) {
            this.Dt[i] = 0.0f;
            ++i;
        }
        float err = this.errorLeaveOneOut((int)this.knn, this.actifs, this.dataOrigine);
        if (this.aff) {
            System.out.println("taux d'erreur : " + err);
        }
        float[][] distance = null;
        if (this.nbObjects < 1000) {
            distance = new float[this.nbObjects][this.nbObjects];
            n = 0;
            while (n < this.nbObjects) {
                m = n + 1;
                while (m < this.nbObjects) {
                    if (this.actifs[n] && this.actifs[m]) {
                        distance[n][m] = this.distpts(n, m, this.nbTermes);
                        distance[m][n] = distance[n][m];
                    }
                    ++m;
                }
                ++n;
            }
        }
        this.matrice = new double[this.nbTermes][this.nbTermes];
        i = 0;
        while (i < this.nbTermes) {
            j = i;
            while (j < this.nbTermes) {
                this.matrice[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        int cpt = 0;
        if (this.aff) {
            System.out.print("Iteration 0 --------------------------------------");
        }
        float[] d1 = new float[this.nbObjects];
        n = 0;
        while (n < this.nbObjects) {
            if (this.actifs[n]) {
                i = 0;
                while (i < this.nbObjects) {
                    d1[i] = i != n && this.actifs[i] ? (distance == null ? this.distpts(n, i, this.nbTermes) : distance[i][n]) : -1.0f;
                    ++i;
                }
                float valrk = this.valeurRangK(d1, this.knn);
                m = 0;
                while (m < this.nbObjects) {
                    if (m != n && this.dd.getClassIndice(n) != this.dd.getClassIndice(m) && this.actifs[m] && d1[m] > 0.0f && d1[m] <= valrk) {
                        ++cpt;
                        i = 0;
                        while (i < this.nbTermes) {
                            j = i;
                            while (j < this.nbTermes) {
                                double[] dArray = this.matrice[i];
                                int n2 = j;
                                dArray[n2] = dArray[n2] + (double)((this.dataOrigine[n][j] - this.dataOrigine[m][j]) * (this.dataOrigine[n][i] - this.dataOrigine[m][i]));
                                ++j;
                            }
                            ++i;
                        }
                    }
                    ++m;
                }
            }
            ++n;
        }
        System.out.println("");
        i = 0;
        while (i < this.nbTermes) {
            j = i;
            while (j < this.nbTermes) {
                this.matrice[i][j] = this.matrice[i][j] / (1.0 * (double)this.nbActifs);
                this.matrice[j][i] = this.matrice[i][j];
                ++j;
            }
            ++i;
        }
        Matrix M = new Matrix(this.matrice);
        this.ed = new EigenvalueDecomposition(M, parent);
        return err;
    }

    public float iterationN(Common parent, int nbit) {
        int j;
        int m;
        int n;
        this.edTmp = this.ed;
        this.autoDim((int)this.knn, this.actifs, this.dataProjected);
        int nbTermeOptim = this.getNbDimAutoDim();
        boolean perturb = false;
        if (this.aff) {
            System.out.println("taux d'erreur : " + this.getTauxCorrectAppAutoDim() + "  / nb dimensions : " + nbTermeOptim);
        }
        if (nbTermeOptim == this.nbTermes) {
            nbTermeOptim = 2;
            perturb = true;
            this.knn += 2.0f;
        }
        float[][] distance = null;
        if (this.nbObjects < 1000) {
            distance = new float[this.nbObjects][this.nbObjects];
            n = 0;
            while (n < this.nbObjects) {
                m = n + 1;
                while (m < this.nbObjects) {
                    if (this.actifs[n] && this.actifs[m]) {
                        distance[n][m] = this.distptsPr(n, m, nbTermeOptim);
                        distance[m][n] = distance[n][m];
                    }
                    ++m;
                }
                ++n;
            }
        }
        int i = 0;
        while (i < this.nbTermes) {
            j = i;
            while (j < this.nbTermes) {
                this.matrice[i][j] = this.matrice[i][j] * this.coef_red;
                ++j;
            }
            ++i;
        }
        int cpt = 0;
        if (this.aff) {
            System.out.print("Iteration " + nbit + " --------------------------------------");
        }
        float[] d1 = new float[this.nbObjects];
        n = 0;
        while (n < this.nbObjects) {
            if (this.actifs[n]) {
                i = 0;
                while (i < this.nbObjects) {
                    d1[i] = i != n && this.actifs[i] ? (distance == null ? this.distptsPr(n, i, nbTermeOptim) : distance[i][n]) : -1.0f;
                    ++i;
                }
                float valrk = this.valeurRangK(d1, this.knn);
                m = 0;
                while (m < this.nbObjects) {
                    if (m != n && this.dd.getClassIndice(n) != this.dd.getClassIndice(m) && this.actifs[m] && d1[m] > 0.0f && d1[m] <= valrk) {
                        ++cpt;
                        double tt = 1.0;
                        i = 0;
                        while (i < this.nbTermes) {
                            j = i;
                            while (j < this.nbTermes) {
                                double[] dArray = this.matrice[i];
                                int n2 = j;
                                dArray[n2] = dArray[n2] + tt * (double)(this.dataOrigine[n][j] - this.dataOrigine[m][j]) * (double)(this.dataOrigine[n][i] - this.dataOrigine[m][i]) / (1.0 * (double)this.nbActifs);
                                ++j;
                            }
                            ++i;
                        }
                    }
                    ++m;
                }
            }
            ++n;
        }
        if (this.aff) {
            System.out.println("");
        }
        i = 0;
        while (i < this.nbTermes) {
            j = i;
            while (j < this.nbTermes) {
                this.matrice[j][i] = this.matrice[i][j];
                ++j;
            }
            ++i;
        }
        Matrix M = new Matrix(this.matrice);
        this.ed = new EigenvalueDecomposition(M, parent);
        if (perturb) {
            this.knn -= 2.0f;
        }
        return this.getTauxCorrectAppAutoDim();
    }

    private float distptsPr(int i, int j, int nb) {
        float som = 0.0f;
        int n = 0;
        while (n < nb) {
            som += (this.dataProjected[i][n] - this.dataProjected[j][n]) * (this.dataProjected[i][n] - this.dataProjected[j][n]);
            ++n;
        }
        double d = som;
        d = Math.sqrt(d);
        return (float)d;
    }

    @Override
    public void test(int[] cross, int nbg, boolean affichage, int knn) {
        int nbelem = this.dd.getNbDescrObjects();
        Random rand = new Random();
        int nbapp = 0;
        int i = 0;
        while (i < nbelem) {
            if (cross[i] != nbg) {
                ++nbapp;
            }
            ++i;
        }
        int nbtest = nbelem - nbapp;
        int[] indiceApp = new int[nbapp];
        int[] indiceTest = new int[nbtest];
        int rankApp = 0;
        int rankTest = 0;
        int i2 = 0;
        while (i2 < nbelem) {
            if (cross[i2] != nbg) {
                indiceApp[rankApp++] = i2;
            } else {
                indiceTest[rankTest++] = i2;
            }
            ++i2;
        }
        boolean[] act = new boolean[this.nbObjects];
        int i3 = 0;
        while (i3 < this.nbObjects) {
            act[i3] = cross[i3] != nbg;
            ++i3;
        }
        this.autoDim(knn, this.actifs, this.dataProjected);
        int nbTermeOptim = this.getNbDimAutoDim();
        float taux = 0.0f;
        this.tauxCorrect = new float[this.getNbDimensions()];
        this.calculerCentreGravite();
        this.creerProjection();
        taux = 0.0f;
        float[] d1 = new float[nbapp];
        int[] distrib = new int[this.dd.getNbClasses()];
        int i4 = 0;
        while (i4 < nbtest) {
            int j = 0;
            while (j < nbapp) {
                d1[j] = this.distptsPr(indiceApp[j], indiceTest[i4], nbTermeOptim);
                ++j;
            }
            float valrk = this.valeurRangK(d1, knn);
            j = 0;
            while (j < this.dd.getNbClasses()) {
                distrib[j] = 0;
                ++j;
            }
            j = 0;
            while (j < nbapp) {
                if (d1[j] <= valrk) {
                    int n = this.dd.getClassIndice(indiceApp[j]);
                    distrib[n] = distrib[n] + 1;
                }
                ++j;
            }
            int maxCl = distrib[0];
            j = 0;
            while (j < this.dd.getNbClasses()) {
                if (distrib[j] > maxCl) {
                    maxCl = distrib[j];
                }
                ++j;
            }
            int nbMax = 0;
            int cl = 0;
            j = 0;
            while (j < this.dd.getNbClasses()) {
                if (distrib[j] == maxCl) {
                    ++nbMax;
                    cl = j;
                }
                ++j;
            }
            if (nbMax > 1) {
                System.out.print("*");
                int tailleMax = 0;
                j = 0;
                while (j < this.dd.getNbClasses()) {
                    if (distrib[j] == maxCl && tailleMax < this.dd.getClassSize(j)) {
                        tailleMax = this.dd.getClassSize(j);
                    }
                    ++j;
                }
                nbMax = 0;
                cl = 0;
                j = 0;
                while (j < this.dd.getNbClasses()) {
                    if (distrib[j] == maxCl && tailleMax == this.dd.getClassSize(j)) {
                        ++nbMax;
                        cl = j;
                    }
                    ++j;
                }
                if (nbMax > 1) {
                    System.out.print("#");
                    nbMax = rand.nextInt(nbMax);
                    cl = 0;
                    j = 0;
                    while (nbMax >= 0) {
                        if (distrib[j] == maxCl && tailleMax == this.dd.getClassSize(j)) {
                            cl = j;
                            --nbMax;
                        }
                        ++j;
                    }
                }
            }
            if (cl == this.dd.getClassIndice(indiceTest[i4])) {
                taux += 1.0f;
            }
            ++i4;
        }
        this.tauxCorrect[0] = taux = taux / (float)nbtest * 100.0f;
        this.tauxCorrect[1] = this.getTauxCorrectAppAutoDim();
        if (affichage) {
            System.out.print(String.valueOf((int)taux) + " ");
        }
    }
}

