/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.compute.projection;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import explorer.compute.compute.constraints.Constraint;
import explorer.compute.compute.constraints.Constraints;
import explorer.compute.compute.projection.PMAttrVal;
import explorer.compute.compute.projection.PMFactory;
import explorer.compute.compute.projection.ProjectionFactory;
import explorer.compute.compute.projection.ProjectiveMethod;
import explorer.data.Common;
import explorer.data.SourceAttrVal;
import java.util.List;
import lib3d4j.compute.compute.ComputeInfo;

public class PMPCA
extends PMAttrVal {
    double[][] vp;
    double[][] matrice;
    double[][] matricebis;
    Common parent;
    public static int MAX_ITER = 30;

    public PMPCA(SourceAttrVal src) {
        super(src, PMFactory.ACP);
    }

    public PMPCA(ProjectiveMethod pm) {
        this((SourceAttrVal)pm.src);
    }

    @Override
    public int getNbDimensions() {
        return this.nbTermes;
    }

    @Override
    public void calculer() {
        this.initDataOrigine();
        this.dataOrigine = this.condition.condition(this.dataOrigine);
        this.calculerMoyennes();
        this.matrice = new double[this.nbTermes][this.nbTermes];
        int i = 0;
        while (i < this.nbTermes) {
            int j = i;
            while (j < this.nbTermes) {
                float som = 0.0f;
                int k = 0;
                while (k < this.nbObjects) {
                    if (this.actifs[k]) {
                        som += (this.dataOrigine[k][i] - this.moyennes[i]) * (this.dataOrigine[k][j] - this.moyennes[j]);
                    }
                    ++k;
                }
                this.matrice[i][j] = 1.0 * (double)(som /= 1.0f * (float)this.nbObjects);
                this.matrice[j][i] = 1.0 * (double)som;
                ++j;
            }
            ++i;
        }
        this.calculerVecteursPropres(this.matrice, this.parent);
    }

    private void displayEigenVectors() {
        StringBuilder sb = new StringBuilder();
        double[][] dArray = this.vp;
        int n = this.vp.length;
        int n2 = 0;
        while (n2 < n) {
            double[] v;
            double[] dArray2 = v = dArray[n2];
            int n3 = v.length;
            int n4 = 0;
            while (n4 < n3) {
                double d = dArray2[n4];
                sb.append(String.valueOf(d) + " ");
                ++n4;
            }
            sb.append("\n");
            ++n2;
        }
        System.out.println(sb.toString());
    }

    public void reinit() {
        int[] axes = new int[3];
        int i = 0;
        while (i < 3) {
            axes[i] = i;
            ++i;
        }
        this.calculerVecteursPropres(this.matrice, this.parent);
    }

    public void calculerVecteursPropres(double[][] M, ComputeInfo parent) {
        this.ed = new EigenvalueDecomposition(new Matrix(M), parent);
        this.vp = this.ed.getV2();
    }

    public double[][] getVecteursPropres() {
        return this.vp;
    }

    public void setVecteursPropres(double[][] v) {
        this.vp = v;
        this.calculerProjection();
    }

    @Override
    public void modificationProjection(Constraints c) {
        this.modificationProjection(this.currentAxes, c, 3);
    }

    public void modificationProjection(int[] axes, Constraints consts, int nbDims) {
        List<Constraint> lc = consts.getConstraintList();
        boolean affDetail = false;
        int nbCnr = 0;
        if (this.parent != null) {
            this.parent.subtaskSetText("Prepare");
        }
        this.matricebis = new double[this.nbTermes][this.nbTermes];
        int i = 0;
        while (i < this.nbTermes) {
            int j = i;
            while (j < this.nbTermes) {
                this.matricebis[i][j] = this.matrice[i][j];
                this.matricebis[j][i] = this.matrice[j][i];
                ++j;
            }
            ++i;
        }
        if (this.parent != null) {
            this.parent.getNomValue();
        }
        Boolean ContraintesPasRespectees = true;
        int iter = 0;
        if (affDetail) {
            for (Constraint c : lc) {
                c.afficher();
            }
        }
        float vol = 0.0f;
        for (Constraint c : lc) {
            vol += c.volumeContraintePasRespectee();
        }
        if (affDetail) {
            System.out.println("Volume : " + vol);
        }
        if (this.parent != null) {
            this.parent.subtaskSetText("Compute");
            this.parent.subtaskSetMinMax(0, 30);
        }
        while (ContraintesPasRespectees.booleanValue() && iter < MAX_ITER) {
            if (this.parent != null) {
                this.parent.subtaskSetVal(iter % 30);
            }
            if (affDetail) {
                System.out.println("----------------------------------------");
            }
            ++iter;
            for (Constraint c : lc) {
                if (!c.ContraintePasRespectee()) continue;
                int i2 = 0;
                while (i2 < this.nbTermes) {
                    int j = 0;
                    while (j < this.nbTermes) {
                        double[] dArray = this.matricebis[i2];
                        int n = j;
                        dArray[n] = dArray[n] - c.ValeurAdditionneeALaMatrice(this.dataOrigine, i2, j, this.nbObjects);
                        ++j;
                    }
                    ++i2;
                }
            }
            this.calculerVecteursPropres(this.matricebis, this.parent);
            consts.setProjection(ProjectionFactory.createStandardProjection(this));
            ContraintesPasRespectees = false;
            nbCnr = 0;
            vol = 0.0f;
            for (Constraint c : lc) {
                if (c.ContraintePasRespectee()) {
                    if (c.ContraintePasRespectee_old()) {
                        ContraintesPasRespectees = true;
                        ++nbCnr;
                        vol += c.volumeContraintePasRespectee();
                    }
                    if (affDetail) {
                        System.out.print("*");
                    }
                    c.updateConstantC();
                }
                if (!affDetail) continue;
                c.afficher();
            }
            if (!affDetail) continue;
            System.out.println("Volume : " + vol);
        }
        if (this.parent != null) {
            this.parent.subtaskSetText("Draw");
        }
    }

    protected void calculerProjection() {
        this.dataProjected = new float[this.nbObjects][this.getNbDimensions()];
        double[][] vp = this.getVecteursPropres();
        int i = 0;
        while (i < this.nbObjects) {
            int j = 0;
            while (j < this.getNbDimensions()) {
                float ss = 0.0f;
                int k = 0;
                while (k < this.nbTermes) {
                    ss = (float)((double)ss + vp[k][j] * (double)this.dataOrigine[i][k]);
                    ++k;
                }
                this.dataProjected[i][j] = ss;
                ++j;
            }
            ++i;
        }
    }

    @Override
    public float[] getAxisProjection(int rank) {
        float[] axisProj = new float[this.nbObjects];
        double[][] vp = this.getVecteursPropres();
        int i = 0;
        while (i < this.nbObjects) {
            axisProj[i] = 0.0f;
            int k = 0;
            while (k < this.nbTermes) {
                int n = i;
                axisProj[n] = (float)((double)axisProj[n] + vp[k][rank] * (double)this.dataOrigine[i][k]);
                ++k;
            }
            ++i;
        }
        return axisProj;
    }

    @Override
    public void creerProjection() {
        this.calculerProjection();
    }

    @Override
    public float[] projection(int rank, int[] dims) {
        float[] res = new float[dims.length];
        if (this.dataProjected == null) {
            this.calculerProjection();
        }
        int j = 0;
        while (j < dims.length) {
            res[j] = this.dataProjected[rank][dims[j]];
            ++j;
        }
        return res;
    }

    @Override
    public float[] projection(float[] coord, int[] dims) {
        double[][] vp = this.getVecteursPropres();
        float[] res = new float[dims.length];
        int j = 0;
        while (j < dims.length) {
            float ss = 0.0f;
            int k = 0;
            while (k < this.nbTermes) {
                ss = (float)((double)ss + vp[k][dims[j]] * (double)coord[k]);
                ++k;
            }
            res[j] = ss;
            ++j;
        }
        return res;
    }

    @Override
    public float[] getPointVariable(int var, int[] dims) {
        double[][] vp = this.getVecteursPropres();
        double[] iv = this.ed.getRealEigenvalues();
        float[] res = new float[dims.length];
        int j = 0;
        while (j < dims.length) {
            res[j] = 0.0f;
            ++j;
        }
        j = 0;
        while (j < dims.length) {
            int n = j;
            res[n] = (float)((double)res[n] + vp[var][dims[j]]);
            ++j;
        }
        return res;
    }
}

