/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.compute.projection;

import Jama.EigenvalueDecomposition;
import explorer.compute.compute.projection.PMFactory;
import explorer.data.DataManager;
import javax.swing.JPanel;
import lib3d4j.compute.tools.OutilsAlgebre;
import lib3d4j.data.DescriptionData;
import lib3d4j.data.Source;
import lib3d4j.display3D.Display;
import lib3d4j.international.Messages;

public abstract class ProjectiveMethod {
    protected DescriptionData dd = DataManager.getSingleton().getCompAttr();
    protected float[][] dataProjected3D = null;
    protected float[][] dataProjected = null;
    protected float[] moyennes = null;
    protected float[][] centreGravite = null;
    protected EigenvalueDecomposition ed = null;
    protected Source src;
    protected int nbObjects = 0;
    protected int nbTermes = 0;
    protected Display display = null;
    protected JPanel viewPanel = null;
    protected boolean[] actifs = null;
    protected boolean[] crossVal = null;
    protected int nbActifs;
    protected int type;
    private String id;

    public int getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public abstract void calculer();

    public abstract float[][] creerProjection3D(int[] var1);

    public abstract void retourPremiereProjection3D(int[] var1);

    public abstract void creerProjection();

    public abstract float[] projection(int var1, int[] var2);

    public abstract float[] projection(float[] var1, int[] var2);

    public abstract float[] getPointVariable(int var1, int[] var2);

    public abstract float[] getAxisProjection(int var1);

    public abstract int getNbDimensions();

    public void setParameterValue(int indice, int valeur) {
    }

    public void setParameterValue(int indice, float valeur) {
    }

    public Source getSource() {
        return this.src;
    }

    public float[][] getDataProjectedActifs() {
        float[][] res = new float[this.nbActifs][];
        int cpt = 0;
        int i = 0;
        while (i < this.dataProjected.length) {
            if (this.estActif(i)) {
                res[cpt] = this.dataProjected[i];
                ++cpt;
            }
            ++i;
        }
        return res;
    }

    public ProjectiveMethod() {
    }

    public ProjectiveMethod(Source src, int type) {
        this.src = src;
        this.type = type;
        this.nbActifs = this.nbObjects = src.getNbObjects();
        this.actifs = new boolean[this.nbObjects];
        int i = 0;
        while (i < this.nbObjects) {
            this.actifs[i] = true;
            ++i;
        }
    }

    public void setActivite(int i, boolean activation) {
        if (this.actifs[i] && !activation) {
            --this.nbActifs;
        } else if (!this.actifs[i] && activation) {
            ++this.nbActifs;
        }
        this.actifs[i] = activation;
    }

    public int getNbActifs() {
        return this.nbActifs;
    }

    public int getNbObjets() {
        return this.nbObjects;
    }

    public int[] classeActifs() {
        int[] res = new int[this.nbActifs];
        int actifRank = 0;
        int i = 0;
        while (i < this.nbObjects) {
            if (this.estActif(i)) {
                res[actifRank] = this.classe(i);
                ++actifRank;
            }
            ++i;
        }
        return res;
    }

    public int classe(int i) {
        return this.dd.getClassIndice(i);
    }

    public float varianceTotale(int[] dims) {
        float som = 0.0f;
        float[] centre = this.projection(this.centreGravite[DataManager.getSingleton().getCompAttr().getNbClasses()], dims);
        int i = 0;
        while (i < this.nbActifs) {
            float[] proj = this.projection(i, dims);
            float dist = 0.0f;
            int j = 0;
            while (j < dims.length) {
                dist += (centre[j] - proj[j]) * (centre[j] - proj[j]);
                ++j;
            }
            som += dist;
            ++i;
        }
        return som / (1.0f * (float)this.nbActifs);
    }

    public float varianceInter(int[] dims) {
        float som = 0.0f;
        int n = this.dd.getNbClasses();
        int[] repart = new int[n];
        float[] centre = this.projection(this.centreGravite[n], dims);
        int i = 0;
        while (i < n) {
            repart[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.nbObjects) {
            if (this.actifs[i]) {
                int n2 = this.dd.getClassIndice(i);
                repart[n2] = repart[n2] + 1;
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            float[] centrei = this.projection(this.centreGravite[i], dims);
            float dist = 0.0f;
            int j = 0;
            while (j < dims.length) {
                dist += (centre[j] - centrei[j]) * (centre[j] - centrei[j]);
                ++j;
            }
            som += dist * (1.0f * (float)repart[i]);
            ++i;
        }
        return som / (1.0f * (float)this.nbActifs);
    }

    public float varianceIntra(int[] dims) {
        int n = this.dd.getNbClasses();
        float[] som = new float[n];
        float[][] centres = new float[n][];
        float s = 0.0f;
        int i = 0;
        while (i < n) {
            som[i] = 0.0f;
            ++i;
        }
        i = 0;
        while (i < n) {
            centres[i] = this.projection(this.centreGravite[i], dims);
            ++i;
        }
        i = 0;
        while (i < this.nbObjects) {
            if (this.actifs[i]) {
                int k = this.dd.getClassIndice(i);
                float[] proj = this.projection(i, dims);
                float dist = 0.0f;
                int j = 0;
                while (j < dims.length) {
                    dist += (centres[k][j] - proj[j]) * (centres[k][j] - proj[j]);
                    ++j;
                }
                int n2 = k;
                som[n2] = som[n2] + dist;
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            s += som[i];
            ++i;
        }
        return s / (1.0f * (float)this.nbActifs);
    }

    public float getDunnIndice() {
        if (DataManager.getSingleton().getCompAttr().isClassAttrGiven()) {
            float maxDiam = 0.0f;
            float minDist = 1000000.0f;
            if (this.dataProjected3D == null) {
                return 0.0f;
            }
            int i = 0;
            while (i < this.dataProjected3D.length) {
                int j = i + 1;
                while (j < this.dataProjected3D.length) {
                    float dist = this.distance3D(i, j);
                    if (this.classe(i) == this.classe(j)) {
                        if (dist > maxDiam) {
                            maxDiam = dist;
                        }
                    } else if (dist < minDist) {
                        minDist = dist;
                    }
                    ++j;
                }
                ++i;
            }
            return minDist / maxDiam;
        }
        return -1.0f;
    }

    public float distanceND(int i, int j, int N) {
        float d = 0.0f;
        try {
            int k = 0;
            while (k < N) {
                d += (this.dataProjected[i][k] - this.dataProjected[j][k]) * (this.dataProjected[i][k] - this.dataProjected[j][k]);
                ++k;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return (float)Math.sqrt(d);
    }

    public abstract float getDistance(int var1, int var2);

    public float distance3D(int i, int j) {
        float d = 0.0f;
        try {
            d = (this.dataProjected3D[i][0] - this.dataProjected3D[j][0]) * (this.dataProjected3D[i][0] - this.dataProjected3D[j][0]) + (this.dataProjected3D[i][1] - this.dataProjected3D[j][1]) * (this.dataProjected3D[i][1] - this.dataProjected3D[j][1]) + (this.dataProjected3D[i][2] - this.dataProjected3D[j][2]) * (this.dataProjected3D[i][2] - this.dataProjected3D[j][2]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return (float)Math.sqrt(d);
    }

    public float distProjected(int i, int j, int nb, float[][] data) {
        float d = 0.0f;
        int n = 0;
        while (n < nb) {
            d += (data[i][n] - data[j][n]) * (data[i][n] - data[j][n]);
            ++n;
        }
        return (float)Math.sqrt(d);
    }

    public float distanceDroite(float[] coordPtExterieur, float[] vectDroite, float[] coordPtDroite) {
        float[] autrePtDroite = new float[coordPtDroite.length];
        int i = 0;
        while (i < coordPtDroite.length) {
            autrePtDroite[i] = coordPtDroite[i] + vectDroite[i];
            ++i;
        }
        float[] resVect = new float[coordPtDroite.length];
        float d1 = OutilsAlgebre.distance(coordPtDroite, autrePtDroite);
        float d2 = OutilsAlgebre.distance(autrePtDroite, coordPtExterieur);
        float d3 = OutilsAlgebre.distance(coordPtDroite, coordPtExterieur);
        float m = (d1 * d1 + d3 * d3 - d2 * d2) / (2.0f * d1);
        int i2 = 0;
        while (i2 < coordPtDroite.length) {
            resVect[i2] = coordPtDroite[i2] + (autrePtDroite[i2] - coordPtDroite[i2]) * m / d1;
            ++i2;
        }
        float res = 0.0f;
        int i3 = 0;
        while (i3 < coordPtDroite.length) {
            res += (resVect[i3] - coordPtExterieur[i3]) * (resVect[i3] - coordPtExterieur[i3]);
            ++i3;
        }
        return (float)Math.sqrt(res);
    }

    public boolean estActif(int i) {
        return this.actifs[i];
    }

    public float varExpliq(int[] axes) {
        int nbterme = this.getNbDimensions();
        if (this.ed == null) {
            return 0.0f;
        }
        double[] iv = this.ed.getRealEigenvalues();
        double somtot = 0.0;
        double somex = 0.0;
        int taille = nbterme;
        int i = 0;
        while (i < taille) {
            somtot += iv[i];
            ++i;
        }
        somex = 0.0;
        i = 0;
        while (i < 3) {
            if (axes[i] >= 0) {
                somex += iv[axes[i]];
            }
            ++i;
        }
        Double dd = new Double(somex * 100.0 / somtot);
        return dd.floatValue();
    }

    public float[] getVarEx() {
        if (this.ed == null) {
            return null;
        }
        double[] iv = this.ed.getRealEigenvalues();
        double somtot = 0.0;
        int nbDim = this.getNbDimensions();
        int i = 0;
        while (i < nbDim) {
            somtot += iv[i];
            ++i;
        }
        float[] somex = new float[nbDim];
        somex[0] = (float)iv[0];
        i = 1;
        while (i < nbDim) {
            somex[i] = somex[i - 1] + (float)iv[i];
            ++i;
        }
        i = 0;
        while (i < nbDim) {
            int n = i++;
            somex[n] = (float)((double)somex[n] * (100.0 / somtot));
        }
        return somex;
    }

    public EigenvalueDecomposition getED() {
        return this.ed;
    }

    public float[][] getDataProjected3D() {
        return this.dataProjected3D;
    }

    public float[] getMoyennes() {
        return this.moyennes;
    }

    public int numeroPlusProcheActif(float[] point) {
        int max = 0;
        boolean trouve = false;
        while (!trouve) {
            if (this.actifs[max]) {
                trouve = true;
                continue;
            }
            ++max;
        }
        int i = 1;
        while (i < this.dataProjected.length) {
            if (OutilsAlgebre.distance(this.dataProjected[i], point) < OutilsAlgebre.distance(this.dataProjected[max], point) && this.actifs[i]) {
                max = i;
            }
            ++i;
        }
        return max;
    }

    public String toString() {
        return Messages.getString(PMFactory.getSingleton().getTypeName(this.type));
    }
}

