/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.kernels;

import explorer.compute.kernels.Edge;
import explorer.compute.kernels.Vertex;
import java.util.PriorityQueue;

public class Dijkstra {
    public static boolean isComplet(float[][] mat) {
        Vertex[] vertex = Dijkstra.createData(mat);
        int i = 0;
        while (i < vertex.length) {
            Dijkstra.computePaths(vertex[i]);
            int j = i;
            while (j < vertex.length) {
                if (vertex[j].minDistance == Float.POSITIVE_INFINITY) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private static Vertex[] createData(float[][] mat) {
        boolean[][] passe = new boolean[mat.length][mat.length];
        Vertex[] data = new Vertex[mat.length];
        int i = 0;
        while (i < mat.length) {
            data[i] = new Vertex(i);
            ++i;
        }
        i = 0;
        while (i < mat.length) {
            int j = 0;
            while (j < mat.length) {
                if (mat[i][j] != -1.0f && !passe[i][j] && !passe[j][i]) {
                    data[i].adjacencies.add(new Edge(data[j], mat[i][j]));
                    data[j].adjacencies.add(new Edge(data[i], mat[i][j]));
                    passe[i][j] = true;
                    passe[j][i] = true;
                }
                ++j;
            }
            ++i;
        }
        return data;
    }

    private static void computePaths(Vertex source) {
        source.minDistance = 0.0f;
        PriorityQueue<Vertex> vertexQueue = new PriorityQueue<Vertex>();
        vertexQueue.add(source);
        while (!vertexQueue.isEmpty()) {
            Vertex u = (Vertex)vertexQueue.poll();
            for (Edge e : u.adjacencies) {
                Vertex v = e.target;
                float weight = e.weight;
                float distanceThroughU = u.minDistance + weight;
                if (!(distanceThroughU < v.minDistance)) continue;
                vertexQueue.remove(v);
                v.minDistance = distanceThroughU;
                v.previous = u;
                vertexQueue.add(v);
            }
        }
    }

    public static float[][] createMatriceDistance(float[][] mat) {
        Vertex[] data = Dijkstra.createData(mat);
        float[][] matriceDistance = new float[data.length][data.length];
        float maxDistance = -1.0f;
        int i = 0;
        while (i < data.length) {
            int j = 0;
            while (j < data.length) {
                data[j].minDistance = Float.POSITIVE_INFINITY;
                data[j].previous = null;
                ++j;
            }
            Dijkstra.computePaths(data[i]);
            j = i;
            while (j < data.length) {
                matriceDistance[i][j] = data[j].minDistance;
                matriceDistance[j][i] = data[j].minDistance;
                if (matriceDistance[i][j] > maxDistance && matriceDistance[i][j] != Float.POSITIVE_INFINITY) {
                    maxDistance = matriceDistance[i][j];
                }
                ++j;
            }
            ++i;
        }
        return matriceDistance;
    }
}

