/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.kernels;

import Jama.LUDecomposition;
import Jama.Matrix;
import explorer.compute.kernels.Kernel;

public class LLE
extends Kernel {
    private float[][] matriceNoyau = null;
    private float[][] matriceScalaireBase = null;
    private int nbVoisin = 3;
    private float epsilon = 0.1f;

    public LLE(int nbVoisin) {
        this.nbVoisin = nbVoisin;
    }

    public void setNbVoisin(int nbVoisin) {
        this.nbVoisin = nbVoisin;
    }

    private static float[][] createScalaireMatrix(float[][] distance) {
        float val;
        int j;
        float moy = 0.0f;
        float[] moyLigne = new float[distance.length];
        int i = 0;
        while (i < distance.length) {
            moyLigne[i] = 0.0f;
            j = 0;
            while (j < distance.length) {
                if (i != j) {
                    val = distance[i][j];
                    moy -= val * val / 2.0f;
                    int n = i;
                    moyLigne[n] = moyLigne[n] - val * val / 2.0f;
                }
                ++j;
            }
            moyLigne[i] = moyLigne[i] / (float)distance.length;
            ++i;
        }
        moy /= (float)(distance.length * distance.length);
        float[][] matrice = new float[distance.length][distance.length];
        i = 0;
        while (i < distance.length) {
            j = i;
            while (j < distance.length) {
                val = distance[i][j];
                matrice[i][j] = -val * val / 2.0f - moyLigne[i] - moyLigne[j] + moy;
                matrice[j][i] = matrice[i][j];
                ++j;
            }
            ++i;
        }
        return matrice;
    }

    private int[][] searchVoisin(float[][] distance) {
        int[][] indexVoisin = new int[this.nbObjets][this.nbVoisin];
        float[] dist = new float[this.nbObjets];
        int[] index = new int[this.nbObjets];
        int i = 0;
        while (i < this.nbObjets) {
            int j = 0;
            while (j < this.nbObjets) {
                dist[j] = distance[i][j];
                index[j] = j;
                ++j;
            }
            LLE.quicksort(dist, index, 0, this.nbObjets - 1);
            j = 0;
            while (j < this.nbVoisin) {
                indexVoisin[i][j] = index[j + 1];
                ++j;
            }
            ++i;
        }
        return indexVoisin;
    }

    private void createLLE() {
        if (this.matriceDistanceBase == null) {
            this.createMatrixDistanceBase();
        }
        this.matriceScalaireBase = LLE.createScalaireMatrix(this.matriceDistanceBase);
        int[][] indexVoisin = this.searchVoisin(this.matriceDistanceBase);
        float[][] W = new float[this.nbObjets][this.nbObjets];
        Matrix G = new Matrix(this.nbVoisin, this.nbVoisin);
        Matrix ident = Matrix.identity(this.nbVoisin, this.nbVoisin);
        ident = ident.times(this.epsilon);
        int x = 0;
        while (x < this.nbObjets) {
            Matrix G1;
            int i = 0;
            while (i < this.nbVoisin) {
                int j = 0;
                while (j < this.nbVoisin) {
                    float somme = this.matriceScalaireBase[x][x] - this.matriceScalaireBase[x][indexVoisin[x][j]] - this.matriceScalaireBase[indexVoisin[x][i]][x] + this.matriceScalaireBase[indexVoisin[x][i]][indexVoisin[x][j]];
                    G.set(i, j, somme);
                    ++j;
                }
                ++i;
            }
            LUDecomposition test = new LUDecomposition(G);
            if (test.isNonsingular()) {
                G1 = G.inverse();
            } else {
                G = G.plus(ident);
                G1 = G.inverse();
            }
            Matrix w = new Matrix(this.nbVoisin, 1, 0.0);
            Matrix un = new Matrix(this.nbVoisin, 1, 1.0);
            w = G1.times(un);
            float somme3 = 0.0f;
            int i2 = 0;
            while (i2 < this.nbVoisin) {
                somme3 = (float)((double)somme3 + w.get(i2, 0));
                ++i2;
            }
            i2 = 0;
            while (i2 < this.nbObjets) {
                W[x][i2] = 0.0f;
                int j = 0;
                while (j < this.nbVoisin) {
                    if (indexVoisin[x][j] == i2) {
                        W[x][i2] = (float)w.get(j, 0) / somme3;
                    }
                    ++j;
                }
                ++i2;
            }
            ++x;
        }
        System.out.println("");
        this.matriceNoyau = new float[this.nbObjets][this.nbObjets];
        int i = 0;
        while (i < this.nbObjets) {
            int j = 0;
            while (j < this.nbObjets) {
                float somme = 0.0f;
                int k = 0;
                while (k < this.nbObjets) {
                    somme += W[k][i] * W[k][j];
                    ++k;
                }
                this.matriceNoyau[i][j] = W[i][j] + W[j][i] - somme;
                ++j;
            }
            ++i;
        }
    }

    private void createMatrixDistanceBase() {
        this.matriceDistanceBase = new float[this.nbObjets][this.nbObjets];
        int i = 0;
        while (i < this.nbObjets) {
            int j = 0;
            while (j < this.nbObjets) {
                this.matriceDistanceBase[i][j] = LLE.distance(this.data[i], this.data[j]);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public double[][] getScalaireMatrix() {
        if (this.matriceNoyau == null) {
            this.createLLE();
        }
        double[][] matriceDouble = new double[this.matriceNoyau.length][this.matriceNoyau.length];
        int i = 0;
        while (i < this.matriceNoyau.length) {
            int j = 0;
            while (j < this.matriceNoyau.length) {
                matriceDouble[i][j] = this.matriceNoyau[i][j];
                ++j;
            }
            ++i;
        }
        return matriceDouble;
    }

    @Override
    public float k(int x1, int x2) {
        if (this.matriceNoyau == null) {
            this.createLLE();
        }
        return this.matriceNoyau[x1][x2];
    }
}

