/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.scripts;

import explorer.compute.compute.projection.PMARDp;
import explorer.compute.compute.projection.PMAttrVal;
import explorer.compute.compute.projection.PMFactory;
import explorer.compute.compute.projection.PMKNNPCA;
import explorer.compute.compute.projection.PMLLE;
import explorer.compute.compute.projection.ProjectiveMethod;
import explorer.compute.compute.projection.conditionning.CenterConditioning;
import explorer.compute.compute.projection.conditionning.Conditioning;
import explorer.compute.compute.projection.conditionning.ConditioningFactory;
import explorer.compute.scripts.Ex3dScript;
import explorer.compute.scripts.Ex3dScriptContext;
import explorer.data.Source3DCoord;
import explorer.data.SourceAttrVal;
import explorer.data.SourceDist;
import java.util.HashMap;
import java.util.Map;
import json.JSONException;
import json.JSONObject;
import lib3d4j.data.Source;

public class ProjectiveMethodScript
implements Ex3dScript {
    private Map<Integer, PMReadWrite> map = new HashMap<Integer, PMReadWrite>();

    public ProjectiveMethodScript() {
        PMReadWrite pm = new PMRW_PMPCA();
        this.map.put(pm.getType(), pm);
        pm = new PMRW_PMPCA();
        this.map.put(pm.getType(), pm);
        pm = new PMRW_PMDualPCA();
        this.map.put(pm.getType(), pm);
        pm = new PMRW_PMLDA();
        this.map.put(pm.getType(), pm);
        pm = new PMRW_PMARDp();
        this.map.put(pm.getType(), pm);
        pm = new PMRW_PMLLE();
        this.map.put(pm.getType(), pm);
        pm = new PMRW_PMKNNPCA();
        this.map.put(pm.getType(), pm);
        pm = new PMRW_PMMDSClassic();
        this.map.put(pm.getType(), pm);
        pm = new PMRW_PMDirect();
        this.map.put(pm.getType(), pm);
    }

    @Override
    public JSONObject write(Object o) {
        if (!(o instanceof ProjectiveMethod)) {
            return null;
        }
        ProjectiveMethod pm = (ProjectiveMethod)o;
        JSONObject jos = new JSONObject();
        try {
            jos.put("msg", "projective-method");
            jos.put("source", pm.getSource().getId());
            jos.put("pm-id", pm.getId());
            int type = pm.getType();
            this.map.get(type).write(jos, pm);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jos;
    }

    @Override
    public void read(JSONObject jos, Ex3dScriptContext sc) {
        try {
            String cmdName = jos.getString("msg");
            if (cmdName.equals("projective-method")) {
                Source src = (Source)sc.get(jos.getString("source"));
                int type = jos.getInt("pm-type");
                String id = jos.getString("pm-id");
                ProjectiveMethod pm = this.map.get(type).read(jos, sc, src);
                pm.calculer();
                sc.add(id, pm);
            }
        }
        catch (JSONException jse) {
            jse.printStackTrace();
        }
    }

    private class PMRW_PMARDp
    extends PMRW_PMAttrVal {
        private PMRW_PMARDp() {
        }

        @Override
        public ProjectiveMethod read(JSONObject jos, Ex3dScriptContext sc, Source src) throws JSONException {
            super.read(jos, sc, src);
            float sigma = jos.getLong("sigma");
            return PMFactory.getSingleton().createPMARDp((SourceAttrVal)src, this.c, sigma);
        }

        @Override
        public void write(JSONObject jos, ProjectiveMethod pm) throws JSONException {
            super.write(jos, pm);
            jos.put("sigma", ((PMARDp)pm).getSigma());
        }

        @Override
        public int getType() {
            return PMFactory.ARDp;
        }
    }

    private abstract class PMRW_PMAttrVal
    extends PMReadWrite {
        protected Conditioning c;

        private PMRW_PMAttrVal() {
        }

        @Override
        public ProjectiveMethod read(JSONObject jos, Ex3dScriptContext sc, Source src) throws JSONException {
            if (!(src instanceof SourceAttrVal)) {
                return null;
            }
            SourceAttrVal sra = (SourceAttrVal)src;
            boolean centered = jos.getBoolean("cond-centered");
            int reduced = jos.getInt("cond-reduced");
            this.c = ConditioningFactory.createConditioning(reduced, centered);
            return null;
        }

        @Override
        public void write(JSONObject jos, ProjectiveMethod pm) throws JSONException {
            super.write(jos, pm);
            this.c = ((PMAttrVal)pm).getConditionning();
            boolean centered = false;
            if (this.c instanceof CenterConditioning) {
                centered = ((CenterConditioning)this.c).isCentered();
            }
            jos.put("cond-centered", centered);
            int reduced = this.c.getType();
            jos.put("cond-reduced", reduced);
        }
    }

    private class PMRW_PMDirect
    extends PMReadWrite {
        private PMRW_PMDirect() {
        }

        @Override
        public ProjectiveMethod read(JSONObject jos, Ex3dScriptContext sc, Source src) {
            if (src instanceof Source3DCoord) {
                return PMFactory.getSingleton().createPMDirect((Source3DCoord)src);
            }
            return null;
        }

        @Override
        public int getType() {
            return PMFactory.DIRECT;
        }
    }

    private class PMRW_PMDualPCA
    extends PMRW_PMAttrVal {
        private PMRW_PMDualPCA() {
        }

        @Override
        public ProjectiveMethod read(JSONObject jos, Ex3dScriptContext sc, Source src) throws JSONException {
            super.read(jos, sc, src);
            return PMFactory.getSingleton().createPMDualPCA((SourceAttrVal)src, this.c);
        }

        @Override
        public int getType() {
            return PMFactory.ACPDual;
        }
    }

    private class PMRW_PMKNNPCA
    extends PMRW_PMAttrVal {
        private PMRW_PMKNNPCA() {
        }

        @Override
        public ProjectiveMethod read(JSONObject jos, Ex3dScriptContext sc, Source src) throws JSONException {
            super.read(jos, sc, src);
            float diff = jos.getInt("knndiff");
            return PMFactory.getSingleton().createPMKNNPCA((SourceAttrVal)src, this.c, diff);
        }

        @Override
        public void write(JSONObject jos, ProjectiveMethod pm) throws JSONException {
            super.write(jos, pm);
            jos.put("knndiff", ((PMKNNPCA)pm).getKnnDiff());
        }

        @Override
        public int getType() {
            return PMFactory.ACPkNN;
        }
    }

    private class PMRW_PMLDA
    extends PMRW_PMAttrVal {
        private PMRW_PMLDA() {
        }

        @Override
        public ProjectiveMethod read(JSONObject jos, Ex3dScriptContext sc, Source src) throws JSONException {
            super.read(jos, sc, src);
            return PMFactory.getSingleton().createPMLDA((SourceAttrVal)src, this.c);
        }

        @Override
        public int getType() {
            return PMFactory.LDA;
        }
    }

    private class PMRW_PMLLE
    extends PMRW_PMAttrVal {
        private PMRW_PMLLE() {
        }

        @Override
        public ProjectiveMethod read(JSONObject jos, Ex3dScriptContext sc, Source src) throws JSONException {
            super.read(jos, sc, src);
            int nbg = jos.getInt("neighbors");
            return PMFactory.getSingleton().createPMARDp((SourceAttrVal)src, this.c, nbg);
        }

        @Override
        public void write(JSONObject jos, ProjectiveMethod pm) throws JSONException {
            super.write(jos, pm);
            jos.put("neighbors", ((PMLLE)pm).getNbNeighbors());
        }

        @Override
        public int getType() {
            return PMFactory.LLE;
        }
    }

    private class PMRW_PMMDSClassic
    extends PMReadWrite {
        private PMRW_PMMDSClassic() {
        }

        @Override
        public ProjectiveMethod read(JSONObject jos, Ex3dScriptContext sc, Source src) {
            if (src instanceof SourceDist) {
                return PMFactory.getSingleton().createPMMDSClassic((SourceDist)src);
            }
            return null;
        }

        @Override
        public int getType() {
            return PMFactory.MDS;
        }
    }

    private class PMRW_PMPCA
    extends PMRW_PMAttrVal {
        private PMRW_PMPCA() {
        }

        @Override
        public ProjectiveMethod read(JSONObject jos, Ex3dScriptContext sc, Source src) throws JSONException {
            super.read(jos, sc, src);
            return PMFactory.getSingleton().createPMPCA((SourceAttrVal)src, this.c);
        }

        @Override
        public int getType() {
            return PMFactory.ACP;
        }
    }

    private abstract class PMReadWrite {
        private PMReadWrite() {
        }

        public abstract ProjectiveMethod read(JSONObject var1, Ex3dScriptContext var2, Source var3) throws JSONException;

        public void write(JSONObject jos, ProjectiveMethod pm) throws JSONException {
            jos.put("pm-type", pm.getType());
        }

        public abstract int getType();
    }
}

