/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.tools;

import explorer.compute.compute.projection.PMDirect;
import explorer.compute.compute.projection.PMFactory;
import explorer.compute.compute.projection.PMPCA;
import explorer.compute.compute.projection.ProjectionFactory;
import explorer.compute.compute.projection.ProjectiveMethod;
import explorer.compute.compute.projection.StandardProjection;
import explorer.compute.compute.projection.conditionning.ConditioningFactory;
import explorer.compute.kernels.Kernel;
import explorer.compute.svm.SVM;
import explorer.compute.tools.GViewTool;
import explorer.data.Common;
import explorer.data.DataManager;
import explorer.data.Source3DCoord;
import explorer.data.SourceAttrVal;
import explorer.data.SrcObserver;
import explorer.data.ViewManager;
import explorer.display3D.javafx.DisplayJFXExplorer;
import explorer.windows.w2D.icview.ICVSVM;
import explorer.windows.w2D.icview.ICVSVMDisplayMode;
import explorer.windows.w2D.utils.GView;
import javax.swing.JOptionPane;
import lib3d4j.data.Source;
import lib3d4j.display3D.java3D.tools.LocalCoord;
import lib3d4j.international.Messages;

public class OutilSVM
extends GViewTool
implements SrcObserver {
    private int nbObjects;
    private int nbTerms;
    private int nbPoints;
    private SourceAttrVal src;
    private ICVSVM tpgSvm = null;
    private ICVSVMDisplayMode tpgSvmDM = null;
    ProjectiveMethod currentPM = null;

    public OutilSVM() {
        ViewManager.getSingleton().addSrcObserver(this);
    }

    public void setTpgSvm(ICVSVM tpg) {
        this.tpgSvm = tpg;
    }

    public void setTpgSvmDisplayMode(ICVSVMDisplayMode tpg) {
        this.tpgSvmDM = tpg;
    }

    public void tracerPlan() {
        this.nbObjects = this.src.getNbObjects();
        float[] targets = new float[this.nbObjects];
        float[][] points = null;
        int index1 = this.tpgSvm.getIndexSelectedClass1();
        int index2 = this.tpgSvm.getIndexSelectedClass2();
        int i = 0;
        while (i < this.nbObjects) {
            targets[i] = DataManager.getSingleton().getCompAttr().getClassIndice(i) == index1 ? 1.0f : (index2 != this.tpgSvm.restIndice() ? (DataManager.getSingleton().getCompAttr().getClassIndice(i) == index2 ? -1.0f : 0.0f) : -1.0f);
            ++i;
        }
        if (this.currentPM != null) {
            points = (float[][])this.f3d.getProjection().getCoordinates().clone();
        }
        SVM svm = new SVM(targets, points);
        svm.setConstant(this.tpgSvm.getConstant());
        svm.computeSVM();
        svm.computeHx();
        LocalCoord localCoord = this.f3d.getLocalCoord();
        float ul = 500.0f;
        float minCoord = -0.5f * ul;
        float maxCoord = 0.5f * ul;
        float[] localCoordMin = new float[]{minCoord, minCoord, minCoord};
        float[] localCoordMax = new float[]{maxCoord, maxCoord, maxCoord};
        float[] coordGlobalMin = new float[3];
        float[] coordGlobalMax = new float[3];
        float[] coordGlobalSVM = new float[3];
        float[] coordLocalSVM = new float[3];
        float[][] coordLocalTriangles = new float[12][3];
        int nbPointsTriangles = 0;
        boolean[] positionPoints = new boolean[12];
        int i2 = 0;
        while (i2 < 12) {
            positionPoints[i2] = false;
            ++i2;
        }
        i2 = 0;
        while (i2 < 3) {
            coordGlobalMin[i2] = localCoord.getCoordGlobal(localCoordMin)[i2];
            coordGlobalMax[i2] = localCoord.getCoordGlobal(localCoordMax)[i2];
            ++i2;
        }
        coordGlobalSVM[0] = (svm.getB() - svm.getWi(1) * coordGlobalMax[1] - svm.getWi(2) * coordGlobalMax[2]) / svm.getWi(0);
        coordGlobalSVM[1] = coordGlobalMax[1];
        coordGlobalSVM[2] = coordGlobalMax[2];
        coordLocalSVM = localCoord.getLocCoord(coordGlobalSVM);
        if (coordLocalSVM[0] >= minCoord && coordLocalSVM[0] <= maxCoord) {
            coordLocalTriangles[nbPointsTriangles][0] = coordLocalSVM[0];
            coordLocalTriangles[nbPointsTriangles][1] = maxCoord;
            coordLocalTriangles[nbPointsTriangles][2] = maxCoord;
            positionPoints[0] = true;
            ++nbPointsTriangles;
        }
        coordGlobalSVM[0] = (svm.getB() - svm.getWi(1) * coordGlobalMin[1] - svm.getWi(2) * coordGlobalMin[2]) / svm.getWi(0);
        coordGlobalSVM[1] = coordGlobalMin[1];
        coordGlobalSVM[2] = coordGlobalMin[2];
        coordLocalSVM = localCoord.getLocCoord(coordGlobalSVM);
        if (coordLocalSVM[0] >= minCoord && coordLocalSVM[0] <= maxCoord) {
            coordLocalTriangles[nbPointsTriangles][0] = coordLocalSVM[0];
            coordLocalTriangles[nbPointsTriangles][1] = minCoord;
            coordLocalTriangles[nbPointsTriangles][2] = minCoord;
            positionPoints[1] = true;
            ++nbPointsTriangles;
        }
        coordGlobalSVM[0] = (svm.getB() - svm.getWi(1) * coordGlobalMax[1] - svm.getWi(2) * coordGlobalMin[2]) / svm.getWi(0);
        coordGlobalSVM[1] = coordGlobalMax[1];
        coordGlobalSVM[2] = coordGlobalMin[2];
        coordLocalSVM = localCoord.getLocCoord(coordGlobalSVM);
        if (coordLocalSVM[0] >= minCoord && coordLocalSVM[0] <= maxCoord) {
            coordLocalTriangles[nbPointsTriangles][0] = coordLocalSVM[0];
            coordLocalTriangles[nbPointsTriangles][1] = maxCoord;
            coordLocalTriangles[nbPointsTriangles][2] = minCoord;
            positionPoints[2] = true;
            ++nbPointsTriangles;
        }
        coordGlobalSVM[0] = (svm.getB() - svm.getWi(1) * coordGlobalMin[1] - svm.getWi(2) * coordGlobalMax[2]) / svm.getWi(0);
        coordGlobalSVM[1] = coordGlobalMin[1];
        coordGlobalSVM[2] = coordGlobalMax[2];
        coordLocalSVM = localCoord.getLocCoord(coordGlobalSVM);
        if (coordLocalSVM[0] >= minCoord && coordLocalSVM[0] <= maxCoord) {
            coordLocalTriangles[nbPointsTriangles][0] = coordLocalSVM[0];
            coordLocalTriangles[nbPointsTriangles][1] = minCoord;
            coordLocalTriangles[nbPointsTriangles][2] = maxCoord;
            positionPoints[3] = true;
            ++nbPointsTriangles;
        }
        coordGlobalSVM[0] = coordGlobalMax[0];
        coordGlobalSVM[1] = (svm.getB() - svm.getWi(0) * coordGlobalMax[0] - svm.getWi(2) * coordGlobalMax[2]) / svm.getWi(1);
        coordGlobalSVM[2] = coordGlobalMax[2];
        coordLocalSVM = localCoord.getLocCoord(coordGlobalSVM);
        if (coordLocalSVM[1] >= minCoord && coordLocalSVM[1] <= maxCoord) {
            coordLocalTriangles[nbPointsTriangles][0] = maxCoord;
            coordLocalTriangles[nbPointsTriangles][1] = coordLocalSVM[1];
            coordLocalTriangles[nbPointsTriangles][2] = maxCoord;
            positionPoints[4] = true;
            ++nbPointsTriangles;
        }
        coordGlobalSVM[0] = coordGlobalMin[0];
        coordGlobalSVM[1] = (svm.getB() - svm.getWi(0) * coordGlobalMin[0] - svm.getWi(2) * coordGlobalMin[2]) / svm.getWi(1);
        coordGlobalSVM[2] = coordGlobalMin[2];
        coordLocalSVM = localCoord.getLocCoord(coordGlobalSVM);
        if (coordLocalSVM[1] >= minCoord && coordLocalSVM[1] <= maxCoord) {
            coordLocalTriangles[nbPointsTriangles][0] = minCoord;
            coordLocalTriangles[nbPointsTriangles][1] = coordLocalSVM[1];
            coordLocalTriangles[nbPointsTriangles][2] = minCoord;
            positionPoints[5] = true;
            ++nbPointsTriangles;
        }
        coordGlobalSVM[0] = coordGlobalMax[0];
        coordGlobalSVM[1] = (svm.getB() - svm.getWi(0) * coordGlobalMax[0] - svm.getWi(2) * coordGlobalMin[2]) / svm.getWi(1);
        coordGlobalSVM[2] = coordGlobalMin[2];
        coordLocalSVM = localCoord.getLocCoord(coordGlobalSVM);
        if (coordLocalSVM[1] >= minCoord && coordLocalSVM[1] <= maxCoord) {
            coordLocalTriangles[nbPointsTriangles][0] = maxCoord;
            coordLocalTriangles[nbPointsTriangles][1] = coordLocalSVM[1];
            coordLocalTriangles[nbPointsTriangles][2] = minCoord;
            positionPoints[6] = true;
            ++nbPointsTriangles;
        }
        coordGlobalSVM[0] = coordGlobalMin[0];
        coordGlobalSVM[1] = (svm.getB() - svm.getWi(0) * coordGlobalMin[0] - svm.getWi(2) * coordGlobalMax[2]) / svm.getWi(1);
        coordGlobalSVM[2] = coordGlobalMax[2];
        coordLocalSVM = localCoord.getLocCoord(coordGlobalSVM);
        if (coordLocalSVM[1] >= minCoord && coordLocalSVM[1] <= maxCoord) {
            coordLocalTriangles[nbPointsTriangles][0] = minCoord;
            coordLocalTriangles[nbPointsTriangles][1] = coordLocalSVM[1];
            coordLocalTriangles[nbPointsTriangles][2] = maxCoord;
            positionPoints[7] = true;
            ++nbPointsTriangles;
        }
        coordGlobalSVM[0] = coordGlobalMax[0];
        coordGlobalSVM[1] = coordGlobalMax[1];
        coordGlobalSVM[2] = (svm.getB() - svm.getWi(0) * coordGlobalMax[0] - svm.getWi(1) * coordGlobalMax[1]) / svm.getWi(2);
        coordLocalSVM = localCoord.getLocCoord(coordGlobalSVM);
        if (coordLocalSVM[2] >= minCoord && coordLocalSVM[2] <= maxCoord) {
            coordLocalTriangles[nbPointsTriangles][0] = maxCoord;
            coordLocalTriangles[nbPointsTriangles][1] = maxCoord;
            coordLocalTriangles[nbPointsTriangles][2] = coordLocalSVM[2];
            positionPoints[8] = true;
            ++nbPointsTriangles;
        }
        coordGlobalSVM[0] = coordGlobalMin[0];
        coordGlobalSVM[1] = coordGlobalMin[1];
        coordGlobalSVM[2] = (svm.getB() - svm.getWi(0) * coordGlobalMin[0] - svm.getWi(1) * coordGlobalMin[1]) / svm.getWi(2);
        coordLocalSVM = localCoord.getLocCoord(coordGlobalSVM);
        if (coordLocalSVM[2] >= minCoord && coordLocalSVM[2] <= maxCoord) {
            coordLocalTriangles[nbPointsTriangles][0] = minCoord;
            coordLocalTriangles[nbPointsTriangles][1] = minCoord;
            coordLocalTriangles[nbPointsTriangles][2] = coordLocalSVM[2];
            positionPoints[9] = true;
            ++nbPointsTriangles;
        }
        coordGlobalSVM[0] = coordGlobalMax[0];
        coordGlobalSVM[1] = coordGlobalMin[1];
        coordGlobalSVM[2] = (svm.getB() - svm.getWi(0) * coordGlobalMax[0] - svm.getWi(1) * coordGlobalMin[1]) / svm.getWi(2);
        coordLocalSVM = localCoord.getLocCoord(coordGlobalSVM);
        if (coordLocalSVM[2] >= minCoord && coordLocalSVM[2] <= maxCoord) {
            coordLocalTriangles[nbPointsTriangles][0] = maxCoord;
            coordLocalTriangles[nbPointsTriangles][1] = minCoord;
            coordLocalTriangles[nbPointsTriangles][2] = coordLocalSVM[2];
            positionPoints[10] = true;
            ++nbPointsTriangles;
        }
        coordGlobalSVM[0] = coordGlobalMin[0];
        coordGlobalSVM[1] = coordGlobalMax[1];
        coordGlobalSVM[2] = (svm.getB() - svm.getWi(0) * coordGlobalMin[0] - svm.getWi(1) * coordGlobalMax[1]) / svm.getWi(2);
        coordLocalSVM = localCoord.getLocCoord(coordGlobalSVM);
        if (coordLocalSVM[2] >= minCoord && coordLocalSVM[2] <= maxCoord) {
            coordLocalTriangles[nbPointsTriangles][0] = minCoord;
            coordLocalTriangles[nbPointsTriangles][1] = maxCoord;
            coordLocalTriangles[nbPointsTriangles][2] = coordLocalSVM[2];
            positionPoints[11] = true;
            ++nbPointsTriangles;
        }
        this.nbPoints = nbPointsTriangles;
        if (nbPointsTriangles > 0) {
            this.f3d.drawPlane(coordLocalTriangles, nbPointsTriangles, positionPoints);
        }
    }

    public void colorer() {
        this.nbObjects = this.src.getNbObjects();
        this.nbTerms = this.src.getNbAttACP();
        float[] targets = new float[this.nbObjects];
        float[][] points = new float[this.nbObjects][this.nbTerms];
        int index1 = this.tpgSvm.getIndexSelectedClass1();
        int index2 = this.tpgSvm.getIndexSelectedClass2();
        float[] moyenne = null;
        int i = 0;
        while (i < this.nbObjects) {
            targets[i] = DataManager.getSingleton().getCompAttr().getClassIndice(i) == index1 ? 1.0f : (index2 != this.tpgSvm.restIndice() ? (DataManager.getSingleton().getCompAttr().getClassIndice(i) == index2 ? -1.0f : 0.0f) : -1.0f);
            ++i;
        }
        if (this.tpgSvmDM.getSVMComputeModeIndex() == 0) {
            i = 0;
            while (i < this.src.getNbAttACP()) {
                int j = 0;
                while (j < this.src.getNbObjects()) {
                    points[j][i] = this.src.getAttrValue(j, i);
                    ++j;
                }
                ++i;
            }
        } else if (this.tpgSvmDM.getSVMComputeModeIndex() == 1 && this.currentPM != null) {
            points = (float[][])this.f3d.getProjection().getCoordinates().clone();
            moyenne = this.currentPM.getMoyennes();
        }
        SVM svm = new SVM(targets, points);
        svm.setConstant(this.tpgSvm.getConstant());
        Kernel k = Common.getSingleton().getKernel();
        if (k != null) {
            svm.setKernel(k, moyenne);
        }
        svm.computeSVM();
        svm.computeHx();
        float[] values = new float[svm.getHx().length];
        int i2 = 0;
        while (i2 < svm.getHx().length) {
            values[i2] = svm.getHxAt(i2);
            ++i2;
        }
        DataManager.getSingleton().getCompAttr().addColumn(values, "SVM_COLOR");
        DataManager.getSingleton().setColorAttribute("SVM_COLOR");
    }

    public void remplacer3emeAxe() {
        this.nbObjects = this.src.getNbObjects();
        this.nbTerms = this.src.getNbAttACP();
        float[] moy = null;
        float[] targets = new float[this.nbObjects];
        float[][] points = null;
        float[][] points3D = new float[this.nbObjects][3];
        int index1 = this.tpgSvm.getIndexSelectedClass1();
        int index2 = this.tpgSvm.getIndexSelectedClass2();
        int i = 0;
        while (i < this.nbObjects) {
            targets[i] = DataManager.getSingleton().getCompAttr().getClassIndice(i) == index1 ? 1.0f : (index2 != this.tpgSvm.restIndice() ? (DataManager.getSingleton().getCompAttr().getClassIndice(i) == index2 ? -1.0f : 0.0f) : -1.0f);
            ++i;
        }
        if (this.tpgSvmDM.getSVMComputeModeIndex() == 0) {
            points = new float[this.nbObjects][this.nbTerms];
            i = 0;
            while (i < this.src.getNbAttACP()) {
                int j = 0;
                while (j < this.src.getNbObjects()) {
                    points[j][i] = this.src.getAttrValue(j, i);
                    ++j;
                }
                ++i;
            }
        } else {
            points = new float[this.nbObjects][3];
        }
        if (this.currentPM != null) {
            points = (float[][])this.f3d.getProjection().getCoordinates().clone();
            points3D = (float[][])points.clone();
            moy = this.currentPM.getMoyennes();
        }
        SVM svm = new SVM(targets, points);
        svm.setConstant(this.tpgSvm.getConstant());
        System.out.println(" mettre \u00e0 jour le noyau 1 ");
        Kernel k = Common.getSingleton().getKernel();
        if (k != null) {
            svm.setKernel(k, moy);
        }
        svm.computeSVM();
        svm.computeHx();
        float[][] data = new float[points.length][3];
        float somme = 0.0f;
        float variance = 0.0f;
        float ecartype = 0.0f;
        int i2 = 0;
        while (i2 < this.nbObjects) {
            somme += svm.getHxAt(i2);
            ++i2;
        }
        float m = somme / (float)this.nbObjects;
        i2 = 0;
        while (i2 < this.nbObjects) {
            variance += (svm.getHxAt(i2) - m) * (svm.getHxAt(i2) - m);
            ++i2;
        }
        ecartype = (float)Math.sqrt(variance /= (float)this.nbObjects);
        i2 = 0;
        while (i2 < 3) {
            int j = 0;
            while (j < points.length) {
                data[j][i2] = i2 == 2 ? svm.getHxAt(j) / ecartype : points3D[j][i2];
                ++j;
            }
            ++i2;
        }
        int j = 0;
        while (j < points.length) {
            int i3 = 0;
            while (i3 < 3) {
                System.out.print(String.valueOf(data[j][i3]) + " ");
                ++i3;
            }
            System.out.println();
            ++j;
        }
        Source3DCoord src3d = DataManager.getSingleton().createSource3DCoord(data);
        src3d.setParent(this.currentPM.getSource(), true);
        PMDirect pm = PMFactory.getSingleton().createPMDirect(src3d);
        ((ProjectiveMethod)pm).calculer();
        StandardProjection proj = ProjectionFactory.createStandardProjection(pm);
        new DisplayJFXExplorer(proj).setVisible(true);
    }

    public void redescription1N() {
        this.nbObjects = this.src.getNbObjects();
        this.nbTerms = this.src.getNbAttACP();
        int nbClasses = DataManager.getSingleton().getCompAttr().getNbClasses();
        float[] targets = new float[this.nbObjects];
        float[][] points = null;
        float[][] data = new float[this.nbObjects][nbClasses];
        points = new float[this.nbObjects][this.nbTerms];
        int i = 0;
        while (i < this.src.getNbAttACP()) {
            int j = 0;
            while (j < this.src.getNbObjects()) {
                points[j][i] = this.src.getAttrValue(j, i);
                ++j;
            }
            ++i;
        }
        int cl = 0;
        while (cl < nbClasses) {
            i = 0;
            while (i < this.nbObjects) {
                targets[i] = DataManager.getSingleton().getCompAttr().getClassIndice(i) == cl ? 1.0f : -1.0f;
                ++i;
            }
            SVM svm = new SVM(targets, points);
            svm.setConstant(this.tpgSvm.getConstant());
            Kernel k = Common.getSingleton().getKernel();
            if (k != null) {
                svm.setKernel(k, null);
            }
            svm.computeSVM();
            svm.computeHx();
            int j = 0;
            while (j < points.length) {
                data[j][cl] = svm.getHxAt(j);
                ++j;
            }
            ++cl;
        }
        SourceAttrVal formerSrc = this.src;
        SourceAttrVal svmSrc = DataManager.getSingleton().createSourceAttrVal(data);
        svmSrc.setParent(formerSrc, true);
        PMPCA acp = PMFactory.getSingleton().createPMPCA(svmSrc, ConditioningFactory.createConditioning(2, true));
        acp.calculer();
        StandardProjection proj = ProjectionFactory.createStandardProjection(acp);
        System.out.println("1N");
        new DisplayJFXExplorer(proj).setVisible(true);
    }

    public int getnbPointsIntersection() {
        return this.nbPoints;
    }

    public void calculSVM() {
        this.nbObjects = this.src.getNbObjects();
        this.nbTerms = this.src.getNbAttACP();
        float[] moy = null;
        float[] targets = new float[this.nbObjects];
        float[][] points = null;
        int index1 = this.tpgSvm.getIndexSelectedClass1();
        int index2 = this.tpgSvm.getIndexSelectedClass2();
        int i = 0;
        while (i < this.nbObjects) {
            targets[i] = DataManager.getSingleton().getCompAttr().getClassIndice(i) == index1 ? 1.0f : (index2 != this.tpgSvm.restIndice() ? (DataManager.getSingleton().getCompAttr().getClassIndice(i) == index2 ? -1.0f : 0.0f) : -1.0f);
            ++i;
        }
        if (this.tpgSvmDM.getSVMComputeModeIndex() == 0) {
            points = new float[this.nbObjects][this.nbTerms];
            i = 0;
            while (i < this.src.getNbAttACP()) {
                int j = 0;
                while (j < this.src.getNbObjects()) {
                    points[j][i] = this.src.getAttrValue(j, i);
                    ++j;
                }
                ++i;
            }
        } else if (this.tpgSvmDM.getSVMComputeModeIndex() == 1 && this.currentPM != null) {
            points = (float[][])this.f3d.getProjection().getCoordinates().clone();
            moy = this.currentPM.getMoyennes();
        }
        SVM svm = new SVM(targets, points);
        svm.setConstant(this.tpgSvm.getConstant());
        System.out.println(" mettre \u00e0 jour le noyau 1 ");
        Kernel k = Common.getSingleton().getKernel();
        if (k != null) {
            svm.setKernel(k, moy);
        }
        svm.computeSVM();
        svm.computeHx();
        svm.displayAlpha();
        System.out.println("b : " + svm.getB());
        svm.displayW();
        System.out.println();
        svm.displayHx();
    }

    public void afficher() {
        if (DataManager.getSingleton().getParams().getClassCol() == -1) {
            JOptionPane.showMessageDialog(null, Messages.getString("warning_classattr"), Messages.getString("warning"), 2);
        } else if (this.tpgSvm.getIndexSelectedClass1() == this.tpgSvm.getIndexSelectedClass2()) {
            JOptionPane.showMessageDialog(null, Messages.getString("warning_eltidentique"), Messages.getString("warning"), 2);
        } else {
            int dm = this.tpgSvmDM.getDisplayModeIndex();
            if (dm == 0) {
                int cm = this.tpgSvmDM.getSVMComputeModeIndex();
                if (cm == 0) {
                    this.warningDisplayPlan();
                } else if (cm == 1) {
                    if (this.f3d != null) {
                        this.tracerPlan();
                        if (this.getnbPointsIntersection() == 0) {
                            this.warningPlanInexiste();
                        }
                    } else {
                        this.warningProjected();
                    }
                }
            } else if (dm == 1) {
                if (this.f3d != null) {
                    this.colorer();
                } else {
                    this.warningProjected();
                }
            } else if (dm == 2) {
                if (this.f3d != null) {
                    this.remplacer3emeAxe();
                } else {
                    this.warningProjected();
                }
            } else if (dm == 3) {
                if (this.f3d != null) {
                    this.redescription1N();
                } else {
                    this.warningProjected();
                }
            }
        }
    }

    private void warningPlanInexiste() {
        JOptionPane.showMessageDialog(null, Messages.getString("warming_plan-inexiste"), Messages.getString("warning"), 2);
    }

    private void warningProjected() {
        JOptionPane.showMessageDialog(null, Messages.getString("warming_projection"), Messages.getString("warning"), 2);
    }

    private void warningDisplayPlan() {
        JOptionPane.showMessageDialog(null, Messages.getString("warming_affiche_plan"), Messages.getString("warning"), 2);
    }

    public void applyKernel() {
    }

    @Override
    public void activeSrcChanged(Source src) {
        if (src.getType() == 0) {
            this.src = (SourceAttrVal)src;
        }
    }

    @Override
    public void activeViewChanged(GView gv) {
        super.activeViewChanged(gv);
        if (gv == null) {
            this.currentPM = null;
        } else if (gv.getProjectiveMethod() != this.currentPM) {
            this.currentPM = gv.getProjectiveMethod();
        }
    }
}

