/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.tools;

import Jama.EigenvalueDecomposition;
import explorer.compute.compute.projection.PMAttrVal;
import explorer.compute.compute.projection.ProjectionFactory;
import explorer.compute.compute.projection.ProjectiveMethod;
import explorer.compute.compute.projection.conditionning.Conditioning;
import explorer.compute.compute.projection.conditionning.ConditioningFactory;
import explorer.compute.tools.Tool;
import explorer.compute.tools.projectivemethods.ARDpPMTool;
import explorer.compute.tools.projectivemethods.KNNPCAPMTool;
import explorer.compute.tools.projectivemethods.LDAPMTool;
import explorer.compute.tools.projectivemethods.LLEPMTool;
import explorer.compute.tools.projectivemethods.PCAPMTool;
import explorer.data.Common;
import explorer.data.SourceAttrVal;
import explorer.data.SrcObserver;
import explorer.data.ViewManager;
import explorer.display3D.javafx.DisplayJFXExplorer;
import explorer.windows.w2D.icview.projectivemethods.BasicPMView;
import explorer.windows.w2D.icview.projectivemethods.ICVAttrValProj;
import explorer.windows.w2D.icview.projectivemethods.ICVConditionningView;
import explorer.windows.w2D.icview.projectivemethods.NumericalParameterPMView;
import explorer.windows.w2D.icview.projectivemethods.PCAPMView;
import explorer.windows.w2D.icview.projectivemethods.ProjectiveMethodView;
import java.awt.Window;
import javax.swing.SwingUtilities;
import lib3d4j.compute.compute.ComputeInfo;
import lib3d4j.data.Source;
import lib3d4j.international.Messages;

public class OutilsACP
extends Tool
implements SrcObserver {
    private String reduction = ConditioningFactory.STR_REDUCE;
    private boolean centered = true;
    private ComputeInfo info;
    private Common common;
    private SourceAttrVal currentSrc = null;
    private PMAttrVal projmeth = null;
    private PMAttrVal acpKernel = null;
    private boolean doubleVisuActive = false;
    private ICVAttrValProj pmview;
    private ProjectiveMethodView currentMethod = null;
    private ProjectiveMethodView defaultMethod = null;

    public Conditioning getCurrentConditionning() {
        return ConditioningFactory.createConditioning(this.reduction, this.centered);
    }

    public SourceAttrVal getCurrentSource() {
        return this.currentSrc;
    }

    public void compute() {
        if (this.currentSrc != null) {
            this.projmeth = (PMAttrVal)this.currentMethod.getControl().execute();
            this.projmeth.calculer();
            new DisplayJFXExplorer(ProjectionFactory.createStandardProjection(this.projmeth)).setVisible(true);
        }
    }

    public OutilsACP(Common parent, ComputeInfo info, SourceAttrVal src) {
        this.common = parent;
        this.info = info;
        this.name = "ACP";
        this.currentSrc = src;
        ViewManager.getSingleton().addSrcObserver(this);
    }

    public ProjectiveMethod getACP() {
        return this.projmeth;
    }

    public float getDunnIndice() {
        if (this.projmeth != null) {
            return this.projmeth.getDunnIndice();
        }
        return 0.0f;
    }

    public int[] getAxes() {
        return this.common.varRep_getAxes();
    }

    public float[][] getDataProjected() {
        return this.projmeth.getDataProjected3D();
    }

    public EigenvalueDecomposition getED() {
        return this.projmeth.getED();
    }

    public float[] getNormalizedValues(int i) {
        return this.projmeth.getNormalizedValues(i);
    }

    public boolean isnullAcp() {
        boolean isnull = false;
        if (this.projmeth == null) {
            isnull = true;
        }
        return isnull;
    }

    @Override
    public void activeSrcChanged(Source actsrc) {
        this.currentSrc = actsrc instanceof SourceAttrVal ? (SourceAttrVal)actsrc : null;
    }

    public void setCondView(ICVConditionningView v) {
        v.setMethods(ConditioningFactory.getCondMeths(), this.reduction);
        v.setCentered(this.centered);
    }

    public void setPMView(ICVAttrValProj v) {
        this.pmview = v;
        this.defaultMethod = this.currentMethod = new PCAPMView(Messages.getString("tpgacp_acp"), new PCAPMTool(this));
        this.pmview.addMethod(this.currentMethod);
        this.pmview.addMethod(new BasicPMView(Messages.getString("tpgacp_ald"), new LDAPMTool(this)));
        this.pmview.addMethod(new BasicPMView(Messages.getString("tpgacp_ard"), new ARDpPMTool(this)));
        this.pmview.addMethod(new NumericalParameterPMView(Messages.getString("tpgacp_arwd"), new ARDpPMTool(this)));
        this.pmview.addMethod(new NumericalParameterPMView(Messages.getString("tpgacp_knnacp"), new KNNPCAPMTool(this)));
        this.pmview.addMethod(new NumericalParameterPMView("LLE", new LLEPMTool(this)));
        this.currentMethod.setVisible(true);
    }

    public void reset() {
        this.pmview.setSelectedMethod(this.defaultMethod.getName());
    }

    public void methodChanged() {
        this.setCurrentMethod(this.pmview.getSelectedMethod());
    }

    private void setCurrentMethod(ProjectiveMethodView meth) {
        if (this.currentMethod != null) {
            this.currentMethod.setVisible(false);
        }
        this.currentMethod = meth;
        this.currentMethod.setVisible(true);
        Window w = SwingUtilities.windowForComponent(this.pmview);
        if (w != null) {
            w.pack();
        }
    }

    public void setReduction(String r) {
        this.reduction = r;
    }

    public void setCentered(boolean centered) {
        this.centered = centered;
    }
}

