/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.tools;

import explorer.compute.tools.GViewTool;
import explorer.compute.tools.OutilsCalculMalPlaces;
import explorer.data.Common;
import explorer.data.DataManager;
import explorer.display3D.DisplayExplorer;
import java.io.PrintStream;
import java.util.LinkedList;
import javafx.geometry.Point3D;
import lib3d4j.compute.tools.OutilsTableaux;
import lib3d4j.data.DescriptionData;

public class OutilsAffichageMalPlaces
extends GViewTool {
    private Common parent;
    int numeroSelectionne;
    boolean ellipsesAffichees = false;
    boolean afficher = false;
    LinkedList<float[]> pointsMalPlaces;
    float[] densiteParEllipse;
    float[] maximum;
    OutilsCalculMalPlaces ocmp;
    int nbVoisins = 1;
    DescriptionData dd = DataManager.getSingleton().getCompAttr();

    public OutilsAffichageMalPlaces(DisplayExplorer f, Common c) {
        this.f3d = f;
        this.name = "Mal Places";
        this.parent = c;
    }

    public void reinitialiser() {
        this.numeroSelectionne = -1;
        this.pointsMalPlaces = new LinkedList();
        this.ellipsesAffichees = false;
        this.afficher = false;
    }

    public void setAffichage(DisplayExplorer f) {
        this.f3d = f;
        this.reinitialiser();
    }

    public void afficherPointsMalPlaces(int choix, boolean afficherCoche, boolean afficherEllipses) {
        if (!afficherCoche) {
            if (this.afficher) {
                this.f3d.removeMisplaced();
            }
            if (afficherEllipses) {
                this.f3d.removeMisplacedEllipsoid();
            }
            this.afficher = false;
            this.ellipsesAffichees = false;
            return;
        }
        if (!afficherEllipses && this.ellipsesAffichees) {
            this.f3d.removeMisplacedEllipsoid();
            this.ellipsesAffichees = false;
        }
        if (!this.afficher) {
            float[][] lc = this.f3d.getPoints();
            int[] classe = this.dd.getClassIndices();
            this.ocmp = new OutilsCalculMalPlaces(lc, classe, this.nbVoisins);
            this.numeroSelectionne = 0;
            if (afficherCoche) {
                int arrivee;
                int depart;
                int i;
                this.pointsMalPlaces = new LinkedList();
                if (choix == 0) {
                    i = 0;
                    while (i < this.ocmp.nbPointsMalPlaces()) {
                        depart = this.ocmp.getNumeroPointMalPlace(i);
                        arrivee = this.ocmp.getNumeroPointDestinationMalPlace(i);
                        this.pointsMalPlaces.add(lc[depart]);
                        float[] resVect = new float[]{lc[arrivee][0] - lc[depart][0], lc[arrivee][1] - lc[depart][1], lc[arrivee][2] - lc[depart][2]};
                        Point3D[] plaPts = new Point3D[]{new Point3D((double)lc[depart][0], (double)lc[depart][1], (double)lc[depart][2]), new Point3D((double)lc[arrivee][0], (double)lc[arrivee][1], (double)lc[arrivee][2])};
                        this.f3d.drawLine(plaPts, depart, 0.6f);
                        this.f3d.addCone(lc[depart], resVect, depart, 0.6f);
                        ++i;
                    }
                }
                if (choix == 1) {
                    i = 0;
                    while (i < this.ocmp.nbPointsMalPlaces()) {
                        depart = this.ocmp.getNumeroPointMalPlace(i);
                        arrivee = this.ocmp.getNumeroPointDestinationMalPlace(i);
                        this.pointsMalPlaces.add(lc[depart]);
                        Point3D[] plaPts = new Point3D[]{new Point3D((double)lc[depart][0], (double)lc[depart][1], (double)lc[depart][2]), new Point3D((double)lc[arrivee][0], (double)lc[arrivee][1], (double)lc[arrivee][2])};
                        this.f3d.drawLine(plaPts, depart, 0.6f);
                        ++i;
                    }
                }
            }
            this.afficher = true;
        }
        if (afficherEllipses && !this.ellipsesAffichees) {
            this.afficherEllipses();
        }
    }

    public void afficherEllipses() {
        this.ellipsesAffichees = true;
        if (this.ocmp.kk == null) {
            return;
        }
        float[][][] pointsParClusters = new float[this.ocmp.nbGroupes()][][];
        int i = 0;
        while (i < this.ocmp.nbGroupes()) {
            pointsParClusters[i] = OutilsTableaux.subArray(this.f3d.getPoints(), this.ocmp.getNumeroPointsDuCluster(i));
            ++i;
        }
        int nbClusters = this.ocmp.nbGroupes();
        int i2 = 0;
        while (i2 < pointsParClusters.length) {
            this.f3d.drawMisplacedEllipsoid(pointsParClusters[i2]);
            ++i2;
        }
        this.numeroSelectionne = 0;
        this.densiteParEllipse = new float[nbClusters];
        this.maximum = new float[nbClusters];
        i2 = 0;
        while (i2 < nbClusters) {
            this.maximum[i2] = this.ocmp.getMaximumCluster(i2);
            this.densiteParEllipse[i2] = this.maximum[i2] / 10.0f;
            ++i2;
        }
        i2 = 0;
        while (i2 < pointsParClusters.length) {
            this.choisirEllipseSuivante();
            ++i2;
        }
    }

    public void recoloreMalPlaces() {
        if (this.ocmp != null) {
            int i = 0;
            while (i < this.ocmp.nbPointsMalPlaces()) {
                this.f3d.setMisplacedColor(i, this.f3d.getObjectColor(this.ocmp.getNumeroPointMalPlace(i)));
                ++i;
            }
        }
    }

    public void choisirEllipseSuivante() {
        if (this.ellipsesAffichees && this.afficher) {
            this.f3d.underlightMisplaceEllipsoid(this.numeroSelectionne);
            ++this.numeroSelectionne;
            this.numeroSelectionne %= this.ocmp.nbGroupes();
            this.f3d.highlightMisplaceEllipsoid(this.numeroSelectionne);
            this.parent.getMalPlaceTaskPanelGroup().setLabelDensite("Densite: " + this.densiteParEllipse[this.numeroSelectionne]);
            this.parent.getMalPlaceTaskPanelGroup().setMaximumSlider((int)this.maximum[this.numeroSelectionne]);
            this.parent.getMalPlaceTaskPanelGroup().setValueSlider((int)this.densiteParEllipse[this.numeroSelectionne]);
        }
    }

    public void choisirEllipsePrecedente() {
        if (this.ellipsesAffichees && this.afficher) {
            this.f3d.underlightMisplaceEllipsoid(this.numeroSelectionne);
            --this.numeroSelectionne;
            if (this.numeroSelectionne == -1) {
                this.numeroSelectionne = this.ocmp.nbGroupes() - 1;
            }
            this.f3d.highlightMisplaceEllipsoid(this.numeroSelectionne);
            this.parent.getMalPlaceTaskPanelGroup().setLabelDensite("Densite: " + this.densiteParEllipse[this.numeroSelectionne]);
            this.parent.getMalPlaceTaskPanelGroup().setMaximumSlider((int)this.maximum[this.numeroSelectionne]);
            this.parent.getMalPlaceTaskPanelGroup().setValueSlider((int)this.densiteParEllipse[this.numeroSelectionne]);
        }
    }

    public boolean isEllipsesTracees() {
        return this.ellipsesAffichees;
    }

    public boolean isPresMalPlace(float[] pt) {
        return this.ocmp.isPresCluster(pt, this.densiteParEllipse[this.numeroSelectionne], this.numeroSelectionne);
    }

    public boolean isMalClasse(int i) {
        return this.ocmp.isMalPlace(i);
    }

    public void setDensite(float densite) {
        if (this.densiteParEllipse == null) {
            return;
        }
        this.densiteParEllipse[this.numeroSelectionne] = densite;
        float[][] axesPrincipaux = this.ocmp.axesPrincipaux(this.numeroSelectionne);
        float longueur = this.ocmp.densiteToDistance(densite, axesPrincipaux[0], this.numeroSelectionne);
        float largeur = this.ocmp.densiteToDistance(densite, axesPrincipaux[1], this.numeroSelectionne);
        if (this.maximum[this.numeroSelectionne] > 0.0f) {
            this.f3d.resizeMisplacedEllipsoid(longueur, largeur, this.numeroSelectionne);
            this.parent.getMalPlaceTaskPanelGroup().setLabelDensite("Densite: " + this.densiteParEllipse[this.numeroSelectionne]);
        }
    }

    public int getNbMalClasses() {
        return this.ocmp.nbPointsMalPlaces();
    }

    public void confusionMatrix(PrintStream out) {
        int j;
        int nbc = this.dd.getNbClasses();
        int[][] cm = new int[nbc][nbc];
        int i = 0;
        while (i < nbc) {
            j = i + 1;
            while (j < nbc) {
                cm[i][j] = 0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.ocmp.nbPointsMalPlaces()) {
            int classearrivee;
            int depart = this.ocmp.getNumeroPointMalPlace(i);
            int arrivee = this.ocmp.getNumeroPointDestinationMalPlace(i);
            int classedepart = this.dd.getClassIndice(depart);
            if (classedepart < (classearrivee = this.dd.getClassIndice(arrivee))) {
                int[] nArray = cm[classedepart];
                int n = classearrivee;
                nArray[n] = nArray[n] + 1;
            } else {
                int[] nArray = cm[classearrivee];
                int n = classedepart;
                nArray[n] = nArray[n] + 1;
            }
            ++i;
        }
        i = 0;
        while (i < nbc) {
            j = 0;
            while (j <= i) {
                out.print("- ");
                ++j;
            }
            j = i + 1;
            while (j < nbc) {
                out.print(String.valueOf(cm[i][j]) + " ");
                ++j;
            }
            out.println();
            ++i;
        }
    }

    public int getNbVoisins() {
        return this.nbVoisins;
    }

    public void setNbVoisins(int nbVoisins) {
        this.nbVoisins = nbVoisins;
    }
}

