/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.tools;

import explorer.compute.tools.OutilsCrop;
import explorer.data.BoxParameters;
import explorer.windows.w2D.icview.ICVCropBox;
import java.util.List;

public class OutilsCropBox
extends OutilsCrop {
    private BoxParameters boxMgr;
    private ICVCropBox icview = null;
    float x;
    float y;
    float z;
    float mx;
    float my;
    float mz;

    public OutilsCropBox() {
        this.name = "Crop";
    }

    public void setICView(ICVCropBox t) {
        this.icview = t;
        this.boxMgr = this.icview;
    }

    public float[] getCoord(boolean bouge) {
        this.icview.setSlidersChangeListener(false);
        if (this.f3d.countSelected() > 0 && !bouge) {
            float a = this.f3d.getMinSelected(0);
            float b = this.f3d.getMinSelected(1);
            float c = this.f3d.getMinSelected(2);
            float d = this.f3d.getMaxSelected(0);
            float e = this.f3d.getMaxSelected(1);
            float f = this.f3d.getMaxSelected(2);
            this.x = (a + d) / 2.0f;
            this.y = (b + e) / 2.0f;
            this.z = (c + f) / 2.0f;
            this.mx = 0.05f + (d - a) / 2.0f;
            this.my = 0.05f + (e - b) / 2.0f;
            this.mz = 0.05f + (f - c) / 2.0f;
            if (this.mx == 0.05f) {
                this.mx = 0.1f;
            }
            if (this.my == 0.05f) {
                this.my = 0.1f;
            }
            if (this.mz == 0.05f) {
                this.mz = 0.1f;
            }
            this.boxMgr.setCX((int)((this.x + 0.5f) * 100.0f));
            this.boxMgr.setCY((int)((this.y + 0.5f) * 100.0f));
            this.boxMgr.setCZ((int)((this.z + 0.5f) * 100.0f));
            this.boxMgr.setLX((int)(this.mx * 50.0f));
            this.boxMgr.setLY((int)(this.my * 50.0f));
            this.boxMgr.setLZ((int)(this.mz * 50.0f));
        } else {
            this.x = ((float)this.boxMgr.getCX() - 50.0f) / 100.0f;
            this.y = ((float)this.boxMgr.getCY() - 50.0f) / 100.0f;
            this.z = ((float)this.boxMgr.getCZ() - 50.0f) / 100.0f;
            this.mx = (float)this.boxMgr.getLX() / 50.0f;
            this.my = (float)this.boxMgr.getLY() / 50.0f;
            this.mz = (float)this.boxMgr.getLZ() / 50.0f;
        }
        this.icview.setSlidersChangeListener(true);
        float[] coord = new float[]{this.x, this.y, this.z, this.mx, this.my, this.mz};
        return coord;
    }

    @Override
    public boolean isCropVisible() {
        return this.f3d.isCropDisplayed();
    }

    @Override
    public List<Integer> inCropIndices() {
        return this.f3d.inCropIndices();
    }

    @Override
    public boolean isInCrop(int i) {
        return this.f3d.isInCrop(i, this.x, this.y, this.z, this.mx, this.my, this.mz);
    }

    @Override
    public void creerCrop() {
        this.icview.resetSliders();
        if (this.f3d != null) {
            this.getCoord(false);
            this.f3d.createCropCube(this.x, this.y, this.z, this.mx, this.my, this.mz);
        }
    }

    @Override
    public void effacerCrop() {
        if (this.f3d != null && this.isCropVisible()) {
            this.f3d.removeCubeCrop();
        }
    }

    @Override
    public void moveCrop() {
        this.x = ((float)this.boxMgr.getCX() - 50.0f) / 100.0f;
        this.y = ((float)this.boxMgr.getCY() - 50.0f) / 100.0f;
        this.z = ((float)this.boxMgr.getCZ() - 50.0f) / 100.0f;
        if (this.f3d != null) {
            this.f3d.moveCropCube(this.x, this.y, this.z);
        }
    }

    @Override
    public void resizeCrop() {
        this.mx = (float)this.boxMgr.getLX() / 50.0f;
        this.my = (float)this.boxMgr.getLY() / 50.0f;
        this.mz = (float)this.boxMgr.getLZ() / 50.0f;
        if (this.f3d != null) {
            this.f3d.resizeCropCube(this.mx, this.my, this.mz);
        }
    }
}

