/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.tools;

import explorer.compute.tools.OutilsCrop;
import explorer.data.SphereParameters;
import java.util.List;

public class OutilsCropSphere
extends OutilsCrop {
    private float x;
    private float y;
    private float z;
    private float r;
    private SphereParameters sphereMgr = null;

    public OutilsCropSphere() {
        this.name = "Crop";
    }

    public void setSphereMgr(SphereParameters mgr) {
        this.sphereMgr = mgr;
        this.resizeCrop();
    }

    public SphereParameters getSphereMgr() {
        return this.sphereMgr;
    }

    public void setCenter(float[] center) {
        this.x = center[0];
        this.y = center[1];
        this.z = center[2];
    }

    @Override
    public boolean isCropVisible() {
        return this.f3d.isCropSphereAffiche();
    }

    @Override
    public List<Integer> inCropIndices() {
        return this.f3d.inCropIndices();
    }

    @Override
    public boolean isInCrop(int i) {
        return this.f3d.isInCrop(i, this.x, this.y, this.z, this.r);
    }

    @Override
    public void creerCrop() {
        this.f3d.createCropCube(this.x, this.y, this.z, this.r, this.r, this.r);
    }

    @Override
    public void effacerCrop() {
        if (this.isCropVisible()) {
            this.f3d.removeCubeCrop();
        }
    }

    @Override
    public void moveCrop() {
        if (this.f3d != null) {
            this.f3d.moveCropCube(this.x, this.y, this.z);
        }
    }

    @Override
    public void resizeCrop() {
        if (this.f3d != null) {
            this.r = (float)this.sphereMgr.getRadius() / 100.0f;
            this.f3d.resizeCropSphere(this.r);
        }
    }
}

