/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.tools;

import explorer.compute.compute.constraints.C2Constraint;
import explorer.compute.compute.constraints.C3Constraint;
import explorer.compute.compute.constraints.CNConstraint;
import explorer.compute.compute.constraints.Constraint;
import explorer.compute.compute.constraints.Constraints;
import explorer.compute.compute.projection.PMPCA;
import explorer.compute.compute.projection.Projection;
import explorer.compute.compute.projection.ProjectionFactory;
import explorer.compute.tools.GViewTool;
import explorer.display3D.DisplayExplorer;
import explorer.windows.w2D.icview.constrained.ICVAnomaly;
import explorer.windows.w2D.icview.constrained.ICVComparison;
import explorer.windows.w2D.icview.constrained.ICVConstrainedProjectionMenu;
import explorer.windows.w2D.icview.constrained.ICVMove;
import explorer.windows.w2D.utils.GView;
import explorer.windows.w2D.utils.SubsetExplorer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import lib3d4j.compute.tools.OutilsAlgebre;
import lib3d4j.international.Messages;

public class PCTool
extends GViewTool
implements Observer {
    private PMPCA currentPM = null;
    private Projection currentProj = null;
    private Map<DisplayExplorer, Structures> map = new HashMap<DisplayExplorer, Structures>();
    private Constraints currentConst = null;
    private Map<Constraint, int[]> currentVisuals = null;
    private ICVAnomaly ano = null;
    private ICVMove mov = null;
    private ICVComparison comp = null;
    private ICVConstrainedProjectionMenu mi = null;
    private SubsetExplorer subsetEx = null;
    int[] nbgObj = null;
    float[] nbgCenter = null;
    int[] targets = new int[]{-1, -1, -1};

    public void updateLists() {
        this.ano.maj();
        this.comp.maj();
        this.mov.maj();
    }

    @Override
    public void activeViewChanged(GView gv) {
        super.activeViewChanged(gv);
        if (this.f3d != null) {
            this.f3d.addObserver(this);
        }
        this.setCurrentStructures();
    }

    @Override
    public void update(Observable o, Object arg) {
        int index = (Integer)arg;
        SwingUtilities.invokeLater(() -> {
            this.comp.clickedObject(index);
            this.ano.clickedObject(index);
            this.mov.clickedObject(index);
        });
    }

    private void modificationProjection() {
        this.map.remove(this.currentProj);
        this.currentPM.modificationProjection(this.currentConst);
        this.f3d.updateProjection(ProjectionFactory.createStandardProjection(this.currentPM));
        this.redrawVisuals();
    }

    public void setMI(ICVConstrainedProjectionMenu tpg) {
        this.mi = tpg;
    }

    public void setDep(ICVMove tpg) {
        this.mov = tpg;
    }

    public void setAno(ICVAnomaly tpg) {
        this.ano = tpg;
        this.ano.maj();
    }

    public void setComp(ICVComparison tpg) {
        this.comp = tpg;
        this.comp.maj();
    }

    public void setSubsetEx(SubsetExplorer se) {
        this.subsetEx = se;
    }

    public void compute() {
        this.removeTargets();
        this.currentConst.incrNbEtapesInteractions();
        this.modificationProjection();
    }

    public void load() {
        this.clean();
        File file = null;
        JFileChooser chooser = new JFileChooser();
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            file = chooser.getSelectedFile();
            System.out.println("Chargement du fichier : " + file.getName());
            this.currentConst = new Constraints(file, this.currentProj);
            this.map.put(this.f3d, new Structures(this.currentConst));
            this.ano.addAnomalies(this.currentConst.getAnomalies());
            this.comp.addComparisons(this.currentConst.getComparisons());
            this.mov.addMoves(this.currentConst.getMoves());
            this.mi.addConstraints(this.currentConst.getAllInteractions());
        }
        this.modificationProjection();
    }

    public void save() {
        File file = null;
        JFileChooser chooser = new JFileChooser();
        int returnVal = chooser.showSaveDialog(null);
        if (returnVal == 0) {
            file = chooser.getSelectedFile();
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.append(this.currentConst.toString());
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            System.out.println("fenetre?");
        }
    }

    public void buildAnomaly() {
        int a = this.ano.getA();
        int b = this.ano.getB();
        int c = this.ano.getC();
        this.updateTargets(new int[]{a, b, c});
        if (a == -1 || b == -1 || c == -1 || a == b || a == c || b == c) {
            return;
        }
        float dab = this.f3d.getProjection().getDistance(a, b);
        float dac = this.f3d.getProjection().getDistance(a, c);
        this.ano.setDistances(dab, dac);
    }

    public void addAnomaly() {
        int a = this.ano.getA();
        int b = this.ano.getB();
        int c = this.ano.getC();
        String rate = this.ano.getRate();
        C3Constraint strano = this.currentConst.addAnomaly(a, b, c, rate);
        this.drawAnomaly(strano);
        this.mi.addConstraint(strano);
    }

    private void drawAnomaly(C3Constraint ano) {
        int a = ano.getA();
        int b = ano.getB();
        int c = ano.getC();
        float[][] projcoord = this.currentProj.getCoordinates();
        int[] liste = new int[4];
        liste[0] = this.f3d.addLine(projcoord[a], projcoord[b]);
        liste[1] = this.f3d.addLine(projcoord[a], projcoord[c]);
        liste[2] = this.f3d.addLine(projcoord[c], projcoord[b]);
        float[] centre = new float[]{(projcoord[a][0] + projcoord[b][0] + projcoord[c][0]) / 3.0f, (projcoord[a][1] + projcoord[b][1] + projcoord[c][1]) / 3.0f, (projcoord[a][2] + projcoord[b][2] + projcoord[c][2]) / 3.0f};
        liste[3] = this.f3d.addText(centre, "A" + ano.getId());
        this.currentVisuals.put(ano, liste);
    }

    public void buildComparison() {
        int a = this.comp.getA();
        int b = this.comp.getB();
        System.out.println("comp " + a + " " + b);
        this.updateTargets(new int[]{a, b, -1});
        if (a == -1 || b == -1 || a == b) {
            return;
        }
        System.out.println("update done");
        float dav = this.currentPM.getDistance(a, b);
        float dap = this.currentProj.getDistance(a, b);
        System.out.println(String.valueOf(dav) + " " + dap);
        this.comp.setDistances(dav, dap);
    }

    public void addComparison() {
        int a = this.comp.getA();
        int b = this.comp.getB();
        String rate = this.comp.getRate();
        Constraint strcomp = this.currentConst.addComparison(a, b, rate);
        this.drawComparison((C2Constraint)strcomp);
        this.mi.addConstraint(strcomp);
    }

    private void drawComparison(C2Constraint comp) {
        int a = comp.getA();
        int b = comp.getB();
        float[][] projcoord = this.currentProj.getCoordinates();
        int[] liste = new int[2];
        liste[0] = this.f3d.addLine(projcoord[a], projcoord[b]);
        float[] centre = new float[]{(projcoord[a][0] + projcoord[b][0]) / 2.0f, (projcoord[a][1] + projcoord[b][1]) / 2.0f, (projcoord[a][2] + projcoord[b][2]) / 2.0f};
        liste[1] = this.f3d.addText(centre, "C" + comp.getId());
        this.currentVisuals.put(comp, liste);
    }

    public void buildNbgMove() {
        Vector<Integer> nbglst;
        int a = this.mov.getA();
        this.updateTargets(new int[]{a, -1, -1});
        if (this.nbgObj != null) {
            int[] nArray = this.nbgObj;
            int n = this.nbgObj.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                this.f3d.removeObject(i);
                ++n2;
            }
            this.nbgObj = null;
        }
        if ((nbglst = this.mov.getDestNbg()).size() > 0) {
            this.nbgObj = this.computeNbg(a, nbglst);
        }
    }

    public void addNbgMove() {
        if (this.nbgObj == null) {
            System.out.println("no dest neighbors defined");
            return;
        }
        int a = this.mov.getA();
        Vector<Integer> nbglst = this.mov.getDestNbg();
        Constraint strmov = this.currentConst.addMove(a, nbglst);
        this.drawNbgMove((CNConstraint)strmov);
        this.mi.addConstraint(strmov);
    }

    private void drawNbgMove(CNConstraint mov) {
        int a = mov.getA();
        List<Integer> nbglst = mov.getTargetNbg();
        int[] liste = new int[3];
        if (this.nbgObj == null) {
            this.nbgObj = this.computeNbg(a, nbglst);
        }
        liste[0] = this.nbgObj[0];
        liste[1] = this.nbgObj[1];
        this.nbgObj = null;
        liste[2] = this.f3d.addText(this.nbgCenter, "M" + mov.getId());
        this.currentVisuals.put(mov, liste);
    }

    private int[] computeNbg(int rankA, List<Integer> nbglst) {
        float[][] projcoord = this.currentProj.getCoordinates();
        float radius = 0.0f;
        this.nbgCenter = new float[3];
        int nbnbg = nbglst.size();
        float[][] nbgcoords = new float[nbnbg][3];
        int cpt = 0;
        for (Integer nbg : nbglst) {
            this.nbgCenter[0] = this.nbgCenter[0] + projcoord[nbg][0];
            this.nbgCenter[1] = this.nbgCenter[1] + projcoord[nbg][1];
            this.nbgCenter[2] = this.nbgCenter[2] + projcoord[nbg][2];
            nbgcoords[cpt][0] = projcoord[nbg][0];
            nbgcoords[cpt][1] = projcoord[nbg][1];
            nbgcoords[cpt][2] = projcoord[nbg][2];
            ++cpt;
        }
        this.nbgCenter[0] = this.nbgCenter[0] / (float)nbnbg;
        this.nbgCenter[1] = this.nbgCenter[1] / (float)nbnbg;
        this.nbgCenter[2] = this.nbgCenter[2] / (float)nbnbg;
        float dist = 0.0f;
        int i = 0;
        while (i < nbnbg) {
            dist = OutilsAlgebre.distance(nbgcoords[i], this.nbgCenter);
            if (radius < dist) {
                radius = dist;
            }
            ++i;
        }
        int[] liste = new int[]{this.f3d.addSphere(this.nbgCenter, radius), this.f3d.addLine(this.nbgCenter, projcoord[rankA])};
        return liste;
    }

    public String[] addSEConstraint(int numimg, int numnbg, ArrayList<Integer> nbgOfImg, boolean isRight) {
        int nnb;
        if (nbgOfImg == null) {
            return new String[]{"?", "?"};
        }
        String sign = isRight ? " > 1.0" : " < 1.0";
        C3Constraint existingConstraint = this.currentConst.searchAnomaly(numimg, numnbg);
        int cnb = existingConstraint != null ? existingConstraint.getC() : numnbg;
        int rankcnb = nbgOfImg.indexOf(cnb);
        if (isRight) {
            if (rankcnb == nbgOfImg.size() - 1) {
                if (cnb == numnbg) {
                    return new String[]{"", ""};
                }
                return new String[]{"", "" + cnb};
            }
            nnb = nbgOfImg.get(rankcnb + 1);
        } else {
            if (rankcnb == 0) {
                if (cnb == numnbg) {
                    return new String[]{"", ""};
                }
                return new String[]{"" + cnb, ""};
            }
            nnb = nbgOfImg.get(rankcnb - 1);
        }
        if (nnb == numnbg) {
            this.removeConstraint(existingConstraint);
            return new String[]{"", ""};
        }
        boolean already = existingConstraint != null;
        existingConstraint = this.currentConst.addAnomaly(numimg, numnbg, nnb, sign);
        if (already) {
            this.mi.redrawConstraints();
        } else {
            this.mi.addConstraint(existingConstraint);
        }
        if (nbgOfImg.indexOf(nnb) > nbgOfImg.indexOf(numnbg)) {
            return new String[]{"", "" + nnb};
        }
        return new String[]{"" + nnb, ""};
    }

    public void clean() {
        try {
            this.currentConst.removeAllListeInteraction();
            this.removeTargets();
            this.removeVisuals();
            this.mi.removeAllConstraints();
            System.out.println("reinit");
            this.currentPM.reinit();
            this.f3d.updateProjection(ProjectionFactory.createStandardProjection(this.currentPM));
        }
        catch (NullPointerException e) {
            JOptionPane.showMessageDialog(null, Messages.getString("errorwindows"), "Attention", 2);
        }
    }

    public void removeConstraint(Constraint c) {
        this.currentConst.remove(c);
        this.removeVisuals(c);
        this.mi.removeConstraint(c);
    }

    private void updateTargets(int[] indices) {
        float[][] projcoord = this.currentProj.getCoordinates();
        int i = 0;
        while (i < 3) {
            if (this.targets[i] != -1) {
                this.f3d.removeObject(this.targets[i]);
            }
            if (indices[i] != -1) {
                this.targets[i] = this.f3d.setTarget(projcoord[indices[i]], DisplayExplorer.TARGET_COLORS[i]);
            }
            ++i;
        }
    }

    private void removeTargets() {
        int i = 0;
        while (i < 3) {
            if (this.targets[i] != -1) {
                this.f3d.removeObject(this.targets[i]);
            }
            ++i;
        }
    }

    private void redrawVisuals() {
        this.removeVisuals();
        for (Constraint c : this.currentConst.getAllInteractions()) {
            if (c instanceof C2Constraint) {
                this.drawComparison((C2Constraint)c);
                continue;
            }
            if (c instanceof C3Constraint) {
                this.drawAnomaly((C3Constraint)c);
                continue;
            }
            if (!(c instanceof CNConstraint)) continue;
            this.drawNbgMove((CNConstraint)c);
        }
    }

    private void removeVisuals() {
        Iterator<int[]> iterator = this.currentVisuals.values().iterator();
        while (iterator.hasNext()) {
            int[] elems;
            int[] nArray = elems = iterator.next();
            int n = elems.length;
            int n2 = 0;
            while (n2 < n) {
                int elem = nArray[n2];
                this.f3d.removeObject(elem);
                ++n2;
            }
        }
        this.currentVisuals.clear();
        if (this.nbgObj != null) {
            int[] nArray = this.nbgObj;
            int n = this.nbgObj.length;
            int n3 = 0;
            while (n3 < n) {
                int i = nArray[n3];
                this.f3d.removeObject(i);
                ++n3;
            }
            this.nbgObj = null;
        }
    }

    private void removeVisuals(Constraint c) {
        int[] elems;
        int[] nArray = elems = this.currentVisuals.get(c);
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            int elem = nArray[n2];
            this.f3d.removeObject(elem);
            ++n2;
        }
        this.currentVisuals.remove(c);
    }

    private void setCurrentStructures() {
        if (this.f3d == null || !(this.f3d.getProjection().getProjectiveMethod() instanceof PMPCA)) {
            this.currentProj = null;
            this.currentPM = null;
            this.currentConst = null;
            this.currentVisuals = null;
        } else {
            this.currentProj = this.f3d.getProjection();
            this.currentPM = (PMPCA)this.currentProj.getProjectiveMethod();
            Structures st = this.map.get(this.f3d);
            if (st == null) {
                this.currentConst = new Constraints(this.currentProj);
                this.currentVisuals = new HashMap<Constraint, int[]>();
                this.map.put(this.f3d, new Structures(this.currentConst, this.currentVisuals));
            } else {
                this.currentConst = st.constraints;
                this.currentVisuals = st.visuals;
            }
        }
    }

    private class Structures {
        public Constraints constraints;
        public Map<Constraint, int[]> visuals;

        public Structures(Constraints c, Map<Constraint, int[]> v) {
            this.constraints = c;
            this.visuals = v;
        }

        public Structures(Constraints c) {
            this(c, null);
        }
    }
}

