/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.tools;

import explorer.compute.tools.GViewTool;
import explorer.data.DataManager;
import explorer.data.DatasetParamsExplorer;
import explorer.display3D.DisplayParametersObserver;
import explorer.windows.w2D.icview.ICVVisualAttributes;
import lib3d4j.compute.compute.ComputeInfo;
import lib3d4j.data.DescriptionData;
import lib3d4j.display3D.javafx.objects.RichPrimitiveFactoryJFX;
import lib3d4j.international.Messages;

public class VisualAttributesTool
extends GViewTool {
    private ICVVisualAttributes view = null;
    private DatasetParamsExplorer params = null;
    private DescriptionData dd = null;
    private ComputeInfo info = null;

    public VisualAttributesTool(ComputeInfo ci) {
        this.info = ci;
        this.params = DataManager.getSingleton().getParams();
        this.dd = DataManager.getSingleton().getCompAttr();
    }

    public void setICView(ICVVisualAttributes va) {
        this.view = va;
    }

    public void assocDataChanged() {
        if (this.view.isViewSpecAssodDataSelected()) {
            this.f3d.setSpecificPictureAttribute(this.view.getAssocDataColumn());
        } else {
            if (this.f3d != null) {
                this.f3d.setSpecificPictureAttribute(-1);
            }
            this.params.setAssocDataCol(this.view.getAssocDataColumn());
        }
    }

    public void colorChanged() {
        if (this.dd.getNbAtt() == 0) {
            this.info.taskSetText(Messages.getString("tpgva_noparam"));
            return;
        }
        int colorcol = this.view.getColorColumn();
        if (colorcol != -1 && this.dd.isSymbolicAttribute(colorcol) && this.dd.getNbDistinctVal(colorcol) > 200) {
            this.info.taskSetText(String.valueOf(Messages.getString("tpgva_toomanycol")) + " (>" + 200 + ")");
            return;
        }
        this.params.setColorCol(colorcol);
    }

    public void textureChanged() {
        DisplayParametersObserver.getSingleton().setTexture(this.view.isTextureSelected());
    }

    public void classChanged() {
        int classcol = this.view.getClassColumn();
        if (classcol == this.view.getClassColumnSize() && !this.params.isMultiClassActive()) {
            this.params.setClassCol(-1);
            this.view.setMulticlassVisible(true);
            this.params.activateMultiClass(true);
        } else {
            if (this.params.isMultiClassActive()) {
                this.params.setMulticlass(null);
                this.params.activateMultiClass(false);
                this.view.setMulticlassVisible(false);
            }
            this.params.setClassCol(classcol);
            this.params.setColorCol(classcol);
            if (classcol != -1) {
                DataManager.getSingleton().getCompAttr().afficheClasseDistrib();
            }
        }
    }

    public void formChanged() {
        if (this.dd.getNbAtt() == 0) {
            this.info.taskSetText(Messages.getString("tpgva_noparam"));
            return;
        }
        int shapecol = this.view.getFormColumn();
        if (shapecol != -1 && this.dd.getNbDistinctVal(shapecol) > 4) {
            this.info.taskSetText(String.valueOf(Messages.getString("tpgva_toomanycol")) + " (>" + 4 + ")");
            return;
        }
        this.params.setFormCol(this.view.getFormColumn());
    }

    public void labelChanged() {
        this.params.setLabelCol(this.view.getLabelColumn());
    }

    public void multiClassChanged() {
        int[] indices = this.view.getMulticlassColumns();
        this.params.setMulticlass(indices);
        RichPrimitiveFactoryJFX.getFactory().setAppearances(indices.length);
    }
}

