/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.tools.classification;

import explorer.compute.compute.ArbreRecMin.ArbreRecMin;
import explorer.compute.compute.ArbreRecMin.SautMinimal;
import explorer.compute.tools.classification.ClassifTool;
import explorer.data.DataManager;
import explorer.display3D.DisplayExplorer;
import explorer.windows.w2D.icview.classification.ClassificationView;
import explorer.windows.w2D.icview.classification.HierarchicalSLView;
import java.util.List;
import lib3d4j.data.DescriptionData;

public class HierarchicalSLClassificationTool
extends ClassifTool {
    public static int DEF_NB_CLASS = 5;
    private SautMinimal sm;
    private ArbreRecMin tree;
    private HierarchicalSLView view;
    private DescriptionData dd = DataManager.getSingleton().getCompAttr();
    private DisplayExplorer clusteringView = null;

    @Override
    public void activate(boolean b) {
        if (b) {
            this.display();
        } else {
            this.delete();
        }
    }

    @Override
    public void setView(ClassificationView view) {
        if (view instanceof HierarchicalSLView) {
            this.view = (HierarchicalSLView)view;
            ((HierarchicalSLView)view).setNbClasses(DEF_NB_CLASS);
        }
    }

    public void viewclicked() {
        if (this.tree != null) {
            this.delete();
        }
        this.display();
    }

    private void delete() {
        this.dd.dropColumn("AUTO_HIERARCH");
        this.sm = null;
        this.tree.effacer(this.clusteringView);
        this.tree = null;
    }

    private void display() {
        int nbc = this.view.getNbClasses();
        if (nbc != -1) {
            this.clusteringView = this.f3d;
            this.tree = new ArbreRecMin(this.f3d.getProjection().getCoordinates());
            this.tree.afficher(this.f3d);
            this.sm = new SautMinimal(this.tree, this.view.getNbClasses());
            this.sm.doCluster();
            int[] res = this.sm.getClasses();
            float[] fres = this.completeClassif(res, nbc);
            List<Object> classes = this.listClasses(nbc, res.length);
            this.dd.dropColumn("AUTO_HIERARCH");
            this.dd.addColumn(fres, classes, "AUTO_HIERARCH");
            DataManager.getSingleton().setClassAttribute("AUTO_HIERARCH");
            DataManager.getSingleton().setColorAttribute("AUTO_HIERARCH");
        }
    }
}

