/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.tools.classification;

import explorer.compute.classification.OctreeProb;
import explorer.compute.tools.classification.ClassifTool;
import explorer.data.DataManager;
import explorer.windows.w2D.icview.classification.ClassificationView;
import explorer.windows.w2D.icview.classification.CubesView;
import explorer.windows.w2D.icview.classification.DBScanView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import lib3d4j.data.DescriptionData;

public class OutilsClassifCube
extends ClassifTool {
    private CubesView view = null;
    private OctreeProb oct = null;
    private DescriptionData dd = DataManager.getSingleton().getCompAttr();

    public OutilsClassifCube() {
        this.name = "Outils Classe";
    }

    @Override
    public void setView(ClassificationView view) {
        if (view instanceof DBScanView) {
            this.view = (CubesView)view;
        }
    }

    @Override
    public void activate(boolean aFlag) {
        if (aFlag) {
            this.afficherCubes(false);
        } else {
            this.effacerCubes();
        }
    }

    public void itererCubes(int radius, float threshold) {
        this.effacerCubes();
        int nbm = this.oct.setProb(radius, threshold);
        System.out.println("nombre de cubes modifies : " + nbm);
        List<float[]> lesCubes = this.oct.getCubesByCenter();
        for (float[] cube : lesCubes) {
            this.f3d.addBox(cube[0], cube[1], cube[2], cube[3], cube[4], cube[5]);
        }
    }

    private void afficherCube(List<float[]> plus, List<float[]> minus) {
        this.oct = new OctreeProb(plus, minus);
        this.oct.generateClusters();
        List<float[]> lesCubes = this.oct.getCubesByCenter();
        List<Integer> lesCouleurs = this.oct.getCubesByColor();
        int maxcol = 0;
        for (int i : lesCouleurs) {
            if (maxcol >= i) continue;
            maxcol = i;
        }
        this.f3d.setCubeColors(++maxcol);
        Iterator<Integer> colorIt = lesCouleurs.iterator();
        for (float[] cube : lesCubes) {
            this.f3d.addBox(cube[0], cube[1], cube[2], cube[3], cube[4], cube[5], colorIt.next(), false);
        }
    }

    public void afficherCubes(boolean fromPPV) {
        if (this.f3d == null) {
            return;
        }
        if (!fromPPV && this.dd.getNbClasses() != 2) {
            return;
        }
        float[][] allPoints = this.f3d.getPoints();
        ArrayList<float[]> plus = new ArrayList<float[]>();
        ArrayList<float[]> minus = new ArrayList<float[]>();
        if (!fromPPV) {
            int[] sign = this.dd.getClassIndices();
            int i = 0;
            while (i < sign.length) {
                if (sign[i] == 0) {
                    plus.add(allPoints[i]);
                } else {
                    minus.add(allPoints[i]);
                }
                ++i;
            }
        }
        this.afficherCube(plus, minus);
    }

    public void effacerCubes() {
        this.f3d.removeCubes();
    }
}

