/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.tools.classification;

import explorer.compute.classification.dbscan.DBSCAN;
import explorer.compute.tools.classification.ClassifTool;
import explorer.data.DataManager;
import explorer.windows.w2D.icview.classification.ClassificationView;
import explorer.windows.w2D.icview.classification.DBScanView;
import java.util.List;
import lib3d4j.data.DescriptionData;

public class OutilsClassifDBScan
extends ClassifTool {
    private static int DEF_MIN_PTS = 4;
    private static float DEF_RAYON = 0.12f;
    private DBScanView view = null;
    DBSCAN dbscan = null;
    int minPts = DEF_MIN_PTS;
    float rayon = DEF_RAYON;
    private float[] center;
    DescriptionData dd = DataManager.getSingleton().getCompAttr();

    public OutilsClassifDBScan() {
        this.name = "Outils Classe";
    }

    @Override
    public void setView(ClassificationView view) {
        if (view instanceof DBScanView) {
            this.view = (DBScanView)view;
            this.view.setRadius(this.rayon);
            this.view.setMinPts(this.minPts);
        }
    }

    public void afficherDBScan() {
        this.afficherDBScan(this.minPts, this.rayon);
    }

    public void afficherDBScan(int nbc, float nbr) {
        this.minPts = nbc;
        this.rayon = nbr;
        float[][] coord = this.f3d.getPoints();
        this.dbscan = new DBSCAN(coord, this.rayon, this.minPts);
        this.dbscan.repartition();
        int[] res = this.dbscan.getClasses();
        System.out.println(this.dbscan.getNbClasses());
        float[] fres = this.completeClassif(res, this.dbscan.getNbClasses());
        List<Object> classes = this.listClasses(this.dbscan.getNbClasses(), res.length);
        this.dd.dropColumn("AUTO_DBSCAN");
        this.f3d.effacerDBScanSphere();
        this.dd.addColumn(fres, classes, "AUTO_DBSCAN");
        this.creerSphere(this.rayon);
        DataManager.getSingleton().setClassAttribute("AUTO_DBSCAN");
        DataManager.getSingleton().setColorAttribute("AUTO_DBSCAN");
    }

    public void effacerDBScan() {
        this.dd.dropColumn("AUTO_DBSCAN");
        this.f3d.effacerDBScanSphere();
    }

    public void creerSphere(float r) {
        this.f3d.creerDbscanSphere(r);
    }

    public void setCenter(float[] c) {
        this.center = c;
    }

    public void resizeSphere(float newScale) {
        if (this.f3d != null) {
            this.rayon = newScale;
            this.f3d.resizeDBScanSphere(this.rayon);
        }
    }

    @Override
    public void activate(boolean aFlag) {
        if (aFlag) {
            this.afficherDBScan();
        } else {
            this.effacerDBScan();
        }
    }
}

