/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.tools.kernels;

import explorer.compute.kernels.ISOMAP;
import explorer.compute.kernels.Kernel;
import explorer.compute.tools.GViewTool;
import explorer.compute.tools.kernels.KernelTool;
import explorer.data.Common;
import explorer.windows.w2D.icview.kernels.IsomapKernelView;
import explorer.windows.w2D.icview.kernels.KernelView;
import explorer.windows.w2D.utils.GView;

public class IsomapKernelTool
extends GViewTool
implements KernelTool {
    IsomapKernelView view;

    @Override
    public void setView(KernelView v) {
        this.view = (IsomapKernelView)v;
        this.setMaxNbg();
    }

    @Override
    public void execute() {
        int nbnbg = this.view.getNbNbg();
        ISOMAP iso = new ISOMAP(nbnbg);
        this.f3d.drawTree(iso.getProjections());
    }

    @Override
    public void activeViewChanged(GView gv) {
        super.activeViewChanged(gv);
        this.setMaxNbg();
    }

    @Override
    public void activate(boolean b) {
        if (b) {
            Common.getSingleton().setKernel(new ISOMAP(this.view.getNbNbg()));
        }
    }

    private void setMaxNbg() {
        if (this.f3d != null) {
            this.view.setMaxNbg(this.f3d.getProjection().getProjectiveMethod().getNbObjets() - 1);
        }
    }

    @Override
    public void paramChanged() {
        Kernel k = Common.getSingleton().getKernel();
        if (k instanceof ISOMAP) {
            ((ISOMAP)k).setNbVoisin(this.view.getNbNbg());
        }
    }
}

