/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.voronoi;

import explorer.compute.voronoi.Simplex;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Triangulation {
    private HashMap<Simplex, Set<Simplex>> neighbors = new HashMap();

    public Triangulation(Simplex simplex) {
        this.neighbors.put(simplex, new HashSet());
    }

    public String toString() {
        return "Triangulation (with " + this.neighbors.size() + " elements)";
    }

    public int size() {
        return this.neighbors.size();
    }

    public boolean contains(Simplex simplex) {
        return this.neighbors.containsKey(simplex);
    }

    public Iterator<Simplex> iterator() {
        return Collections.unmodifiableSet(this.neighbors.keySet()).iterator();
    }

    public void printStuff() {
        boolean remember = Simplex.moreInfo;
        System.out.println("Neighbor data for " + this);
        for (Simplex simplex : this.neighbors.keySet()) {
            Simplex.moreInfo = true;
            System.out.print("    " + simplex + ":");
            Simplex.moreInfo = false;
            for (Simplex s : this.neighbors.get(simplex)) {
                System.out.print(" " + s);
            }
            System.out.println();
        }
        Simplex.moreInfo = remember;
    }

    public Simplex neighborOpposite(Object vertex, Simplex simplex) {
        if (!simplex.contains(vertex)) {
            throw new IllegalArgumentException("Bad vertex; not in simplex");
        }
        block0: for (Simplex s : this.neighbors.get(simplex)) {
            for (Object v : simplex) {
                if (!v.equals(vertex) && !s.contains(v)) continue block0;
            }
            return s;
        }
        return null;
    }

    public Set neighbors(Simplex simplex) {
        return new HashSet<Simplex>(this.neighbors.get(simplex));
    }

    public void update(Set<Simplex> oldSet, Set<Simplex> newSet) {
        HashSet<Simplex> allNeighbors = new HashSet<Simplex>();
        for (Simplex s : oldSet) {
            allNeighbors.addAll((Collection)this.neighbors.get(s));
        }
        for (Simplex simplex : oldSet) {
            Iterator<Simplex> otherIt = this.neighbors.get(simplex).iterator();
            while (otherIt.hasNext()) {
                this.neighbors.get(otherIt.next()).remove(simplex);
            }
            this.neighbors.remove(simplex);
            allNeighbors.remove(simplex);
        }
        allNeighbors.addAll(newSet);
        for (Simplex s : newSet) {
            this.neighbors.put(s, new HashSet());
        }
        for (Simplex s1 : newSet) {
            for (Simplex s2 : allNeighbors) {
                if (!s1.isNeighbor(s2)) continue;
                this.neighbors.get(s1).add(s2);
                this.neighbors.get(s2).add(s1);
            }
        }
    }
}

