/*
 * Decompiled with CFR 0.152.
 */
package explorer.data;

import explorer.Explorer3D;
import explorer.FileHistory;
import explorer.batch.Test;
import explorer.bridge.SocketControler;
import explorer.compute.classification.AbstractExploration;
import explorer.compute.classification.ExplorationPerso;
import explorer.compute.classification.ExplorationSpherique;
import explorer.compute.classification.PlusProcheVoisin;
import explorer.compute.compute.projection.PMARDp;
import explorer.compute.compute.projection.PMDirect;
import explorer.compute.compute.projection.PMFactory;
import explorer.compute.compute.projection.ProjectionFactory;
import explorer.compute.compute.projection.ProjectiveMethod;
import explorer.compute.kernels.Kernel;
import explorer.compute.scripts.ScriptControler;
import explorer.compute.tools.AlongAxisTool;
import explorer.compute.tools.CurrentAxesTool;
import explorer.compute.tools.DimensionTravelTool;
import explorer.compute.tools.DisplayStyleTool;
import explorer.compute.tools.MinCovTreeTool;
import explorer.compute.tools.ObservationsTool;
import explorer.compute.tools.OutilSVM;
import explorer.compute.tools.OutilsACP;
import explorer.compute.tools.OutilsAffichageDistorsions;
import explorer.compute.tools.OutilsAffichageMalPlaces;
import explorer.compute.tools.OutilsAxesOriginaux;
import explorer.compute.tools.OutilsCropBox;
import explorer.compute.tools.OutilsCropSphere;
import explorer.compute.tools.OutilsMDSClassic;
import explorer.compute.tools.PCTool;
import explorer.compute.tools.ScaleTool;
import explorer.compute.tools.VisualAttributesTool;
import explorer.compute.tools.classification.ClassificationTools;
import explorer.compute.tools.flatdrawing.FlatDrawingParentTool;
import explorer.compute.tools.kernels.KernelParentTool;
import explorer.data.DataManager;
import explorer.data.DatasetParamsExplorer;
import explorer.data.LoadException;
import explorer.data.NoFileException;
import explorer.data.OptionsExplorer;
import explorer.data.Source3DCoord;
import explorer.data.SourceAttrVal;
import explorer.data.SourceDist;
import explorer.data.SphereParameters;
import explorer.data.ViewManager;
import explorer.data.ViewObserver;
import explorer.display3D.AffichagePrimitives;
import explorer.display3D.DisplayExplorer;
import explorer.display3D.DisplayParametersObserver;
import explorer.display3D.javafx.DisplayJFXExplorer;
import explorer.windows.w2D.icview.ICV3DReset;
import explorer.windows.w2D.icview.ICVAlongAxis;
import explorer.windows.w2D.icview.ICVCropBox;
import explorer.windows.w2D.icview.ICVCurrentAxes;
import explorer.windows.w2D.icview.ICVDimensionsTravel;
import explorer.windows.w2D.icview.ICVDisplayStyle;
import explorer.windows.w2D.icview.ICVLens;
import explorer.windows.w2D.icview.ICVMinCovTree;
import explorer.windows.w2D.icview.ICVObservations;
import explorer.windows.w2D.icview.ICVSVM;
import explorer.windows.w2D.icview.ICVSVMDisplayMode;
import explorer.windows.w2D.icview.ICVSpaceScale;
import explorer.windows.w2D.icview.ICVViewExplorer;
import explorer.windows.w2D.icview.ICVVisualAttributes;
import explorer.windows.w2D.icview.classification.ICVClassification;
import explorer.windows.w2D.icview.constrained.ICVConstraints;
import explorer.windows.w2D.icview.generic.BiLevelParentView;
import explorer.windows.w2D.icview.kernels.ICVKernels;
import explorer.windows.w2D.icview.projectivemethods.ICVAttrValProj;
import explorer.windows.w2D.icview.projectivemethods.ICVConditionningView;
import explorer.windows.w2D.jTaskPaneGroup.ICVDistance;
import explorer.windows.w2D.jTaskPaneGroup.ICVMisclassified;
import explorer.windows.w2D.jTaskPaneGroup.ICVStables;
import explorer.windows.w2D.utils.CropSphereDialog;
import explorer.windows.w2D.utils.GView;
import explorer.windows.w2D.utils.IterationsDialog;
import explorer.windows.w2D.utils.Lateral;
import explorer.windows.w2D.utils.OnlineFileChooser;
import explorer.windows.w2D.utils.OptionsDialog;
import explorer.windows.w2D.utils.Script;
import explorer.windows.w2D.utils.SubsetExplorer;
import explorer.windows.w2D.utils.ToolImportData;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import javax.swing.filechooser.FileFilter;
import lib3d4j.compute.compute.ComputeInfo;
import lib3d4j.data.DescriptionData;
import lib3d4j.data.Source;
import lib3d4j.data.SourceException;
import lib3d4j.display3D.java3D.CentralSelection;
import lib3d4j.display3D.java3D.data.Parameters3D;
import lib3d4j.display3D.javafx.JFXSwingUtils;
import lib3d4j.display3D.javafx.objects.RichPrimitiveFactoryJFX;
import lib3d4j.international.Messages;

public class Common
implements ComputeInfo,
ViewObserver {
    public static boolean MULTI = true;
    private static Common common = new Common();
    public DatasetParamsExplorer param;
    private int nbobjets = 0;
    private DataManager dm = null;
    private PMFactory pf = PMFactory.getSingleton();
    private Parameters3D currentAspect;
    private float currentScale = 0.0f;
    public DisplayExplorer f3d = null;
    public Kernel noyau = null;
    private AffichagePrimitives affichagePrimitives = null;
    public FileHistory fileHistory = new FileHistory();
    private String cheminVisuPrimitives;
    private ICVAttrValProj icv_attrvalproj;
    private CurrentAxesTool tCurrentAxes;
    private ICVCurrentAxes icv_currentaxes;
    private ObservationsTool tObservations;
    private ICVObservations icv_observations;
    private BiLevelParentView icv_2dgraphs;
    private BiLevelParentView icv_kernels;
    private ICVSVM icv_svm;
    private ICVSVMDisplayMode icv_svmdisplay;
    private PCTool pct;
    private ICVConstraints icv_constraints;
    private AlongAxisTool aat;
    private ICVAlongAxis icv_alongaxis;
    private ICVViewExplorer icv_viewexplorer;
    private ICVCropBox icv_cropbox;
    private ICVDimensionsTravel icv_dimtravel;
    private ICVDistance icv_distance;
    private ICVVisualAttributes icv_visattr;
    private ICVClassification icv_classif;
    private ICVMinCovTree icv_mincovtree;
    private ICVStables icv_stables;
    private ICV3DReset icv_3dreset;
    private ICVDisplayStyle icv_3dviewstyle;
    private ICVSpaceScale icv_spacescale;
    private ICVConditionningView icv_pretrt;
    private ICVMisclassified icv_misclass;
    private Lateral lateral = null;
    private FlatDrawingParentTool tCourbes2D;
    private OutilsACP tACP = null;
    private OutilsCropBox tCrop = null;
    private OutilsCropSphere tSCrop = null;
    private OutilsMDSClassic tMDSC = null;
    private DimensionTravelTool tDimensionsTravel;
    private OutilsAffichageMalPlaces tMalPlaces;
    private ClassificationTools tClassification;
    private OutilsAffichageDistorsions tDistorsions;
    private OptionsExplorer options = OptionsExplorer.getSingleton();
    private OptionsDialog optionsPanel;
    private IterationsDialog iterationsDialog;
    private OutilsAxesOriginaux tAxesOriginaux;
    private VisualAttributesTool tVA;
    public boolean initialisation = true;
    private Script script;
    private SphereParameters csd;
    private OutilSVM tSVM;
    private KernelParentTool tKernel;
    SubsetExplorer ami = null;
    private JComponent draggedComponent = null;
    private ICVLens icv_lens;
    DescriptionData descr = null;
    private ProjectiveMethod currentPM = null;
    public Source data = null;
    private SocketControler remoteCtrl;

    public static Common getSingleton() {
        return common;
    }

    private Common() {
        this.options.load();
        this.optionsPanel = new OptionsDialog(this);
        this.dm = DataManager.getSingleton();
        this.descr = this.dm.getCompAttr();
        this.param = this.dm.getParams();
        this.currentAspect = new Parameters3D();
        DisplayParametersObserver.getSingleton();
        this.tACP = new OutilsACP(this, this, null);
        this.tMDSC = new OutilsMDSClassic();
        this.tSCrop = new OutilsCropSphere();
        this.tCrop = new OutilsCropBox();
        this.tVA = new VisualAttributesTool(this);
        this.tMalPlaces = new OutilsAffichageMalPlaces(null, this);
        this.tCourbes2D = new FlatDrawingParentTool();
        this.tDistorsions = new OutilsAffichageDistorsions(null, this);
        this.tKernel = new KernelParentTool();
        this.tSVM = new OutilSVM();
        this.tAxesOriginaux = new OutilsAxesOriginaux(null, this);
        this.tObservations = new ObservationsTool();
        this.pct = new PCTool();
        this.aat = new AlongAxisTool();
        this.tClassification = new ClassificationTools();
        this.tDimensionsTravel = new DimensionTravelTool();
        this.tCurrentAxes = new CurrentAxesTool();
        this.script = new Script();
        this.iterationsDialog = new IterationsDialog(this);
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        if (ViewManager.getSingleton().getActiveView() != null) {
            this.data = ViewManager.getSingleton().getActiveView().getProjectiveMethod().getSource();
        }
        ViewManager.getSingleton().addViewObserver(this);
        this.setOptions();
    }

    public ICVVisualAttributes getVisuAffTPG() {
        return this.icv_visattr;
    }

    public PCTool getPcTool() {
        return this.pct;
    }

    public void showVisu() {
        this.lateral.setICViewVisible("ICV_VisAttr", true);
    }

    public ICVMisclassified getProcheVoisin() {
        return this.icv_misclass;
    }

    public void setLateral(Lateral l) {
        this.lateral = l;
        this.setLateralViewsAndGroup();
    }

    public OutilsACP getTACP() {
        return this.tACP;
    }

    public OptionsDialog getOptionsPanel() {
        return this.optionsPanel;
    }

    public IterationsDialog getIterationsDialog() {
        return this.iterationsDialog;
    }

    private void setGroups() {
        this.setInteractionGroup();
        this.setAttrValGroup();
        this.setDistanceGroup();
        this.setCropBoxGroup();
        this.setDimensionTravelGroup();
        this.set3DSpaceGroup();
        this.setClassificationGroup();
        this.setSVMGroup();
    }

    private void setInteractionGroup() {
        ArrayList<Lateral.ICViewInitialState> group = new ArrayList<Lateral.ICViewInitialState>();
        group.add(new Lateral.ICViewInitialState("ICV_Constraints", true));
        this.lateral.addICVGroup("Interaction", group);
    }

    private void setAttrValGroup() {
        ArrayList<Lateral.ICViewInitialState> group = new ArrayList<Lateral.ICViewInitialState>();
        group.add(new Lateral.ICViewInitialState("ICV_AttrValPreTrt", false));
        group.add(new Lateral.ICViewInitialState("ICV_AttrValProj", true));
        group.add(new Lateral.ICViewInitialState("ICV_Kernels", false));
        group.add(new Lateral.ICViewInitialState("ICV_3DReset", false));
        group.add(new Lateral.ICViewInitialState("ICV_CurrentAxes", false));
        group.add(new Lateral.ICViewInitialState("ICV_Observations", false));
        group.add(new Lateral.ICViewInitialState("ICV_2DGraphs", false));
        group.add(new Lateral.ICViewInitialState("ICV_VisAttr", false));
        group.add(new Lateral.ICViewInitialState("ICV_ViewExplorer", true));
        group.add(new Lateral.ICViewInitialState("ICV_MinCovTree", false));
        this.lateral.addICVGroup("AttrVal", group);
    }

    private void setDistanceGroup() {
        ArrayList<Lateral.ICViewInitialState> group = new ArrayList<Lateral.ICViewInitialState>();
        group.add(new Lateral.ICViewInitialState("ICV_Distance", true));
        group.add(new Lateral.ICViewInitialState("ICV_3DReset", true));
        group.add(new Lateral.ICViewInitialState("ICV_CurrentAxes", false));
        group.add(new Lateral.ICViewInitialState("ICV_Observations", false));
        group.add(new Lateral.ICViewInitialState("ICV_2DGraphs", false));
        group.add(new Lateral.ICViewInitialState("ICV_VisAttr", true));
        group.add(new Lateral.ICViewInitialState("ICV_Kernels", false));
        group.add(new Lateral.ICViewInitialState("ICV_MinCovTree", false));
        group.add(new Lateral.ICViewInitialState("ICV_ViewExplorer", true));
        this.lateral.addICVGroup("Distance", group);
    }

    private void setCropBoxGroup() {
        ArrayList<Lateral.ICViewInitialState> group = new ArrayList<Lateral.ICViewInitialState>();
        group.add(new Lateral.ICViewInitialState("ICV_CropBox", true));
        this.lateral.addICVGroup("CropBox", group);
    }

    private void setDimensionTravelGroup() {
        ArrayList<Lateral.ICViewInitialState> group = new ArrayList<Lateral.ICViewInitialState>();
        group.add(new Lateral.ICViewInitialState("ICV_DimensionTravel", true));
        this.lateral.addICVGroup("DimensionTravel", group);
    }

    private void set3DSpaceGroup() {
        ArrayList<Lateral.ICViewInitialState> group = new ArrayList<Lateral.ICViewInitialState>();
        group.add(new Lateral.ICViewInitialState("ICV_VisAttr", true));
        group.add(new Lateral.ICViewInitialState("ICV_3DViewStyle", true));
        group.add(new Lateral.ICViewInitialState("ICV_SpaceScale", true));
        group.add(new Lateral.ICViewInitialState("ICV_Lens", true));
        this.lateral.addICVGroup("3DSpace", group);
    }

    private void setClassificationGroup() {
        ArrayList<Lateral.ICViewInitialState> group = new ArrayList<Lateral.ICViewInitialState>();
        group.add(new Lateral.ICViewInitialState("ICV_Classif", true));
        group.add(new Lateral.ICViewInitialState("ICV_MinCovTree", true));
        group.add(new Lateral.ICViewInitialState("ICV_Stables", true));
        group.add(new Lateral.ICViewInitialState("ICV_CurrentAxes", false));
        group.add(new Lateral.ICViewInitialState("ICV_Observations", false));
        group.add(new Lateral.ICViewInitialState("ICV_2DGraphs", false));
        group.add(new Lateral.ICViewInitialState("ICV_VisAttr", false));
        this.lateral.addICVGroup("Classification", group);
    }

    private void setSVMGroup() {
        ArrayList<Lateral.ICViewInitialState> group = new ArrayList<Lateral.ICViewInitialState>();
        group.add(new Lateral.ICViewInitialState("ICV_SVM", true));
        group.add(new Lateral.ICViewInitialState("ICV_SVMDisplayMode", true));
        group.add(new Lateral.ICViewInitialState("ICV_VisAttr", true));
        group.add(new Lateral.ICViewInitialState("ICV_Kernels", false));
        group.add(new Lateral.ICViewInitialState("ICV_ViewExplorer", true));
        this.lateral.addICVGroup("SVM", group);
    }

    public void saveProject() {
        new ScriptControler().doWrite();
    }

    public void loadProject() {
        new ScriptControler().doRead();
    }

    public void load(boolean online) {
        if (online) {
            OnlineFileChooser chooser = new OnlineFileChooser();
            int returnVal = chooser.showOpen(this.lateral);
            if (returnVal == OnlineFileChooser.APPROVE_OPTION) {
                String file = "";
                try {
                    file = chooser.getSelected();
                    URL url = new URL(file);
                    this.load(DataManager.getDataType(url), url);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            JFileChooser chooser = null;
            chooser = this.param.getProtocol() == 1 ? new JFileChooser(this.param.getCurrentPath().getPath()) : new JFileChooser(this.param.getBaseDir());
            FileFilter filter = new FileFilter(){

                @Override
                public String getDescription() {
                    return "CSV Files";
                }

                @Override
                public boolean accept(File pathname) {
                    if (pathname.isDirectory()) {
                        return true;
                    }
                    String name = pathname.getName();
                    int ext = name.lastIndexOf(46);
                    if (ext != -1) {
                        return name.substring(ext + 1).equals("csv");
                    }
                    return false;
                }
            };
            chooser.addChoosableFileFilter(filter);
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                String file = "";
                file = chooser.getSelectedFile().getAbsolutePath();
                this.load(DataManager.getDataType(file), file);
            }
        }
    }

    public void load(int dataType, String fileName) {
        try {
            this.load(dataType, this.formURL(fileName));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private URL formURL(String s) throws MalformedURLException {
        URL u = null;
        try {
            u = new URL(s);
        }
        catch (MalformedURLException e) {
            u = new URL("file", null, s);
        }
        return u;
    }

    public Source load(int dataType, URL u) {
        boolean exit = false;
        do {
            try {
                Source src = this.loadInternal(dataType, u);
                return src;
            }
            catch (NoFileException nfe) {
                JOptionPane.showMessageDialog(null, Messages.getString("errorfile"), Messages.getString("warning"), 2);
                exit = true;
            }
            catch (LoadException e) {
                JOptionPane.showMessageDialog(null, Messages.getString("filenotagree"), Messages.getString("warning"), 2);
                if (u.getProtocol().equals("file")) {
                    ToolImportData tid = new ToolImportData(this, u.getPath(), false);
                    tid.setVisible(true);
                    if (tid.getChange()) {
                        String fileName = tid.getSavedName();
                        try {
                            u = this.formURL(fileName);
                            dataType = DataManager.getDataType(fileName);
                        }
                        catch (MalformedURLException malformedURLException) {}
                    } else {
                        exit = true;
                    }
                    tid.dispose();
                    continue;
                }
                JOptionPane.showMessageDialog(null, "Fichier en ligne non compatible/nMerci de choisir un autre fichier", "Erreur de lecture", 0);
            }
        } while (!exit);
        return null;
    }

    public Source loadInternal(int dataType, URL u) throws LoadException {
        if (u == null) {
            throw new LoadException(-1);
        }
        Source src = null;
        try {
            this.lateral.setEtatText(Messages.getString("common_fileopen"));
            this.lateral.paintEtatImmediately(0, 0, 1000, 1000);
            switch (dataType) {
                case 0: 
                case 30: {
                    src = this.dm.createSourceAttrVal(u);
                    if (Explorer3D.mode == Explorer3D.CLASSIFICATION) {
                        this.classificationTask(u, (SourceAttrVal)src);
                        System.exit(0);
                    }
                    this.lateral.setStatusText(String.valueOf(Messages.getString("common_size")) + ": " + src.getNbObjects() + " x " + (this.dm.getCompAttr().getNbAtt() + ((SourceAttrVal)src).getNbAttACP()));
                    break;
                }
                case 10: {
                    src = this.dm.createSourceDist(u);
                    this.lateral.setStatusText(String.valueOf(Messages.getString("common_size")) + ": " + src.getNbObjects() + " x " + src.getNbObjects());
                    break;
                }
                case 20: {
                    src = this.dm.createSource3DCoord(u);
                    if (src == null) {
                        this.lateral.setEtatText("Fichier " + u + " non conforme");
                        break;
                    }
                    this.lateral.setEtatText("Creation scene ...");
                    this.lateral.paintEtatImmediately(0, 0, 1000, 1000);
                    this.lateral.setStatusText(String.valueOf(Messages.getString("common_size")) + ": " + src.getNbObjects() + " x 3");
                    this.lateral.setVisuTPG();
                    break;
                }
                default: {
                    this.lateral.setEtatText(String.valueOf(Messages.getString("common_fileread")) + " " + u + " " + Messages.getString("ok"));
                    throw new LoadException();
                }
            }
            this.lateral.setEtatText(String.valueOf(Messages.getString("common_fileread")) + " " + u + " " + Messages.getString("ok"));
            DataManager.getSingleton().getParams().setCurrentUrl(u);
            this.postLoad(u, src);
            this.lateral.setEtatText("");
            return src;
        }
        catch (SourceException le) {
            throw (LoadException)le;
        }
    }

    private void classificationTask(URL u, SourceAttrVal src) {
        this.param.setClassCol(0);
        this.descr.afficheClasseDistrib();
        String sep = u.getProtocol().equals("file") ? File.separator : "/";
        String nom = u.toString().substring(u.toString().lastIndexOf(sep) + 1);
        File currDir = new File(System.getProperty("user.dir"));
        String[] fileList = currDir.list();
        boolean trouve = false;
        int i = 0;
        while (i < fileList.length && !trouve) {
            if (fileList[i].length() >= nom.length() && nom.equals(fileList[i].substring(0, nom.length()))) {
                trouve = true;
            }
            ++i;
        }
        if (!trouve) {
            Test.genereDistr(this.descr.getClassIndices(), nom);
            System.out.println("fichiers de test inexistants, cr\u00e9ation termin\u00e9e");
        }
        int methode = 1;
        while (methode < 6) {
            if (methode != PMFactory.LDA && methode != PMFactory.ACPDual) {
                AbstractExploration.numeroMethode = methode;
                int dimMax = src.getNbAttACP() + 1;
                int dim = 1;
                while (dim < dimMax) {
                    if (dim > this.descr.getNbClasses() && ExplorationPerso.numeroMethode == PMFactory.LDA) break;
                    int[] x = new int[dim];
                    int i22 = 0;
                    while (i22 < x.length) {
                        x[i22] = i22;
                        ++i22;
                    }
                    System.out.print(String.valueOf(dim) + " ");
                    try {
                        PlusProcheVoisin i22 = new PlusProcheVoisin(this, src, x, methode, nom);
                    }
                    catch (Exception e) {
                        System.out.println("exception!");
                        e.printStackTrace();
                    }
                    float i3 = 1.0E-6f;
                    while (i3 < 3000.0f) {
                        try {
                            ExplorationSpherique.distanceMax = i3;
                            int nbVoisins = 1;
                            while (nbVoisins <= 9) {
                                if (methode == PMFactory.ARDp) {
                                    PMARDp.param_sigma = 3;
                                    ExplorationSpherique.nbMinProcheVoisins = nbVoisins;
                                    System.out.print(String.valueOf(dim) + " " + Math.log(i3));
                                    ExplorationSpherique ep = new ExplorationSpherique(this, src, x, nom);
                                    ++methode;
                                    PMARDp.param_sigma = 5;
                                    System.out.print(String.valueOf(dim) + " " + Math.log(i3));
                                    ExplorationSpherique ep2 = new ExplorationSpherique(this, src, x, nom);
                                    --methode;
                                } else {
                                    ExplorationSpherique.nbMinProcheVoisins = nbVoisins;
                                    System.out.print(String.valueOf(dim) + " " + Math.log(i3));
                                    ExplorationSpherique explorationSpherique = new ExplorationSpherique(this, src, x, nom);
                                }
                                ++nbVoisins;
                            }
                        }
                        catch (Exception e) {
                            System.out.println("exception!");
                            e.printStackTrace();
                        }
                        i3 *= 2.0f;
                    }
                    ++dim;
                }
            }
            ++methode;
        }
    }

    public void postLoad(URL u, Source src) {
        this.pct.updateLists();
        this.aat.updateLists();
        if (DataManager.getSingleton().getNbSources() <= 1) {
            this.icv_visattr.raz();
        }
        this.getProcheVoisin().RAZ();
        this.param = DataManager.getSingleton().getParams();
        int dt = src.getType();
        if (src.getUrl() != null) {
            this.fileHistory.addEntree(src.getUrl().toString(), dt);
        }
        this.nbobjets = this.descr.getNbDescrObjects();
        this.computeObjectSize();
        switch (dt) {
            case 10: {
                this.lateral.setMDSMetriqueTPG();
                if (!this.options.isLoadAndShow()) break;
                this.tMDSC.compute((SourceDist)src);
                break;
            }
            case 0: {
                this.lateral.setACPTPG();
                if (!this.options.isLoadAndShow() || ((SourceAttrVal)src).getNbAttACP() == 0) break;
                this.tACP.compute();
                break;
            }
            case 20: {
                PMDirect pm = this.pf.createPMDirect((Source3DCoord)src);
                ((ProjectiveMethod)pm).calculer();
                this.traceFenetre3D(pm);
            }
        }
        this.postLoadGraphem();
    }

    private void computeObjectSize() {
        if (this.options.isDynamicObjectSize()) {
            float objectSize = 1.0f;
            objectSize = this.nbobjets > 1500 ? 1.0f : (this.nbobjets > 500 ? 2.0f : (this.nbobjets > 200 ? 4.0f : (this.nbobjets > 100 ? 5.0f : (this.nbobjets > 20 ? 6.6666665f : 10.0f))));
            this.setObjectScale(objectSize);
        }
    }

    private void postLoadGraphem() {
        String[] names;
        String classattr = "Class";
        String[] stringArray = names = this.descr.getColNamesWithIndice();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            if (n3.equals("GR_Name") || n3.equals("ImgFileName")) {
                this.getTPGVisuAff().setAssociatedData(n3);
                if (n3.equals("GR_Name")) {
                    String sep = "/";
                    String path = this.param.getCurrentPath().toString();
                    if (path.contains("Applis")) {
                        path = path.substring(0, path.lastIndexOf("Applis") + 7);
                    } else if (path.toLowerCase().contains("gamme_logicielle_graphem")) {
                        path = path.substring(0, path.toLowerCase().lastIndexOf("gamme_logicielle_graphem") + 25);
                    } else if (path.contains(String.valueOf(sep) + "graphem")) {
                        path = path.substring(0, path.toLowerCase().lastIndexOf("graphem") + 8);
                    }
                    path = String.valueOf(path) + "Images" + sep;
                    try {
                        this.param.setImagePath(new URL(String.valueOf(path) + "Vignettes"));
                        this.param.setHqImagePath(new URL(String.valueOf(path) + "Complete"));
                    }
                    catch (MalformedURLException e) {
                        System.out.println(path);
                        e.printStackTrace();
                    }
                }
            } else if (n3.equals(classattr)) {
                this.getTPGVisuAff().setClassColor(classattr);
            }
            ++n2;
        }
    }

    public AffichagePrimitives getAffichagePrimitives() {
        return this.affichagePrimitives;
    }

    public int getNbObjects() {
        return this.nbobjets;
    }

    public void addView(JFrame jf) {
        jf.setVisible(true);
    }

    public void traceFenetre3D(ProjectiveMethod pm) {
        this.f3d = new DisplayJFXExplorer(ProjectionFactory.createStandardProjection(pm));
        this.f3d.setVisible(true);
    }

    @Override
    public void taskSetText(String txt) {
        this.lateral.setEtatText(txt);
    }

    public void getNomValue() {
        this.getNomValue(false);
    }

    public void getNomValue(boolean ChangerDeLabel) {
        try {
            if (ChangerDeLabel) {
                List<GView> lgv = ViewManager.getSingleton().getGviews();
                for (GView gv : lgv) {
                    if (!(gv instanceof DisplayExplorer)) continue;
                    ((DisplayExplorer)gv).dropAllLabels();
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void subtaskSetOn(String txt, int val) {
        this.lateral.setProgressOn(txt, val);
    }

    @Override
    public void subtaskSetOff() {
        this.lateral.setProgressOff();
    }

    @Override
    public void subtaskSetVal(int val) {
        this.lateral.setProgressVal(val);
    }

    @Override
    public void subtaskSetMinMax(int min, int max) {
        this.lateral.setProgresMin(min);
        this.lateral.setProgresMax(max);
    }

    @Override
    public void subtaskSetText(String txt) {
        this.lateral.setProgressString(txt);
    }

    @Override
    public void subtaskSetStringPainted(boolean paint) {
        this.lateral.setProgressStringPainted(paint);
    }

    public void Progress_reDraw() {
        this.lateral.setProgressReDraw();
    }

    public int[] varRep_getAxes() {
        return this.icv_currentaxes.getProjectionAxes();
    }

    public void attributsComp(String nomFonction, String nomParametre) {
        this.icv_visattr.attributsComp(nomFonction, nomParametre);
    }

    public void openControl() {
        this.lateral.setICViewVisible("ICV_Misclassified", true);
    }

    public void setForme(String nomParametre) {
        this.icv_misclass.setForme(nomParametre);
    }

    public void setNbVoisins(String nomParametre) {
        this.icv_misclass.setNbVoisins(nomParametre);
    }

    public void isAffichageMalClass\u00e9s(boolean nomParametre) {
        this.icv_misclass.setAfficherSelected(nomParametre);
    }

    public void setDensit\u00e9(int nomParametre) {
        this.icv_misclass.setDensit\u00e9(nomParametre);
    }

    public void isAffichageEllipso\u00efde(boolean nomParametre) {
        this.icv_misclass.setAfficherEllipsesSelected(nomParametre);
    }

    public void next() {
        this.icv_misclass.next();
    }

    public void previous() {
        this.icv_misclass.previous();
    }

    public void zoomEllipso\u00efde() {
        this.icv_misclass.ZoomEllipso\u00efde();
    }

    public void zoomMalClass\u00e9s() {
        this.icv_misclass.ZoomMalClass\u00e9s();
    }

    public void cube() {
        this.icv_misclass.Cube();
    }

    public void Crop_setSphere(float[] center) {
        this.csd = this.tSCrop.getSphereMgr();
        if (this.csd == null) {
            this.csd = new CropSphereDialog(this.tSCrop);
            this.tSCrop.setSphereMgr(this.csd);
        }
        this.tSCrop.setCenter(center);
        this.csd.setRadius(this.csd.getDefaultRadius());
        this.csd.setVisible(true);
        this.tSCrop.setCenter(center);
    }

    public void setCheminVisuPrimitives(String chemin) {
        this.cheminVisuPrimitives = chemin;
    }

    public ClassificationTools getTClassification() {
        return this.tClassification;
    }

    public void reinitialiserParametres() {
        this.icv_visattr.raz();
        this.optionsPanel.reinitialiser();
        this.tMalPlaces.reinitialiser();
        ViewManager.getSingleton().reset();
        CentralSelection.getSingleton().reset();
        this.tACP.reset();
    }

    public void prepareShutdown() {
        ViewManager.getSingleton().reset();
    }

    public String[] lesnoms() {
        if (this.data == null) {
            return null;
        }
        int nbeffectif = this.data.getNbObjects();
        String[] lesnoms = new String[nbeffectif];
        int i = 0;
        while (i < nbeffectif) {
            int j = i;
            j = this.data.getRealIndex(i);
            lesnoms[i] = (String)this.descr.getLabelValue(j);
            ++i;
        }
        return lesnoms;
    }

    public OutilsCropBox getTCrop() {
        return this.tCrop;
    }

    public ICVMisclassified getTPGMalPlaces() {
        return this.icv_misclass;
    }

    public Lateral getLateral() {
        return this.lateral;
    }

    public OutilsAffichageMalPlaces getTMalPlaces() {
        return this.tMalPlaces;
    }

    public float getObjectScale() {
        return this.currentScale;
    }

    public void setObjectScale(float s) {
        this.currentScale = s;
        this.icv_spacescale.setElemScale(s);
    }

    public ICVMisclassified getMalPlaceTaskPanelGroup() {
        return this.icv_misclass;
    }

    public OutilsAxesOriginaux getTAxesOriginaux() {
        return this.tAxesOriginaux;
    }

    public OutilsMDSClassic getTMDSC() {
        return this.tMDSC;
    }

    public OutilsAffichageDistorsions getTDistorsions() {
        return this.tDistorsions;
    }

    private ICVVisualAttributes getTPGVisuAff() {
        return this.getVisuAffTPG();
    }

    public String getCheminVisuPrimitives() {
        return this.cheminVisuPrimitives;
    }

    public void setOptions() {
        RichPrimitiveFactoryJFX.getFactory().setDefaultColor(JFXSwingUtils.toJFXColor(this.options.getDefaultColor()));
        List<GView> lgv = ViewManager.getSingleton().getGviews();
        for (GView gv : lgv) {
            if (!(gv instanceof DisplayExplorer)) continue;
            ((DisplayExplorer)gv).setDefaultColor(JFXSwingUtils.toJFXColor(this.options.getDefaultColor()));
        }
        if (this.options.isListenToPort() && this.remoteCtrl == null) {
            this.remoteCtrl = new SocketControler(this.options.getPortNumber());
        } else if (!this.options.isListenToPort() && this.remoteCtrl != null) {
            this.remoteCtrl.stop();
            this.remoteCtrl = null;
        }
        this.options.save();
    }

    public OptionsExplorer getOptions() {
        return this.options;
    }

    public DatasetParamsExplorer getParam() {
        return this.param;
    }

    public ICVKernels getTPGKernels() {
        return null;
    }

    public OutilsACP getOutilACP() {
        return this.tACP;
    }

    public Script getScript() {
        return this.script;
    }

    public void newLoadScript() {
    }

    public void newToolImportData() {
        new ToolImportData(this, null, true).setVisible(true);
    }

    public void setRadiusCsd(int ind) {
        this.csd.setRadius(ind);
    }

    public ICVSVM getTPGSVM() {
        return this.icv_svm;
    }

    public ICVSVMDisplayMode getTPGSVMDisplayMode() {
        return this.icv_svmdisplay;
    }

    public OutilSVM getTSVM() {
        return this.tSVM;
    }

    public void computeSVM() {
        if (this.descr.getNbDescrObjects() == 0) {
            this.taskSetText(Messages.getString("common_badindices"));
        }
    }

    public Kernel getKernel() {
        return this.noyau;
    }

    public void setKernel(Kernel noyau) {
        this.noyau = noyau;
    }

    public void remplacer3emeAxe() {
        this.tSVM.remplacer3emeAxe();
    }

    public void redescription1N() {
        this.tSVM.redescription1N();
    }

    public void showFromImages(boolean activate) {
        if (activate) {
            if (this.ami == null) {
                this.ami = new SubsetExplorer(10, 10, this.f3d, this.pct);
            }
            this.ami.setVisible(true);
        } else if (this.ami != null) {
            this.ami.setVisible(false);
        }
    }

    public void setDraggedComponent(JComponent draggedComponent) {
        this.draggedComponent = draggedComponent;
    }

    public JComponent getDraggedComponent() {
        return this.draggedComponent;
    }

    private void setLateralViewsAndGroup() {
        this.icv_attrvalproj = new ICVAttrValProj(this.tACP);
        this.lateral.addICView(this.icv_attrvalproj, "ICV_AttrValProj");
        this.icv_currentaxes = new ICVCurrentAxes(this.tCurrentAxes);
        this.lateral.addICView(this.icv_currentaxes, "ICV_CurrentAxes");
        this.icv_observations = new ICVObservations(this.tObservations);
        this.lateral.addICView(this.icv_observations, "ICV_Observations");
        this.icv_2dgraphs = new BiLevelParentView(this.tCourbes2D, Messages.getString("tpgc2d_title"));
        this.lateral.addICView(this.icv_2dgraphs, "ICV_2DGraphs");
        this.icv_cropbox = new ICVCropBox(this.tCrop);
        this.lateral.addICView(this.icv_cropbox, "ICV_CropBox");
        this.icv_distance = new ICVDistance(this.tMDSC);
        this.lateral.addICView(this.icv_distance, "ICV_Distance");
        this.icv_visattr = new ICVVisualAttributes(this.tVA);
        this.lateral.addICView(this.icv_visattr, "ICV_VisAttr");
        this.icv_3dviewstyle = new ICVDisplayStyle(new DisplayStyleTool());
        this.lateral.addICView(this.icv_3dviewstyle, "ICV_3DViewStyle");
        this.icv_spacescale = new ICVSpaceScale(new ScaleTool());
        this.lateral.addICView(this.icv_spacescale, "ICV_SpaceScale");
        this.icv_pretrt = new ICVConditionningView(this.tACP);
        this.lateral.addICView(this.icv_pretrt, "ICV_AttrValPreTrt");
        this.icv_misclass = new ICVMisclassified(this);
        this.icv_constraints = new ICVConstraints(this.pct, this.aat);
        this.lateral.addICView(this.icv_constraints, "ICV_Constraints");
        this.icv_kernels = new BiLevelParentView(this.tKernel, Messages.getString("tpgkernels_title"));
        this.lateral.addICView(this.icv_kernels, "ICV_Kernels");
        this.icv_classif = new ICVClassification(this.tClassification);
        this.lateral.addICView(this.icv_classif, "ICV_Classif");
        this.icv_svm = new ICVSVM(this.tSVM);
        this.lateral.addICView(this.icv_svm, "ICV_SVM");
        this.icv_svmdisplay = new ICVSVMDisplayMode(this.tSVM);
        this.lateral.addICView(this.icv_svmdisplay, "ICV_SVMDisplayMode");
        this.icv_mincovtree = new ICVMinCovTree(new MinCovTreeTool());
        this.lateral.addICView(this.icv_mincovtree, "ICV_MinCovTree");
        this.icv_stables = new ICVStables(this);
        this.lateral.addICView(this.icv_stables, "ICV_Stables");
        this.icv_3dreset = new ICV3DReset();
        this.lateral.addICView(this.icv_3dreset, "ICV_3DReset");
        this.icv_lens = new ICVLens();
        this.lateral.addICView(this.icv_lens, "ICV_Lens");
        this.icv_dimtravel = new ICVDimensionsTravel(this.tDimensionsTravel);
        this.lateral.addICView(this.icv_dimtravel, "ICV_DimensionTravel");
        this.icv_viewexplorer = new ICVViewExplorer();
        this.lateral.addICView(this.icv_viewexplorer, "ICV_ViewExplorer");
        this.csd = new CropSphereDialog(this.tSCrop);
        this.setGroups();
    }

    @Override
    public void activeViewChanged(GView gv) {
        if (gv != null) {
            this.data = gv.getSource();
            this.currentPM = gv.getProjectiveMethod();
        } else {
            this.data = null;
        }
    }

    public Parameters3D getCurrentAspect() {
        return this.currentAspect.clone();
    }

    public void setCurrentAspect(Parameters3D currentAspect) {
        this.currentAspect = currentAspect;
    }
}

