/*
 * Decompiled with CFR 0.152.
 */
package explorer.data;

import explorer.data.Common;
import explorer.data.DataManager;
import explorer.data.LoadException;
import explorer.data.NoFileException;
import explorer.data.SourceAttrVal;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import lib3d4j.compute.compute.ComputeInfo;
import lib3d4j.data.Source;
import lib3d4j.data.SourceImpl;
import lib3d4j.international.Messages;

public class SourceAVImpl
extends SourceImpl
implements SourceAttrVal {
    protected String[] attrNames = null;
    protected float[][] avMatrix = null;
    protected int nbAttr;

    public SourceAVImpl() {
        this.type = 0;
        this.nbAttr = 0;
    }

    public SourceAVImpl(URL u) throws LoadException {
        this();
        this.url = u;
        this.loadFromUrl(u, Common.getSingleton());
    }

    public SourceAVImpl(SourceAttrVal parent, int[] crop) {
        this();
        this.url = parent.getUrl();
        this.parent = parent;
        this.nbObjects = crop.length;
        this.realIndex = (int[])crop.clone();
        this.attrNames = (String[])((SourceAVImpl)parent).attrNames.clone();
        this.nbAttr = ((SourceAVImpl)parent).nbAttr;
        this.avMatrix = new float[this.nbObjects][];
        int i = 0;
        while (i < this.nbObjects) {
            this.avMatrix[i] = (float[])((SourceAVImpl)parent).avMatrix[parent.getLocalIndex(this.realIndex[i])].clone();
            ++i;
        }
    }

    public SourceAVImpl(float[][] data) {
        this();
        this.avMatrix = (float[][])data.clone();
        this.nbAttr = this.avMatrix[0].length;
        this.nbObjects = this.avMatrix.length;
        this.attrNames = new String[this.nbAttr];
        int i = 0;
        while (i < this.nbAttr) {
            this.attrNames[i] = "" + i;
            ++i;
        }
        DataManager.getSingleton().controlNbObjects(this.nbObjects);
        this.initRealIndex();
    }

    @Override
    public Source crop(int[] crop) {
        return new SourceAVImpl(this, crop);
    }

    @Override
    public float[] distOrigine() {
        double som = 0.0;
        float[] tab = new float[this.nbObjects];
        int i = 0;
        while (i < this.nbObjects) {
            som = 0.0;
            int j = 0;
            while (j < this.nbAttr) {
                som += (double)(this.avMatrix[i][j] * this.avMatrix[i][j]);
                ++j;
            }
            tab[i] = (float)Math.sqrt(som);
            ++i;
        }
        return tab;
    }

    @Override
    public float distance(int i, int j) {
        float d = 0.0f;
        int compteur = 0;
        while (compteur < this.nbAttr) {
            try {
                d += (this.avMatrix[i][compteur] - this.avMatrix[j][compteur]) * (this.avMatrix[i][compteur] - this.avMatrix[j][compteur]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            ++compteur;
        }
        return (float)Math.sqrt(d);
    }

    @Override
    public int getNbAttACP() {
        return this.nbAttr;
    }

    @Override
    public float getAttrValue(int obj, int col) {
        return this.avMatrix[obj][col];
    }

    @Override
    public float[] getAttrValues(int obj) {
        return this.avMatrix[obj];
    }

    @Override
    public int[] lireNomsACP(String s, int attnum) {
        return this.lireNomsACP(new StringTokenizer(s, " "), attnum);
    }

    @Override
    public int[] lireNomsACP(StringTokenizer st, int attnum) {
        int w = st.countTokens();
        this.attrNames = new String[attnum];
        int i = 0;
        while (i < attnum) {
            this.attrNames[i] = st.nextToken();
            ++i;
        }
        if (w > attnum) {
            return this.readCompAttrNames(st);
        }
        return null;
    }

    @Override
    public int[] initNomsACP(int attnum, int att) {
        this.attrNames = new String[attnum];
        int i = 0;
        while (i < attnum) {
            this.attrNames[i] = "X" + i;
            ++i;
        }
        if (att > attnum) {
            return this.initCompAttrNames(att - attnum);
        }
        return null;
    }

    private void loadFromUrl(URL u, Common c) throws LoadException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(u.openStream()));
        }
        catch (IOException ioe) {
            throw new NoFileException();
        }
        this.lectureFichierACP(br, c);
    }

    private void lectureFichierACP(BufferedReader br, ComputeInfo c) throws LoadException {
        int j;
        int modulo;
        String line;
        boolean subset = false;
        int offset = 0;
        boolean afficheControle = false;
        int nbterme = 0;
        int nbtot = 0;
        int numline = 0;
        String delim = " ";
        int[] rank = null;
        try {
            int nbatt;
            line = br.readLine();
            if (line.startsWith("SUBSET")) {
                subset = true;
                offset = line.indexOf("START WITH ") != -1 ? Integer.parseInt(line.substring(line.indexOf("START WITH ") + "START WITH ".length())) : 0;
                line = br.readLine();
            }
            ++numline;
            nbtot = Integer.parseInt(line);
            if (!subset && !DataManager.getSingleton().controlNbObjects(nbtot)) {
                throw new LoadException(0);
            }
            line = br.readLine();
            ++numline;
            nbterme = Integer.parseInt(line);
            line = br.readLine();
            ++numline;
            if (SourceAVImpl.isSeparator(line)) {
                delim = line;
                line = br.readLine();
                ++numline;
            }
            try {
                nbatt = Integer.parseInt(line);
                this.initNomsACP(nbterme, nbatt);
            }
            catch (NumberFormatException nfe) {
                StringTokenizer st = new StringTokenizer(line, delim);
                nbatt = st.countTokens();
                rank = this.lireNomsACP(st, nbterme);
            }
            if (nbterme == 0) {
                this.type = 30;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, String.valueOf(Messages.getString("errorload")) + numline + "\n", Messages.getString("warning"), 2);
            throw new LoadException(numline);
        }
        this.avMatrix = new float[nbtot][nbterme];
        this.nbObjects = nbtot;
        this.initRealIndex();
        if (c != null) {
            c.subtaskSetOn(String.valueOf(Messages.getString("common_fileread")) + Messages.getString("ldots"), nbtot);
        }
        boolean[] isNum = new boolean[nbterme];
        String[] radical = new String[nbterme];
        Values[] vals = new Values[nbterme];
        boolean allNumTerms = true;
        int i = 0;
        while (i < nbterme) {
            int suffix = this.attrNames[i].lastIndexOf(".S");
            if (suffix != -1) {
                isNum[i] = false;
                radical[i] = this.attrNames[i].substring(0, suffix);
                vals[i] = new Values();
                allNumTerms = false;
            } else {
                isNum[i] = true;
                vals[i] = null;
                suffix = this.attrNames[i].lastIndexOf(".N");
                radical[i] = suffix != -1 ? this.attrNames[i].substring(0, suffix) : this.attrNames[i];
            }
            ++i;
        }
        int n = modulo = this.nbObjects >= 100 ? this.nbObjects / 100 : 1;
        if (c != null) {
            c.subtaskSetMinMax(0, this.nbObjects);
        }
        try {
            i = 0;
            while (i < this.nbObjects) {
                line = br.readLine();
                ++numline;
                StringTokenizer stz = new StringTokenizer(line, delim);
                if (subset) {
                    this.realIndex[i] = Integer.parseInt(stz.nextToken()) - offset;
                }
                if (allNumTerms) {
                    j = 0;
                    while (j < nbterme) {
                        this.avMatrix[i][j] = Float.parseFloat(stz.nextToken());
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < nbterme) {
                        this.avMatrix[i][j] = isNum[j] ? Float.parseFloat(stz.nextToken()) : (float)vals[j].getRank(stz.nextToken());
                        ++j;
                    }
                }
                this.readCompAttrs(this.realIndex[i], stz, rank);
                ++i;
            }
            if (subset) {
                this.completeCompAttrs(rank);
            }
            this.lectureFichierApresMatrice(br);
            br.close();
        }
        catch (Exception ioe) {
            if (ioe instanceof NumberFormatException) {
                JOptionPane.showMessageDialog(null, String.valueOf(Messages.getString("errorload")) + numline + "\n" + line, Messages.getString("warning"), 2);
            }
            throw new LoadException(numline);
        }
        if (afficheControle) {
            i = 0;
            while (i < nbterme) {
                System.out.print(String.valueOf(this.attrNames[i]) + " ");
                ++i;
            }
            System.out.println();
            i = 0;
            while (i < this.nbObjects) {
                j = 0;
                while (j < nbterme) {
                    System.out.print(String.valueOf(this.avMatrix[i][j]) + " ");
                    ++j;
                }
                System.out.println();
                ++i;
            }
        }
        if (c != null) {
            c.taskSetText("symbolique >> numerique");
        }
        int cumul = 0;
        i = 0;
        while (i < nbterme) {
            cumul = isNum[i] ? ++cumul : (cumul += vals[i].size());
            ++i;
        }
        String[] newNom = new String[cumul];
        cumul = 0;
        i = 0;
        while (i < nbterme) {
            if (isNum[i]) {
                newNom[cumul++] = radical[i];
            } else {
                Iterator<String> it = vals[i].iterator();
                while (it.hasNext()) {
                    newNom[cumul++] = String.valueOf(radical[i]) + '$' + it.next();
                }
            }
            ++i;
        }
        this.attrNames = newNom;
        float[][] newMat = new float[this.nbObjects][this.attrNames.length];
        i = 0;
        while (i < this.nbObjects) {
            cumul = 0;
            j = 0;
            while (j < nbterme) {
                if (isNum[j]) {
                    newMat[i][cumul++] = this.avMatrix[i][j];
                } else {
                    newMat[i][cumul + (int)this.avMatrix[i][j]] = 1.0f;
                    cumul += vals[j].size();
                }
                ++j;
            }
            ++i;
        }
        this.avMatrix = newMat;
        nbterme = this.attrNames.length;
        if (afficheControle) {
            i = 0;
            while (i < nbterme) {
                System.out.print(String.valueOf(this.attrNames[i]) + " ");
                ++i;
            }
            System.out.println();
            i = 0;
            while (i < this.nbObjects) {
                j = 0;
                while (j < nbterme) {
                    System.out.print(String.valueOf(this.avMatrix[i][j]) + " ");
                    ++j;
                }
                System.out.println();
                ++i;
            }
            System.out.println();
        }
        this.nbAttr = nbterme;
        if (c != null) {
            c.subtaskSetOff();
            c.subtaskSetText("Fin de lecture");
        }
    }

    public static String check(Vector<String> vlist) {
        boolean afficheControle = false;
        int nbterme = 0;
        boolean nbtot = false;
        int numline = 0;
        String delim = " ";
        Object rank = null;
        Iterator<String> it = vlist.iterator();
        if (!it.hasNext()) {
            return "Ligne 1 : fichier vide";
        }
        String line = it.next();
        ++numline;
        try {
            int nbobj = Integer.parseInt(line);
        }
        catch (NumberFormatException nfe) {
            return "Ligne 1 : fournir un entier = nombre d'objets (sans espaces avant ni apr\u00e8s)";
        }
        line = it.next();
        ++numline;
        try {
            nbterme = Integer.parseInt(line);
        }
        catch (NumberFormatException nfe) {
            return "Ligne 2 : fournir un entier = nombre d'attributs num\u00e9riques (sans espaces avant ni apr\u00e8s)";
        }
        line = it.next();
        ++numline;
        if (SourceAVImpl.isSeparator(line)) {
            delim = line;
            line = it.next();
            ++numline;
        }
        try {
            int nbatt = Integer.parseInt(line);
        }
        catch (NumberFormatException nfe) {
            StringTokenizer st = new StringTokenizer(line, delim);
            int nbatt = st.countTokens();
        }
        return "Fin lecture";
    }

    private void lectureFichierApresMatrice(BufferedReader br) throws IOException {
        LinkedList<float[]> list = new LinkedList<float[]>();
        try {
            String ligne = br.readLine();
            if (ligne == null) {
                return;
            }
            if (ligne.equals("vecteurs_propres")) {
                ligne = br.readLine();
                while (!ligne.equals("")) {
                    StringTokenizer stz = new StringTokenizer(ligne, " ");
                    float[] vecteurCourant = new float[stz.countTokens()];
                    int i = 0;
                    while (i < vecteurCourant.length) {
                        vecteurCourant[i] = Float.parseFloat(stz.nextToken());
                        ++i;
                    }
                    list.addLast(vecteurCourant);
                    ligne = br.readLine();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public float[][] getTable() {
        return this.avMatrix;
    }

    private class Values {
        Map<String, Integer> symbs = new HashMap<String, Integer>();
        int seq = 0;

        private Values() {
        }

        public int getRank(String chaine) {
            Integer r = this.symbs.get(chaine);
            if (r != null) {
                return r;
            }
            this.symbs.put(chaine, this.seq);
            return this.seq++;
        }

        public int size() {
            return this.seq;
        }

        public Iterator<String> iterator() {
            return this.symbs.keySet().iterator();
        }
    }
}

