/*
 * Decompiled with CFR 0.152.
 */
package explorer.data;

import explorer.data.Common;
import explorer.data.DataManager;
import explorer.data.LoadException;
import explorer.data.NoFileException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;
import lib3d4j.data.Source;
import lib3d4j.data.SourceImpl;
import lib3d4j.international.Messages;

public class SourceDist
extends SourceImpl {
    protected float[][] matDist = null;
    private boolean complete;

    public SourceDist() {
        this.type = 10;
        this.nbObjects = 0;
    }

    public SourceDist(URL u) throws LoadException {
        this();
        this.url = u;
        this.loadFromUrl(u, Common.getSingleton());
    }

    public SourceDist(SourceDist parent, int[] crop) {
        this();
        this.url = parent.getUrl();
        this.parent = parent;
        this.nbObjects = crop.length;
        this.realIndex = (int[])crop.clone();
        this.matDist = new float[this.nbObjects][this.nbObjects];
        int i = 0;
        while (i < this.nbObjects) {
            int j = 0;
            while (j < this.nbObjects) {
                float f = parent.matDist[parent.getLocalIndex(crop[i])][parent.getLocalIndex(crop[j])];
                this.matDist[j][i] = f;
                this.matDist[i][j] = f;
                ++j;
            }
            ++i;
        }
    }

    @Override
    public Source crop(int[] crop) {
        return new SourceDist(this, crop);
    }

    @Override
    public float[] distOrigine() {
        int j;
        double som = 0.0;
        float[] tab = new float[this.nbObjects];
        int i = 0;
        while (i < this.nbObjects) {
            j = 0;
            while (j < this.nbObjects) {
                som += (double)this.matDist[i][j];
                ++j;
            }
            ++i;
        }
        som /= (double)(this.nbObjects * this.nbObjects);
        i = 0;
        while (i < this.nbObjects) {
            double som2 = 0.0;
            j = 0;
            while (j < this.nbObjects) {
                som2 += (double)this.matDist[i][j];
                ++j;
            }
            tab[i] = (float)((double)this.matDist[i][i] - 2.0 * (som2 /= (double)this.nbObjects) + som);
            ++i;
        }
        return tab;
    }

    @Override
    public float distance(int i, int j) {
        return this.matDist[i][j];
    }

    public float getValue(int i, int j) {
        return this.matDist[i][j];
    }

    public float[][] getMatrix() {
        return this.matDist;
    }

    private void loadFromUrl(URL u, Common c) throws LoadException {
        String sep;
        int[] ranks;
        int numline;
        int nbtot;
        int nbatt;
        BufferedReader br;
        block21: {
            br = null;
            nbatt = 0;
            int nb_elem_line1 = 0;
            int nbterme = 0;
            nbtot = 0;
            this.complete = false;
            numline = 0;
            ranks = null;
            sep = " ";
            try {
                br = new BufferedReader(new InputStreamReader(u.openStream()));
            }
            catch (FileNotFoundException fe) {
                throw new NoFileException();
            }
            catch (IOException e) {
                throw new NoFileException();
            }
            try {
                String line = br.readLine();
                ++numline;
                StringTokenizer lu = new StringTokenizer(line);
                nb_elem_line1 = lu.countTokens();
                line = lu.nextToken();
                nbtot = Integer.parseInt(line);
                if (!DataManager.getSingleton().controlNbObjects(nbtot)) {
                    throw new LoadException(0);
                }
                if (nb_elem_line1 > 1 && lu.nextToken().toLowerCase().equals("complete")) {
                    this.complete = true;
                }
                this.matDist = new float[nbtot][nbtot];
                c.subtaskSetOn(String.valueOf(Messages.getString("common_fileread")) + Messages.getString("ldots"), nbterme);
                try {
                    if (this.complete) {
                        int i = 0;
                        while (i < nbtot) {
                            c.subtaskSetVal(i);
                            line = br.readLine();
                            ++numline;
                            lu = new StringTokenizer(line);
                            int j = 0;
                            while (j < nbtot) {
                                this.matDist[i][j] = Float.parseFloat(lu.nextToken());
                                ++j;
                            }
                            ++i;
                        }
                    } else {
                        int i = 0;
                        this.matDist[i][i] = 0.0f;
                        while (i < nbtot - 1) {
                            c.subtaskSetVal(i);
                            line = br.readLine();
                            ++numline;
                            lu = new StringTokenizer(line);
                            int j = i + 1;
                            while (j < nbtot) {
                                this.matDist[j][i] = Float.parseFloat(lu.nextToken());
                                this.matDist[i][j] = this.matDist[j][i];
                                ++j;
                            }
                            ++i;
                        }
                    }
                    c.subtaskSetOff();
                }
                catch (Exception ioe) {
                    throw new LoadException(numline);
                }
                line = br.readLine();
                ++numline;
                if (line == null) break block21;
                try {
                    String[] elems = line.split(" ");
                    nbatt = Integer.parseInt(elems[0]);
                    ranks = this.initCompAttrNames(nbatt);
                    if (elems.length > 1 && elems[1].length() == 1) {
                        sep = elems[1];
                    }
                }
                catch (NumberFormatException nfe) {
                    StringTokenizer st = new StringTokenizer(line);
                    nbatt = st.countTokens();
                    ranks = this.readCompAttrNames(st);
                }
            }
            catch (Exception ioe) {
                throw new LoadException(numline);
            }
        }
        this.nbObjects = nbtot;
        this.initRealIndex();
        if (nbatt > 0) {
            this.readCompAttrValues(br, ranks, numline, sep);
        }
        try {
            br.close();
        }
        catch (IOException e) {
            throw new LoadException(numline);
        }
    }

    public void readCompAttrValues(BufferedReader br, int[] ranks, int numline, String sep) throws LoadException {
        try {
            int i = 0;
            while (i < this.nbObjects) {
                String line = br.readLine();
                ++numline;
                StringTokenizer lu = new StringTokenizer(line, sep);
                this.readCompAttrs(i, lu, ranks);
                ++i;
            }
            br.close();
        }
        catch (Exception ioe) {
            throw new LoadException(numline);
        }
    }

    public boolean isComplete() {
        return this.complete;
    }
}

