/*
 * Decompiled with CFR 0.152.
 */
package explorer.data;

import explorer.data.Common;
import explorer.data.SrcObserver;
import explorer.data.ViewObserver;
import explorer.display3D.DisplayExplorer;
import explorer.windows.w2D.icview.ICVViewExplorer;
import explorer.windows.w2D.utils.GView;
import explorer.windows.w2D.utils.Lateral;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Rectangle2D;
import javafx.scene.paint.Color;
import javafx.stage.Screen;
import lib3d4j.data.Source;
import lib3d4j.w2d.Legendable;

public class ViewManager
implements FocusListener,
Legendable {
    private static ViewManager singleton = new ViewManager();
    private ICVViewExplorer explorer;
    private List<GView> gviews = new ArrayList<GView>();
    private List<ViewObserver> viewlisteners = new ArrayList<ViewObserver>();
    private List<SrcObserver> srclisteners = new ArrayList<SrcObserver>();
    private List<List<LegPair>> surrounds = new ArrayList<List<LegPair>>();
    private GView activeView = null;
    private Source activeSource = null;

    public static ViewManager getSingleton() {
        return singleton;
    }

    public void addView(GView gv) {
        this.gviews.add(gv);
        this.explorer.addView(gv);
        if (gv instanceof Component) {
            ((Component)((Object)gv)).addFocusListener(this);
        }
    }

    public void removeView(GView gv) {
        this.gviews.remove(gv);
        if (gv instanceof Legendable) {
            for (List<LegPair> l : this.surrounds) {
                if (l == null) continue;
                int i = 0;
                while (i < l.size()) {
                    if (l.get(i) != null && l.get((int)i).leg == gv) {
                        l.set(i, null);
                    }
                    ++i;
                }
            }
        }
        this.explorer.removeView(gv);
        if (this.activeView == gv) {
            this.setActiveView(null);
        }
    }

    public void updateView(GView gv) {
        this.explorer.updateView(gv);
        this.setActiveView(gv, true);
    }

    public Source getActiveSource() {
        return this.activeSource;
    }

    public GView getActiveView() {
        return this.activeView;
    }

    public void setActiveView(GView gv, boolean force) {
        if (force || this.activeView != gv) {
            for (ViewObserver vl : this.viewlisteners) {
                vl.activeViewChanged(gv);
            }
        }
        if (this.activeView != gv) {
            this.explorer.setActiveView(gv);
            if (this.activeView != null) {
                this.activeView.setActive(false);
            }
            if (gv != null) {
                gv.setActive(true);
                this.setActiveSource(gv.getProjectiveMethod().getSource());
            }
            this.activeView = gv;
        }
    }

    public void setActiveView(GView gv) {
        this.setActiveView(gv, false);
    }

    public void setActiveSource(Source src) {
        if (this.activeSource != src) {
            this.activeSource = src;
            for (SrcObserver sl : this.srclisteners) {
                sl.activeSrcChanged(src);
            }
        }
    }

    public void addViewObserver(ViewObserver vl) {
        this.viewlisteners.add(vl);
    }

    public void addSrcObserver(SrcObserver sl) {
        this.srclisteners.add(sl);
    }

    public void setExplorer(ICVViewExplorer e) {
        this.explorer = e;
    }

    private ViewManager() {
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.setActiveView((GView)((Object)e.getComponent()));
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public List<GView> getGviews() {
        return this.gviews;
    }

    @Override
    public int surroundGroup(int group, int form) {
        ArrayList<LegPair> l = new ArrayList<LegPair>();
        for (GView gv : this.gviews) {
            if (!(gv instanceof Legendable)) continue;
            l.add(new LegPair((Legendable)((Object)gv), ((Legendable)((Object)gv)).surroundGroup(group, form)));
        }
        this.surrounds.add(l);
        return this.surrounds.indexOf(l);
    }

    @Override
    public void desurround(int index) {
        List<LegPair> l = this.surrounds.get(index);
        for (LegPair lp : l) {
            if (lp == null) continue;
            try {
                lp.leg.desurround(lp.idx);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        this.surrounds.set(index, null);
    }

    @Override
    public void desuroundAll() {
        for (GView gv : this.gviews) {
            if (!(gv instanceof Legendable)) continue;
            ((Legendable)((Object)gv)).desuroundAll();
        }
        this.surrounds.clear();
    }

    @Override
    public void setGroupColor(int index, Color col) {
        for (GView gv : this.gviews) {
            if (!(gv instanceof Legendable)) continue;
            ((Legendable)((Object)gv)).setGroupColor(index, col);
        }
    }

    @Override
    public void setGroupVisible(int index, boolean visible) {
        for (GView gv : this.gviews) {
            if (!(gv instanceof Legendable)) continue;
            ((Legendable)((Object)gv)).setGroupVisible(index, visible);
        }
    }

    @Override
    public void setAllVisible(boolean visible) {
        for (GView gv : this.gviews) {
            if (!(gv instanceof Legendable)) continue;
            ((Legendable)((Object)gv)).setAllVisible(visible);
        }
    }

    @Override
    public boolean isGroupVisible(int index) {
        return false;
    }

    @Override
    public boolean isInVisibleGroup(int objIndex) {
        return false;
    }

    public void reset() {
        Object[] tab = this.gviews.toArray();
        int i = 0;
        while (i < tab.length) {
            Object gv = tab[i];
            if (gv instanceof DisplayExplorer) {
                ((DisplayExplorer)gv).remove();
            }
            ++i;
        }
        this.explorer.reset();
    }

    public void mosaic() {
        Lateral lat = Common.getSingleton().getLateral();
        int leftOffset = lat.getWidth() + lat.getX();
        Rectangle2D screen = Screen.getPrimary().getVisualBounds();
        int availableX = (int)screen.getMaxX() - leftOffset;
        int availableY = (int)screen.getMaxY();
        int nbGv = 0;
        for (GView gv : this.gviews) {
            if (!(gv instanceof DisplayExplorer)) continue;
            ++nbGv;
        }
        if (nbGv == 0) {
            return;
        }
        int nbX = (int)Math.ceil(Math.sqrt(nbGv));
        int nbY = (int)Math.ceil((float)nbGv / (float)nbX);
        int width = availableX / nbX;
        int height = availableY / nbY;
        nbGv = 0;
        for (GView gv : this.gviews) {
            if (!(gv instanceof DisplayExplorer)) continue;
            int x = leftOffset + nbGv % nbX * width;
            int y = nbGv / nbX * height;
            ((DisplayExplorer)gv).setXYWH(x, y, width, height);
            ++nbGv;
        }
    }

    class LegPair {
        Legendable leg;
        int idx;

        public LegPair(Legendable leg, int idx) {
            this.leg = leg;
            this.idx = idx;
        }

        public String toString() {
            return String.valueOf(this.idx) + ":" + this.leg.toString();
        }
    }
}

