/*
 * Decompiled with CFR 0.152.
 */
package explorer.display3D;

import explorer.data.DataManager;
import explorer.data.DatasetParamsExplorer;
import explorer.data.OptionsExplorer;
import explorer.data.ViewManager;
import explorer.display3D.DisplayExplorer;
import explorer.windows.w2D.utils.GView;
import explorer.windows.w2D.utils.JPanelLegendMultiClass;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import lib3d4j.data.DescriptionData;
import lib3d4j.display3D.javafx.objects.RichPrimitiveFactoryJFX;
import lib3d4j.international.Messages;
import lib3d4j.w2d.JPanelContinuousLegend;
import lib3d4j.w2d.JPanelLegend;
import lib3d4j.w2d.JPanelLegendStandard;

public class DisplayParametersObserver
implements Observer {
    private static DisplayParametersObserver singleton = null;
    private DatasetParamsExplorer params;
    private DescriptionData dd;
    private List<DisplayExplorer> displays = null;
    private JPanelLegend legend = null;
    private boolean texture;
    RichPrimitiveFactoryJFX rpfx = RichPrimitiveFactoryJFX.getFactory();

    private DisplayParametersObserver() {
        this.displays = new LinkedList<DisplayExplorer>();
        this.params = DataManager.getSingleton().getParams();
        this.params.addObserver(this);
        this.dd = DataManager.getSingleton().getCompAttr();
        this.dd.addObserver(this);
        OptionsExplorer.getSingleton().addObserver(this);
    }

    public static DisplayParametersObserver getSingleton() {
        if (singleton == null) {
            singleton = new DisplayParametersObserver();
        }
        return singleton;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof DatasetParamsExplorer) {
            if (arg != null && arg instanceof Integer) {
                GView g;
                int attr = (Integer)arg;
                if ((attr & 1) != 0) {
                    if (this.params.getColorCol() != -1) {
                        if (this.dd.isSymbolicAttribute(this.params.getColorCol())) {
                            this.rpfx.setAppearances(this.dd.getNbColor());
                        } else {
                            float min;
                            float[] values = this.dd.getColorValues();
                            float max = min = values[0];
                            int i = 1;
                            while (i < values.length) {
                                if (values[i] < min) {
                                    min = values[i];
                                } else if (values[i] > max) {
                                    max = values[i];
                                }
                                ++i;
                            }
                            this.rpfx.setContinuous(min, max, null, null);
                        }
                        if (!this.displays.isEmpty()) {
                            this.setLegend();
                        }
                    } else {
                        this.disposeLegend();
                    }
                    for (DisplayExplorer display : this.displays) {
                        display.recolor();
                    }
                }
                if ((attr & 8) != 0) {
                    for (DisplayExplorer display : this.displays) {
                        display.updatePrimShapes();
                    }
                }
                if ((attr & 0x20) != 0) {
                    this.disposeLegend();
                    if (this.params.isMulticlass()) {
                        this.rpfx.setAppearances(this.params.getMulticlass().length);
                        if (!this.displays.isEmpty()) {
                            this.setLegend();
                        }
                    }
                    for (DisplayExplorer display : this.displays) {
                        display.recolor();
                    }
                }
                if ((attr & 0x10) != 0) {
                    for (DisplayExplorer display : this.displays) {
                        display.updateLabels();
                    }
                }
                if (((attr & 0x40) != 0 || (attr & 0x20) != 0) && (g = ViewManager.getSingleton().getActiveView()) instanceof DisplayExplorer) {
                    ((DisplayExplorer)g).recomputeLocalCoords();
                }
            }
        } else if (o instanceof DescriptionData) {
            if (arg != null && arg instanceof DescriptionData.Changes) {
                DescriptionData.Changes ch = (DescriptionData.Changes)arg;
                if ((ch.attr & 2) != 0) {
                    for (DisplayExplorer display : this.displays) {
                        display.setObjectsColor(ch.objs, ch.vals);
                    }
                }
            }
        } else if (o instanceof OptionsExplorer) {
            if (!((OptionsExplorer)o).isLegendDisplayed()) {
                this.disposeLegend();
            } else if (!(!((OptionsExplorer)o).isLegendDisplayed() || this.legend != null && this.legend.isShowing() || this.displays.isEmpty() || this.params.getColorCol() == -1)) {
                this.setLegend();
            }
        }
    }

    public void addDisplay(DisplayExplorer display) {
        if (!this.displays.contains(display)) {
            if (this.displays.isEmpty() && this.params.getColorCol() != -1) {
                this.setLegend();
            }
            this.displays.add(display);
        }
    }

    public void deleteDisplay(DisplayExplorer display) {
        this.displays.remove(display);
        if (this.displays.isEmpty() && this.params.getColorCol() != -1) {
            this.disposeLegend();
        }
    }

    public void setTexture(boolean b) {
        if (this.texture != b) {
            this.texture = b;
            this.rpfx.setTexturesOn(this.texture);
            if (this.legend != null && this.legend instanceof JPanelLegendStandard) {
                if (b) {
                    ((JPanelLegendStandard)this.legend).switchToTexture();
                } else {
                    ((JPanelLegendStandard)this.legend).switchToColors();
                }
            }
        }
    }

    private void disposeLegend() {
        if (this.legend != null) {
            this.legend.setVisible(false);
        }
    }

    private void setLegend() {
        if (OptionsExplorer.getSingleton().isLegendDisplayed()) {
            int[] lmc = this.params.getMulticlass();
            if (lmc != null) {
                Vector<Object> vmc = new Vector<Object>();
                LinkedList<String> noms = this.dd.getListeNoms();
                int rank = 0;
                while (rank < lmc.length) {
                    vmc.add(noms.get(lmc[rank]));
                    ++rank;
                }
                this.legend = new JPanelLegendMultiClass(vmc, null, ViewManager.getSingleton());
                this.legend.createDialog().setVisible(true);
            } else {
                int rank = this.params.getColorCol();
                if (rank != -1) {
                    if (this.dd.isSymbolicAttribute(rank)) {
                        if (this.legend != null && this.legend instanceof JPanelLegendStandard) {
                            ((JPanelLegendStandard)this.legend).reset(this.dd.getVectorColor(), ViewManager.getSingleton(), this.dd);
                        } else {
                            this.disposeLegend();
                            this.legend = new JPanelLegendStandard(this.dd.getVectorColor(), ViewManager.getSingleton(), this.dd);
                            this.legend.createDialog();
                        }
                    } else if (this.legend != null && this.legend instanceof JPanelContinuousLegend) {
                        ((JPanelContinuousLegend)this.legend).reset(this.dd.getColorValues(), String.valueOf(Messages.getString("gradient_axis")) + " " + this.dd.getColumnName(rank));
                    } else {
                        this.disposeLegend();
                        this.legend = new JPanelContinuousLegend(this.dd.getColorValues(), String.valueOf(Messages.getString("gradient_axis")) + " " + this.dd.getColumnName(rank));
                        this.legend.createDialog();
                    }
                    this.legend.setVisible(true);
                }
            }
        }
    }
}

