/*
 * Decompiled with CFR 0.152.
 */
package explorer.display3D.javafx;

import explorer.compute.compute.projection.Projection;
import explorer.compute.compute.projection.ProjectiveMethod;
import explorer.data.Common;
import explorer.data.DataManager;
import explorer.data.DatasetParamsExplorer;
import explorer.data.OptionsExplorer;
import explorer.data.ViewManager;
import explorer.display3D.DisplayExplorer;
import explorer.display3D.DisplayParametersObserver;
import explorer.windows.w2D.utils.AttributesFrame;
import explorer.windows.w2D.utils.GView;
import explorer.windows.w2D.utils.Stage3DExplorer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.stage.Stage;
import lib3d4j.compute.tools.Envelope3D;
import lib3d4j.compute.tools.OutilsAlgebre;
import lib3d4j.data.Source;
import lib3d4j.display3D.java3D.tools.LocalCoord;
import lib3d4j.display3D.javafx.DisplayJFX;
import lib3d4j.display3D.javafx.SceneJFX;
import lib3d4j.display3D.javafx.SceneJFXController;
import lib3d4j.display3D.javafx.XForm;
import lib3d4j.display3D.javafx.objects.RichObjectJFX;
import lib3d4j.international.Messages;

public class DisplayJFXExplorer
extends DisplayJFX
implements DisplayExplorer {
    private Common parent;
    private ProjectiveMethod pm = null;
    private Projection proj = null;
    protected DatasetParamsExplorer param;
    private AttributesFrame af;
    OptionsExplorer opt;
    private Observable clico;
    private static int idgen = 0;
    private String id;
    private D3DFocusListener focuslistener;
    private List<XForm> ellipsesClassification = new ArrayList<XForm>();
    private XForm cubeCrop = null;
    private List<XForm> planSVM = new ArrayList<XForm>();
    protected int pictAtt = -1;

    public DisplayJFXExplorer(Projection p) {
        this.id = "3D" + ++idgen;
        this.clico = new Observable(){

            @Override
            public void notifyObservers(Object arg) {
                this.setChanged();
                super.notifyObservers(arg);
            }
        };
        this.proj = p;
        this.pm = this.proj.getProjectiveMethod();
        this.parent = Common.getSingleton();
        this.param = DataManager.getSingleton().getParams();
        this.data = DataManager.getSingleton().getCompAttr();
        this.opt = OptionsExplorer.getSingleton();
        this.p3d = this.parent.getCurrentAspect();
        this.init(this.param, this.opt, this.data);
        this.jp3d = this.opt.isRemoteView() ? null : new SceneJFX(this, this.opt.isStereo());
        this.parent.subtaskSetOn(Messages.getString("pgbar_initscene"), 4);
        this.parent.subtaskSetVal(0);
        this.parent.subtaskSetVal(1);
        this.parent.subtaskSetVal(2);
        this.parent.subtaskSetVal(3);
        this.parent.subtaskSetVal(4);
        this.createScene(this.proj.getCoordinates());
        this.setSelectStates();
        this.initialRotation();
        this.focuslistener = new D3DFocusListener(this);
        Platform.runLater(() -> {
            this.controller = new SceneJFXController(this, this.jp3d);
            this.stage3d = new Stage3DExplorer(this.jp3d, this.pm.getSource().getName(), true, this.focuslistener);
            this.stage3d.setOnCloseRequest(event -> this.remove());
            this.stage3d.show();
            this.stage3d.afterShow();
        });
        ViewManager.getSingleton().addView(this);
        DisplayParametersObserver.getSingleton().addDisplay(this);
    }

    @Override
    public void addObserver(Observer o) {
        this.clico.addObserver(o);
    }

    @Override
    public Source getSource() {
        return this.pm.getSource();
    }

    @Override
    public void setActive(boolean active) {
        Platform.runLater(() -> {
            this.stage3d.setHighlighted(active);
            if (active && !this.stage3d.isFocused()) {
                this.focuslistener.cancelFocus();
                this.stage3d.toFront();
            }
        });
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getSpecificPictureAttribute() {
        return this.pictAtt;
    }

    @Override
    public void setSpecificPictureAttribute(int index) {
        this.pictAtt = index;
    }

    @Override
    public Point2D[] getFlatCoordinates() {
        double minX = this.stage3d.getX() + this.stage3d.getScene().getX();
        double minY = this.stage3d.getY() + this.stage3d.getScene().getY();
        int nb = this.primArray.length;
        Point2D[] p2d = new Point2D[nb];
        int i = 0;
        while (i < nb) {
            Point2D p = this.primArray[i].getPrimitive().localToScreen(0.0, 0.0);
            p2d[i] = new Point2D((double)((float)(p.getX() - minX)), (double)((float)(p.getY() - minY)));
            ++i;
        }
        return p2d;
    }

    @Override
    public Projection getProjection() {
        return this.proj;
    }

    @Override
    public ProjectiveMethod getProjectiveMethod() {
        return this.pm;
    }

    @Override
    public void effacerDBScanSphere() {
    }

    @Override
    public void creerDbscanSphere(float r) {
    }

    @Override
    public void resizeDBScanSphere(float radius) {
    }

    @Override
    public void drawTree(boolean[][] projection) {
    }

    @Override
    public int setTarget(float[] gc, String color) {
        XForm trans = new XForm();
        int rank = this.addToList(this.allObjects, trans);
        Platform.runLater(() -> {
            Color fxcol;
            switch (color) {
                case "RED": {
                    fxcol = Color.RED;
                    break;
                }
                case "GREEN": {
                    fxcol = Color.LIGHTGREEN;
                    break;
                }
                default: {
                    fxcol = Color.YELLOW;
                }
            }
            float[] lc = this.loccoord.getLocCoord(gc);
            trans.setTranslate(lc[0], -lc[1], -lc[2]);
            XForm target = this.jp3d.addTarget(trans, fxcol, this.parent.getObjectScale());
            this.allObjects.set(rank, target);
        });
        return rank;
    }

    @Override
    public void drawDimensionTravelLines(float[][] pointsNouvelleProjection) {
    }

    @Override
    public void removeDimensionTravelLines() {
    }

    @Override
    public void updateProjection(Projection p) {
        this.lc = this.loccoord.getLocCoord(p.getCoordinates());
        int i = 0;
        while (i < this.lc.length) {
            this.primArray[i].setCoordinates(this.lc[i]);
            ++i;
        }
        this.proj = p;
        ViewManager.getSingleton().updateView(this);
    }

    @Override
    public void drawLine(Point3D[] extremites, int modele, float transparence) {
    }

    @Override
    public void addCone(float[] centre, float[] direction, int modele, float transparence) {
    }

    @Override
    public void removeMisplaced() {
    }

    @Override
    public void removeMisplacedEllipsoid() {
    }

    @Override
    public void drawMisplacedEllipsoid(float[][] points) {
    }

    @Override
    public void underlightMisplaceEllipsoid(int numero) {
    }

    @Override
    public void highlightMisplaceEllipsoid(int numero) {
    }

    @Override
    public void setMisplacedColor(int numeroMalPlace, Color couleur) {
    }

    @Override
    public void resizeMisplacedEllipsoid(float longueur, float largeur, int numero) {
    }

    @Override
    public int getFirstSelectedPoint() {
        int i = 0;
        while (i < this.primArray.length) {
            if (this.primArray[i].isSelected()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public float getMinSelected(int dim) {
        float v = Float.MAX_VALUE;
        int i = 0;
        while (i < this.lc.length) {
            if (this.primArray[i].isSelected() && v > this.lc[i][dim]) {
                v = this.lc[i][dim];
            }
            ++i;
        }
        return v;
    }

    @Override
    public float getMaxSelected(int dim) {
        float v = Float.MIN_VALUE;
        int i = 0;
        while (i < this.lc.length) {
            if (this.primArray[i].isSelected() && v < this.lc[i][dim]) {
                v = this.lc[i][dim];
            }
            ++i;
        }
        return v;
    }

    @Override
    public boolean isCropDisplayed() {
        return this.cubeCrop != null;
    }

    @Override
    public void removeCubeCrop() {
        Platform.runLater(() -> {
            this.jp3d.removeObject(this.cubeCrop);
            this.cubeCrop = null;
        });
    }

    @Override
    public void createCropCube(float x, float y, float z, float dx, float dy, float dz) {
        if (this.cubeCrop == null) {
            XForm trans = new XForm();
            trans.setTranslate(0.0, 0.0, 0.0);
            Platform.runLater(() -> {
                this.cubeCrop = this.jp3d.addBox(trans, 1.0f, 1.0f, 1.0f, 1.0f, (Material)this.pf.getCropMaterial(), true, false);
                this.moveCropCube(x, y, z);
                this.resizeCropCube(dx, dy, dz);
            });
        }
    }

    @Override
    public void moveCropCube(float x, float y, float z) {
        if (this.cubeCrop != null) {
            Platform.runLater(() -> {
                double locX = x * 500.0f * 2.0f;
                double locY = -y * 500.0f * 2.0f;
                double locZ = -z * 500.0f * 2.0f;
                this.cubeCrop.setTranslate(locX, locY, locZ);
            });
        }
    }

    @Override
    public void resizeCropCube(float dx, float dy, float dz) {
        double locDX = (double)(dx * 500.0f) * 0.8;
        double locDY = (double)(dy * 500.0f) * 0.8;
        double locDZ = (double)(dz * 500.0f) * 0.8;
        if (this.cubeCrop != null) {
            Platform.runLater(() -> this.cubeCrop.setScale(locDX, locDY, locDZ));
        }
    }

    @Override
    public List<Integer> inCropIndices() {
        ArrayList<Integer> inCrop = new ArrayList<Integer>();
        double xMin = this.cubeCrop.getTx() - this.cubeCrop.getSx();
        double xMax = this.cubeCrop.getTx() + this.cubeCrop.getSx();
        double yMin = this.cubeCrop.getTy() - this.cubeCrop.getSy();
        double yMax = this.cubeCrop.getTy() + this.cubeCrop.getSy();
        double zMin = this.cubeCrop.getTz() - this.cubeCrop.getSz();
        double zMax = this.cubeCrop.getTz() + this.cubeCrop.getSz();
        if (this.cubeCrop != null) {
            int i = 0;
            while (i < this.lc.length) {
                if ((double)this.lc[i][0] >= xMin && (double)this.lc[i][0] <= xMax && (double)(-this.lc[i][1]) >= yMin && (double)(-this.lc[i][1]) <= yMax && (double)(-this.lc[i][2]) >= zMin && (double)(-this.lc[i][2]) <= zMax) {
                    inCrop.add(i);
                }
                ++i;
            }
        }
        return inCrop;
    }

    @Override
    public boolean isInCrop(int i, float x, float y, float z, float mx, float my, float mz) {
        return false;
    }

    @Override
    public boolean isInCrop(int i, float x, float y, float z, float r) {
        return false;
    }

    @Override
    public boolean isCropSphereAffiche() {
        return false;
    }

    @Override
    public void resizeCropSphere(float radius) {
    }

    @Override
    public void drawPlane(float[][] coordLocalTriangles, int nbPoints, boolean[] positionArrete) {
        Platform.runLater(() -> {
            this.effacerPlanSVM();
            if (nbPoints == 3) {
                this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[1], coordLocalTriangles[2]));
            }
            if (nbPoints == 4) {
                if (positionArrete[0] && positionArrete[1] && positionArrete[2] && positionArrete[3] || positionArrete[8] && positionArrete[9] && positionArrete[10] && positionArrete[11]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[2], coordLocalTriangles[1]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[1], coordLocalTriangles[3], coordLocalTriangles[0]));
                } else if (positionArrete[0] && positionArrete[2] && positionArrete[5] && positionArrete[7] || positionArrete[1] && positionArrete[2] && positionArrete[8] && positionArrete[10] || positionArrete[1] && positionArrete[3] && positionArrete[4] && positionArrete[6] || positionArrete[4] && positionArrete[7] && positionArrete[9] && positionArrete[10] || positionArrete[0] && positionArrete[3] && positionArrete[9] && positionArrete[11]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[1], coordLocalTriangles[2]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[2], coordLocalTriangles[3], coordLocalTriangles[0]));
                } else if (positionArrete[4] && positionArrete[5] && positionArrete[6] && positionArrete[7]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[3], coordLocalTriangles[1]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[1], coordLocalTriangles[2], coordLocalTriangles[0]));
                } else if (positionArrete[5] && positionArrete[6] && positionArrete[8] && positionArrete[11]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[3], coordLocalTriangles[2], coordLocalTriangles[0]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[1], coordLocalTriangles[2]));
                } else {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[3], coordLocalTriangles[1], coordLocalTriangles[2]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[2], coordLocalTriangles[0], coordLocalTriangles[1]));
                }
            }
            if (nbPoints == 5) {
                if (positionArrete[0] && positionArrete[4] && positionArrete[9] && positionArrete[10] && positionArrete[11]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[4], coordLocalTriangles[2]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[2], coordLocalTriangles[0], coordLocalTriangles[1]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[1], coordLocalTriangles[3], coordLocalTriangles[2]));
                } else if (positionArrete[3] && positionArrete[5] && positionArrete[6] && positionArrete[7] && positionArrete[10]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[3], coordLocalTriangles[4]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[4], coordLocalTriangles[2], coordLocalTriangles[1]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[1], coordLocalTriangles[3], coordLocalTriangles[4]));
                } else if (positionArrete[2] && positionArrete[4] && positionArrete[5] && positionArrete[7] && positionArrete[8]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[1], coordLocalTriangles[2], coordLocalTriangles[3]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[1], coordLocalTriangles[2]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[1], coordLocalTriangles[4]));
                } else if (positionArrete[2] && positionArrete[6] && positionArrete[9] && positionArrete[10] && positionArrete[11] || positionArrete[3] && positionArrete[4] && positionArrete[5] && positionArrete[6] && positionArrete[9]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[3], coordLocalTriangles[2], coordLocalTriangles[4]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[3], coordLocalTriangles[4], coordLocalTriangles[1]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[1], coordLocalTriangles[0], coordLocalTriangles[4]));
                } else if (positionArrete[0] && positionArrete[1] && positionArrete[2] && positionArrete[4] && positionArrete[10] || positionArrete[0] && positionArrete[1] && positionArrete[2] && positionArrete[7] && positionArrete[9]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[1], coordLocalTriangles[4], coordLocalTriangles[3]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[3], coordLocalTriangles[1], coordLocalTriangles[0]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[2], coordLocalTriangles[1]));
                } else if (positionArrete[2] && positionArrete[4] && positionArrete[6] && positionArrete[7] && positionArrete[11]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[1], coordLocalTriangles[3], coordLocalTriangles[4]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[4], coordLocalTriangles[1], coordLocalTriangles[2]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[2], coordLocalTriangles[0], coordLocalTriangles[4]));
                } else if (positionArrete[1] && positionArrete[2] && positionArrete[3] && positionArrete[7] && positionArrete[11]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[2], coordLocalTriangles[3], coordLocalTriangles[0]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[1], coordLocalTriangles[3]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[3], coordLocalTriangles[4], coordLocalTriangles[1]));
                } else if (positionArrete[0] && positionArrete[2] && positionArrete[3] && positionArrete[5] && positionArrete[9] || positionArrete[0] && positionArrete[2] && positionArrete[3] && positionArrete[6] && positionArrete[10]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[1], coordLocalTriangles[3]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[3], coordLocalTriangles[0], coordLocalTriangles[4]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[4], coordLocalTriangles[2], coordLocalTriangles[0]));
                } else if (positionArrete[0] && positionArrete[1] && positionArrete[3] && positionArrete[5] && positionArrete[11]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[4], coordLocalTriangles[3]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[3], coordLocalTriangles[0], coordLocalTriangles[1]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[1], coordLocalTriangles[2], coordLocalTriangles[0]));
                } else if (positionArrete[1] && positionArrete[2] && positionArrete[3] && positionArrete[4] && positionArrete[8]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[2], coordLocalTriangles[3]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[3], coordLocalTriangles[4], coordLocalTriangles[0]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[1], coordLocalTriangles[4]));
                } else if (positionArrete[1] && positionArrete[4] && positionArrete[6] && positionArrete[7] && positionArrete[9] || positionArrete[0] && positionArrete[1] && positionArrete[3] && positionArrete[6] && positionArrete[8]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[2], coordLocalTriangles[1], coordLocalTriangles[0]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[4], coordLocalTriangles[1]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[1], coordLocalTriangles[3], coordLocalTriangles[4]));
                } else if (positionArrete[0] && positionArrete[5] && positionArrete[6] && positionArrete[7] && positionArrete[8]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[4], coordLocalTriangles[1]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[1], coordLocalTriangles[4], coordLocalTriangles[2]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[3], coordLocalTriangles[1]));
                } else if (positionArrete[3] && positionArrete[7] && positionArrete[8] && positionArrete[10] && positionArrete[11]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[3], coordLocalTriangles[2]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[2], coordLocalTriangles[0], coordLocalTriangles[4]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[4], coordLocalTriangles[1], coordLocalTriangles[0]));
                } else if (positionArrete[0] && positionArrete[7] && positionArrete[8] && positionArrete[9] && positionArrete[10]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[1], coordLocalTriangles[3]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[3], coordLocalTriangles[0], coordLocalTriangles[2]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[2], coordLocalTriangles[3], coordLocalTriangles[4]));
                } else if (positionArrete[0] && positionArrete[4] && positionArrete[5] && positionArrete[6] && positionArrete[11]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[3], coordLocalTriangles[0], coordLocalTriangles[2]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[2], coordLocalTriangles[4], coordLocalTriangles[0]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[1], coordLocalTriangles[3]));
                } else if (positionArrete[1] && positionArrete[4] && positionArrete[5] && positionArrete[7] && positionArrete[10]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[4], coordLocalTriangles[1], coordLocalTriangles[2]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[2], coordLocalTriangles[3], coordLocalTriangles[4]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[4], coordLocalTriangles[3], coordLocalTriangles[1]));
                } else if (positionArrete[1] && positionArrete[6] && positionArrete[8] && positionArrete[9] && positionArrete[11]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[4], coordLocalTriangles[1], coordLocalTriangles[2]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[1], coordLocalTriangles[4], coordLocalTriangles[0]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[3], coordLocalTriangles[4]));
                } else if (positionArrete[2] && positionArrete[5] && positionArrete[8] && positionArrete[9] && positionArrete[10]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[1], coordLocalTriangles[2]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[2], coordLocalTriangles[1], coordLocalTriangles[4]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[4], coordLocalTriangles[3], coordLocalTriangles[1]));
                } else if (positionArrete[3] && positionArrete[4] && positionArrete[8] && positionArrete[9] && positionArrete[11]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[1], coordLocalTriangles[2], coordLocalTriangles[4]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[4], coordLocalTriangles[3], coordLocalTriangles[1]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[1], coordLocalTriangles[3], coordLocalTriangles[0]));
                } else if (positionArrete[3] && positionArrete[4] && positionArrete[8] && positionArrete[9] && positionArrete[11]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[1], coordLocalTriangles[2], coordLocalTriangles[4]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[4], coordLocalTriangles[3], coordLocalTriangles[1]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[1], coordLocalTriangles[3], coordLocalTriangles[0]));
                } else if (positionArrete[1] && positionArrete[5] && positionArrete[8] && positionArrete[10] && positionArrete[11]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[4], coordLocalTriangles[2], coordLocalTriangles[1]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[1], coordLocalTriangles[2], coordLocalTriangles[0]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[2], coordLocalTriangles[3]));
                }
            } else if (nbPoints == 6) {
                if (positionArrete[2] && positionArrete[3] && positionArrete[6] && positionArrete[7] && positionArrete[10] && positionArrete[11]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[1], coordLocalTriangles[3], coordLocalTriangles[4]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[4], coordLocalTriangles[2], coordLocalTriangles[3]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[3], coordLocalTriangles[5], coordLocalTriangles[2]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[2], coordLocalTriangles[0], coordLocalTriangles[5]));
                } else if (positionArrete[2] && positionArrete[3] && positionArrete[4] && positionArrete[5] && positionArrete[8] && positionArrete[9]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[1], coordLocalTriangles[5], coordLocalTriangles[3]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[3], coordLocalTriangles[1], coordLocalTriangles[2]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[2], coordLocalTriangles[4], coordLocalTriangles[3]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[3], coordLocalTriangles[0], coordLocalTriangles[4]));
                } else if (positionArrete[0] && positionArrete[1] && positionArrete[4] && positionArrete[5] && positionArrete[10] && positionArrete[11]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[5], coordLocalTriangles[3]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[3], coordLocalTriangles[0], coordLocalTriangles[1]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[1], coordLocalTriangles[0], coordLocalTriangles[2]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[2], coordLocalTriangles[4], coordLocalTriangles[1]));
                } else if (positionArrete[0] && positionArrete[1] && positionArrete[6] && positionArrete[7] && positionArrete[8] && positionArrete[9]) {
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[0], coordLocalTriangles[4], coordLocalTriangles[2]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[2], coordLocalTriangles[0], coordLocalTriangles[3]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[3], coordLocalTriangles[2], coordLocalTriangles[1]));
                    this.planSVM.add(this.addTriangle(coordLocalTriangles[1], coordLocalTriangles[5], coordLocalTriangles[3]));
                }
            }
        });
    }

    private XForm addTriangle(float[] lc1, float[] lc2, float[] lc3) {
        XForm triangle = this.jp3d.addTriangle(lc1, lc2, lc3, this.pf.getPlaneMaterial());
        return triangle;
    }

    private void effacerPlanSVM() {
        for (XForm triangle : this.planSVM) {
            this.jp3d.removeObject(triangle);
        }
    }

    @Override
    public void rescaleSpace(float scale) {
    }

    @Override
    public void rescalePrimitives(float scale) {
        Platform.runLater(() -> {
            RichObjectJFX[] richObjectJFXArray = this.primArray;
            int n = this.primArray.length;
            int n2 = 0;
            while (n2 < n) {
                RichObjectJFX prim = richObjectJFXArray[n2];
                prim.getPrimitive().setScaleX((double)scale);
                prim.getPrimitive().setScaleY((double)scale);
                prim.getPrimitive().setScaleZ((double)scale);
                ++n2;
            }
        });
    }

    @Override
    public void recomputeLocalCoords() {
        float[][] dat3D = this.proj.getCoordinates();
        this.loccoord = new LocalCoord(dat3D, this.param.getNormalize(), this.param.getCentre());
        this.lc = this.loccoord.getLocCoord(dat3D);
        int i = 0;
        while (i < this.lc.length) {
            this.primArray[i].setCoordinates(this.lc[i]);
            ++i;
        }
    }

    @Override
    public void addClusterEllipsoid(float[][] points) {
        this.addClusterEllipsoid(points, 0);
    }

    @Override
    public void addClusterEllipsoid(float[][] points, int colorRank) {
        float[] centr = OutilsAlgebre.barycenter(points);
        float[][] axes = OutilsAlgebre.mainAxes(points);
        float dim1 = OutilsAlgebre.meanDistancePlusVarianceSqrtToCenterAlongAxes(points, axes[0]);
        float dim2 = OutilsAlgebre.meanDistancePlusVarianceSqrtToCenterAlongAxes(points, axes[1]);
        float dim3 = OutilsAlgebre.meanDistancePlusVarianceSqrtToCenterAlongAxes(points, axes[2]);
        Platform.runLater(() -> this.ellipsesClassification.add(this.jp3d.addEllipse(centr, axes, dim1, dim2, dim3, (Material)this.pf.getTranslucentAppearance(colorRank))));
    }

    @Override
    public void removeClusterEllipsoids() {
        Platform.runLater(() -> {
            for (XForm ellipse : this.ellipsesClassification) {
                this.jp3d.removeObject(ellipse);
            }
        });
    }

    @Override
    public void showDimensionArrows(Point3D depart, Point3D destination, String nomFleche) {
    }

    @Override
    public void hideDimensionArrows() {
    }

    @Override
    public void dropAllLabels() {
    }

    @Override
    public void recolor() {
        if (this.param.isMulticlass()) {
            Source src = this.pm.getSource();
            int[] mc = this.param.getMulticlass();
            int i = 0;
            while (i < this.primArray.length) {
                int idx = src.getRealIndex(i);
                float domVal = this.data.elementAt(mc[0], idx);
                int domIndex = 0;
                int index = 1;
                while (index < mc.length) {
                    if (this.data.elementAt(mc[index], idx) > domVal) {
                        domIndex = index;
                        domVal = this.data.elementAt(mc[index], idx);
                    }
                    ++index;
                }
                this.jp3d.setColor(this.primArray[i].getPrimitive(), this.pf.getTabColor()[domIndex]);
                ++i;
            }
        } else if (this.param.getColorCol() == -1 || this.data.getNbAtt() <= this.param.getColorCol()) {
            int i = 0;
            while (i < this.primArray.length) {
                this.jp3d.setColor(this.primArray[i].getPrimitive(), this.pf.getDefaultColor());
                ++i;
            }
        } else {
            Source src = this.pm.getSource();
            if (this.data.isSymbolicAttribute(this.param.getColorCol())) {
                int i = 0;
                while (i < this.primArray.length) {
                    int color = this.data.getColorIndice(src.getRealIndex(i));
                    this.setObjectColor(i, color);
                    ++i;
                }
            } else {
                float[] values = this.data.getColorValues();
                int i = 0;
                while (i < this.primArray.length) {
                    this.setObjectColor(i, values[src.getRealIndex(i)]);
                    ++i;
                }
            }
        }
        this.setSelectStates();
    }

    @Override
    public void updatePrimShapes() {
        Source src = this.pm.getSource();
        boolean formcol = this.param.getFormCol() != -1 && this.data.getNbAtt() > this.param.getFormCol();
        boolean colorcol = this.param.getColorCol() != -1 && this.data.getNbAtt() > this.param.getColorCol();
        boolean symbCol = colorcol && this.data.isSymbolicAttribute(this.param.getColorCol());
        Platform.runLater(() -> {
            int form = 3;
            int color = -1;
            PhongMaterial app = this.pf.getDefaultAppearance(false);
            int elemCount = 0;
            while (elemCount < this.primArray.length) {
                int ri = src.getRealIndex(elemCount);
                if (formcol) {
                    form = this.data.getFormIndice(ri);
                }
                if (colorcol) {
                    app = symbCol ? this.pf.getAppearance(this.data.getColorIndice(ri), false) : this.pf.getAppearance(this.data.getColorValue(ri));
                }
                XForm trans = new XForm();
                trans.setTranslate(this.lc[elemCount][0], -this.lc[elemCount][1], -this.lc[elemCount][2]);
                XForm former = this.primArray[elemCount].getRepresentation3D();
                this.primArray[elemCount].setPrimitive(this.addPrimitive(trans, form, (Material)app, this.objectSize));
                this.jp3d.removeObject(former);
                ++elemCount;
            }
        });
    }

    @Override
    public void updateLabels() {
        Source src = this.pm.getSource();
        int i = 0;
        while (i < this.primArray.length) {
            String label = this.param.getLabelCol() != -1 ? (String)this.data.getLabelValue(src.getRealIndex(i)) : "" + src.getRealIndex(i);
            this.setLabel(i, label);
            ++i;
        }
    }

    @Override
    public void resetView() {
        this.jp3d.resetView();
    }

    @Override
    public int surroundGroup(int index, int form) {
        if (form != 1 && form != 0) {
            return -1;
        }
        LinkedList<float[]> points = new LinkedList<float[]>();
        ArrayList<Integer> realpoints = new ArrayList<Integer>();
        Source src = this.pm.getSource();
        int i = 0;
        while (i < this.lc.length) {
            int ri = src.getRealIndex(i);
            if (index == this.data.getColorIndice(ri)) {
                points.add(this.lc[i]);
                realpoints.add(i);
            }
            ++i;
        }
        if (points.size() == 0) {
            return -1;
        }
        System.out.println(points.size());
        XForm fake = new XForm();
        this.surroundingObjects.add(fake);
        int resIndex = this.surroundingObjects.indexOf((Object)fake);
        Platform.runLater(() -> {
            float[][] f = new float[points.size()][3];
            points.toArray((T[])f);
            int allIdx = 0;
            if (form == 0) {
                float[] center = OutilsAlgebre.barycenter(f);
                float[][] axes = OutilsAlgebre.mainAxes(f);
                float dim1 = OutilsAlgebre.meanDistancePlusVarianceSqrtToCenterAlongAxes(f, axes[0]);
                float dim2 = OutilsAlgebre.meanDistancePlusVarianceSqrtToCenterAlongAxes(f, axes[1]);
                float dim3 = OutilsAlgebre.meanDistancePlusVarianceSqrtToCenterAlongAxes(f, axes[2]);
                allIdx = this.addEllipsoid(center, axes, dim1, dim2, dim3, (Material)this.pf.getTranslucentAppearance(index));
            } else if (form == 1) {
                Envelope3D env3d = new Envelope3D(f);
                int[][] envelope = env3d.getConvexEnvelope();
                int i = 0;
                while (i < envelope.length) {
                    envelope[i][0] = (Integer)realpoints.get(envelope[i][0]);
                    envelope[i][1] = (Integer)realpoints.get(envelope[i][1]);
                    envelope[i][2] = (Integer)realpoints.get(envelope[i][2]);
                    ++i;
                }
                allIdx = this.addPolyedron(envelope, index);
            }
            XForm xf = this.allObjects.set(allIdx, null);
            this.surroundingObjects.set(resIndex, xf);
        });
        return resIndex;
    }

    @Override
    public int surroundGroup(int index, int form, float threshold) {
        ArrayList<float[]> points = new ArrayList<float[]>();
        ArrayList<Integer> realpoints = new ArrayList<Integer>();
        int[] mc = this.param.getMulticlass();
        int i = 0;
        while (i < this.lc.length) {
            if (this.data.elementAt(mc[index], i) > threshold) {
                points.add(this.lc[i]);
                realpoints.add(i);
            }
            ++i;
        }
        if (points.size() == 0) {
            return -1;
        }
        float[][] f = new float[points.size()][3];
        points.toArray((T[])f);
        if (form == 0) {
            float[] center = OutilsAlgebre.barycenter(f);
            float[][] axes = OutilsAlgebre.mainAxes(f);
            return this.addEllipsoid(center, axes[0], axes[1], axes[2], (Material)this.pf.getTranslucentAppearance(index));
        }
        if (form == 1) {
            Envelope3D env3d = new Envelope3D(f);
            int[][] envelope = env3d.getConvexEnvelope();
            int i2 = 0;
            while (i2 < envelope.length) {
                envelope[i2][0] = (Integer)realpoints.get(envelope[i2][0]);
                envelope[i2][1] = (Integer)realpoints.get(envelope[i2][1]);
                envelope[i2][2] = (Integer)realpoints.get(envelope[i2][2]);
                ++i2;
            }
            return this.addPolyedron(envelope, index);
        }
        return -1;
    }

    @Override
    public int drawCenter(int cat) {
        return 0;
    }

    @Override
    public void removeTree() {
    }

    @Override
    public boolean isTreeVisible() {
        return false;
    }

    @Override
    public void stopCamera() {
    }

    @Override
    public void startCamera() {
    }

    @Override
    public void setGroupColor(int rank, Color col) {
        super.setGroupColor(rank, col);
        this.parent.getTMalPlaces().recoloreMalPlaces();
    }

    @Override
    public void remove() {
        ViewManager.getSingleton().removeView(this);
        DisplayParametersObserver.getSingleton().deleteDisplay(this);
        super.remove();
    }

    @Override
    public void clicLeft(Object n) {
        int index = this.indexPrimArray(n);
        if (index != -1) {
            this.clico.notifyObservers(index);
        }
    }

    private void setSelectStates() {
        boolean[] selected = this.cs.getSelectStates();
        int i = 0;
        while (i < this.primArray.length) {
            if (selected[this.pm.getSource().getRealIndex(i)]) {
                this.objectSelected(i, true);
            }
            ++i;
        }
    }

    @Override
    protected void objectSelected(int index, boolean isSelected) {
        super.objectSelected(index, isSelected);
    }

    protected void createScene(float[][] dat3D) {
        int nbelem = dat3D.length;
        int nbstep = 10;
        int stepwidth = nbelem >= 100 ? nbelem / nbstep : 10;
        this.objectSize = this.parent.getObjectScale();
        this.jp3d.setShine(nbelem);
        boolean formcol = this.param.getFormCol() != -1 && this.data.getNbAtt() > this.param.getFormCol();
        boolean colorcol = this.param.getColorCol() != -1 && this.data.getNbAtt() > this.param.getColorCol();
        boolean symbCol = colorcol && this.data.isSymbolicAttribute(this.param.getColorCol());
        int form = 3;
        PhongMaterial app = this.pf.getDefaultAppearance(false);
        Source src = this.pm.getSource();
        int modulo = dat3D.length >= 100 ? nbelem / 100 : 10;
        this.setBackground();
        this.setAxes();
        this.loccoord = new LocalCoord(dat3D, this.param.getNormalize(), this.param.getCentre());
        this.lc = this.loccoord.getLocCoord(dat3D);
        this.primArray = new RichObjectJFX[nbelem];
        this.parent.subtaskSetOn(Messages.getString("pgbar_createscene"), nbelem);
        this.parent.subtaskSetMinMax(0, nbelem);
        int elemCount = 0;
        while (elemCount < nbelem) {
            XForm trans = new XForm();
            trans.setTranslate(this.lc[elemCount][0], -this.lc[elemCount][1], -this.lc[elemCount][2]);
            int ri = src.getRealIndex(elemCount);
            if (formcol) {
                form = this.data.getFormIndice(ri);
            }
            if (colorcol) {
                app = symbCol ? this.pf.getAppearance(this.data.getColorIndice(ri), false) : this.pf.getAppearance(this.data.getColorValue(ri));
            }
            this.primArray[elemCount] = new RichObjectJFX(this.addPrimitive(trans, form, (Material)app, this.objectSize));
            if (elemCount % modulo == 0) {
                this.parent.subtaskSetVal(elemCount);
            }
            ++elemCount;
        }
        this.parent.subtaskSetOff();
    }

    @Override
    public void setXYWH(int x, int y, int width, int height) {
        Platform.runLater(() -> {
            this.stage3d.setX(x);
            this.stage3d.setY(y);
            this.stage3d.setWidth(width);
            this.stage3d.setHeight(height - 30);
        });
    }

    @Override
    public Stage getStage() {
        return this.stage3d;
    }

    @Override
    public Color getObjectColor(int rank) {
        return ((PhongMaterial)this.primArray[rank].getPrimitive().getMaterial()).getDiffuseColor();
    }

    class D3DFocusListener
    implements ChangeListener<Boolean> {
        private GView parent;
        private boolean cancel = false;

        public D3DFocusListener(GView p) {
            this.parent = p;
        }

        public void cancelFocus() {
            this.cancel = true;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                if (this.cancel) {
                    this.cancel = false;
                } else {
                    ViewManager.getSingleton().setActiveView(this.parent);
                }
            }
        }
    }
}

