/*
 * Decompiled with CFR 0.152.
 */
package explorer.parser;

import explorer.data.VisuPrimitives;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class primitiveParser {
    public static int numero;

    public static VisuPrimitives parseScene(String nomFichier, int numeroScene) throws IOException {
        VisuPrimitives vp = new VisuPrimitives();
        BufferedReader br = null;
        String line = "";
        try {
            br = new BufferedReader(new FileReader(new File(nomFichier)));
        }
        catch (FileNotFoundException fe) {
            fe.printStackTrace();
        }
        numero = 0;
        do {
            ++numero;
        } while (!(line = br.readLine()).equals("scene " + numeroScene));
        while (!(line = br.readLine()).startsWith("scene ")) {
            if (line.length() <= 1 || line.startsWith("#")) continue;
            primitiveParser.parseExpression(line, vp);
        }
        try {
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return vp;
    }

    public static void parseExpression(String expression, VisuPrimitives vp) {
        String nomMethode = "";
        String arguments = "";
        try {
            nomMethode = expression.substring(0, expression.indexOf("("));
            arguments = expression.substring(nomMethode.length() + 1, expression.length() - 1);
            if (nomMethode.equals("couleur_objet")) {
                primitiveParser.parseCouleurObjet(vp, arguments);
            }
            if (nomMethode.equals("ajouter_cube")) {
                primitiveParser.parseAjouterCube(vp, arguments);
            }
            if (nomMethode.equals("ajouter_cone")) {
                primitiveParser.parseAjouterCone(vp, arguments);
            }
            if (nomMethode.equals("ajouter_cone2")) {
                primitiveParser.parseAjouterCone2(vp, arguments);
            }
            if (nomMethode.equals("ajouter_cylindre")) {
                primitiveParser.parseAjouterCylindre(vp, arguments);
            }
            if (nomMethode.equals("ajouter_ellipse")) {
                primitiveParser.parseAjouterEllipse(vp, arguments);
            }
            if (nomMethode.equals("ajouter_sphere")) {
                primitiveParser.parseAjouterSphere(vp, arguments);
            }
            if (nomMethode.equals("ajouter_texte")) {
                primitiveParser.parseAjouterTexte(vp, arguments);
            }
            if (nomMethode.equals("ajouter_ligne")) {
                primitiveParser.parseAjouterLigne(vp, arguments);
            }
        }
        catch (Exception e) {
            System.out.println(String.valueOf(expression) + " n'est pas un nom de m\u00e9thode autoris\u00e9e (l." + numero + ")");
        }
    }

    public static void parseCouleurObjet(VisuPrimitives vp, String arguments) {
        StringTokenizer str = new StringTokenizer(arguments, ",");
        int numero = Integer.parseInt(str.nextToken());
        int rouge = Integer.parseInt(str.nextToken());
        int vert = Integer.parseInt(str.nextToken());
        int bleu = Integer.parseInt(str.nextToken());
        vp.addColoration(numero, (float)rouge / 255.0f, (float)vert / 255.0f, (float)bleu / 255.0f);
    }

    public static void parseAjouterCube(VisuPrimitives vp, String arguments) {
        StringTokenizer str = new StringTokenizer(arguments, ",");
        try {
            float[] pt = primitiveParser.getCoordonnees(str, str.countTokens() - 1);
            float taille = Float.parseFloat(str.nextToken());
            vp.addCube(pt, taille);
        }
        catch (Exception e) {
            System.out.println("Syntaxe : ajouter_cube(x1,...,xn,taille)");
        }
    }

    public static void parseAjouterCone(VisuPrimitives vp, String arguments) {
        StringTokenizer str = new StringTokenizer(arguments, ",");
        try {
            float[] pt = primitiveParser.getCoordonnees(str, str.countTokens() - 1);
            float taille = Float.parseFloat(str.nextToken());
            vp.addCone(pt, taille);
        }
        catch (Exception e) {
            System.out.println("Syntaxe : ajouter_cone(x1,...,xn,taille)");
        }
    }

    public static void parseAjouterCylindre(VisuPrimitives vp, String arguments) {
        StringTokenizer str = new StringTokenizer(arguments, ",");
        try {
            float[] pt = primitiveParser.getCoordonnees(str, str.countTokens() - 1);
            float taille = Float.parseFloat(str.nextToken());
            vp.addCylindre(pt, taille);
        }
        catch (Exception e) {
            System.out.println("Syntaxe : ajouter_cylindre(x1,...,xn,taille)");
        }
    }

    public static void parseAjouterSphere(VisuPrimitives vp, String arguments) {
        StringTokenizer str = new StringTokenizer(arguments, ",");
        try {
            float[] pt = primitiveParser.getCoordonnees(str, str.countTokens() - 1);
            float taille = Float.parseFloat(str.nextToken());
            vp.addSphere(pt, taille);
        }
        catch (Exception e) {
            System.out.println("Syntaxe : ajouter_sphere(x1,...,xn,taille)");
        }
    }

    public static void parseAjouterTexte(VisuPrimitives vp, String arguments) {
        StringTokenizer str = new StringTokenizer(arguments, ",");
        try {
            float[] pt = primitiveParser.getCoordonnees(str, str.countTokens() - 1);
            String taille = str.nextToken();
            vp.addTexte(pt, taille);
        }
        catch (Exception e) {
            System.out.println("Syntaxe : ajouter_texte(x1,...,xn,texte)");
        }
    }

    public static void parseAjouterEllipse(VisuPrimitives vp, String arguments) {
        StringTokenizer str = new StringTokenizer(arguments, ",");
        try {
            float[] centre = primitiveParser.getCoordonnees(str, str.countTokens() / 3);
            float[] axe1 = primitiveParser.getCoordonnees(str, centre.length);
            float[] axe2 = primitiveParser.getCoordonnees(str, centre.length);
            vp.addEllipse(centre, axe1, axe2);
        }
        catch (Exception e) {
            System.out.println("Syntaxe : ajouter_ellipse(x1,...,xn,x'1,...,x'n,x\"1,...,x\"n,taille) o\u00f9 x est le centre, x' l'axe principal et x\"le second axe");
        }
    }

    public static void parseAjouterLigne(VisuPrimitives vp, String arguments) {
        StringTokenizer str = new StringTokenizer(arguments, ",");
        try {
            float[] dep = primitiveParser.getCoordonnees(str, str.countTokens() / 2);
            float[] dest = primitiveParser.getCoordonnees(str, dep.length);
            vp.addLigne(dep, dest);
        }
        catch (Exception e) {
            System.out.println("Syntaxe : ajouter_ligne(x1,...,xn,x'1,...,x'n,taille) o\u00f9 x est le point de d\u00e9part et x' la destination");
        }
    }

    public static void parseAjouterCone2(VisuPrimitives vp, String arguments) {
        StringTokenizer str = new StringTokenizer(arguments, ",");
        try {
            float[] ptDep = primitiveParser.getCoordonnees(str, (str.countTokens() - 1) / 2);
            float[] ptDest = primitiveParser.getCoordonnees(str, ptDep.length);
            float taille = Float.parseFloat(str.nextToken());
            vp.addCone(ptDep, ptDest, taille);
        }
        catch (Exception e) {
            System.out.println("Syntaxe : ajouter_cone2(x1,...,xn,x'1,...,x'n, taille) o\u00f9 x est le d\u00e9part et x' la cible");
        }
    }

    public static float[] getCoordonnees(StringTokenizer str, int nbDims) {
        float[] point = new float[nbDims];
        int i = 0;
        while (i < nbDims) {
            point[i] = Float.parseFloat(str.nextToken());
            ++i;
        }
        return point;
    }
}

