/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.icview;

import explorer.compute.tools.OutilsCropSphere;
import explorer.data.SphereParameters;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lib3d4j.international.Messages;

public class ICVCropSphere
extends JPanel
implements SphereParameters {
    private Container cont;
    protected JButton btnCancel;
    protected JButton btnCrop;
    protected JButton btnUnCrop;
    protected JSlider jsRadius;
    protected int defaultRadius = 5;
    private JPCSChangeListener lcl = null;
    private JPCSMouseClick mlc = null;
    private boolean sclOn = true;
    private OutilsCropSphere parent = null;

    public ICVCropSphere(Container cont) {
        this.cont = cont;
        this.lcl = new JPCSChangeListener();
        this.mlc = new JPCSMouseClick();
        this.setLayout(new GridLayout(0, 1, 5, 5));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.btnCancel = new JButton(Messages.getString("tpgcrop_cancel"));
        this.btnCancel.setBackground(this.getBackground());
        this.btnCancel.addMouseListener(this.mlc);
        this.add(this.btnCancel);
        this.btnCrop = new JButton(Messages.getString("tpgcrop_crop"));
        this.btnCrop.setBackground(this.getBackground());
        this.btnCrop.addMouseListener(this.mlc);
        this.add(this.btnCrop);
        this.btnUnCrop = new JButton(Messages.getString("tpgcrop_uncrop"));
        this.btnUnCrop.setBackground(this.getBackground());
        this.btnUnCrop.addMouseListener(this.mlc);
        this.btnUnCrop.setEnabled(false);
        this.add(this.btnUnCrop);
        JLabel lJC = new JLabel(String.valueOf(Messages.getString("tpgcrop_radius")) + ":");
        lJC.setBackground(this.getBackground());
        this.add(lJC);
        this.jsRadius = new JSlider(1, 100, this.defaultRadius);
        this.jsRadius.setBackground(this.getBackground());
        this.jsRadius.addChangeListener(this.lcl);
        this.jsRadius.addMouseListener(this.mlc);
        this.add(this.jsRadius);
    }

    @Override
    public void setParent(OutilsCropSphere parent) {
        this.parent = parent;
    }

    @Override
    public int getRadius() {
        return this.jsRadius.getValue();
    }

    @Override
    public void setRadius(int radius) {
        this.jsRadius.setValue(radius);
    }

    public void setSlidersChangeListener(boolean state) {
        this.sclOn = state;
    }

    public boolean isSclOn() {
        return this.sclOn;
    }

    @Override
    public int getDefaultRadius() {
        return this.defaultRadius;
    }

    class JPCSChangeListener
    implements ChangeListener {
        JPCSChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (ICVCropSphere.this.isSclOn()) {
                ICVCropSphere.this.parent.resizeCrop();
            }
        }
    }

    class JPCSMouseClick
    extends MouseAdapter {
        JPCSMouseClick() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object sender = e.getSource();
            if (sender == ICVCropSphere.this.btnCancel) {
                ICVCropSphere.this.parent.effacerCrop();
            } else if (sender == ICVCropSphere.this.btnCrop) {
                ICVCropSphere.this.parent.appliquerCrop();
                ICVCropSphere.this.cont.setVisible(false);
            } else if (sender != ICVCropSphere.this.btnUnCrop && sender == ICVCropSphere.this.jsRadius && e.getButton() == 3) {
                ICVCropSphere.this.jsRadius.setValue(ICVCropSphere.this.defaultRadius);
            }
        }
    }
}

