/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.icview;

import explorer.compute.compute.projection.BasicProjection;
import explorer.compute.tools.CurrentAxesTool;
import explorer.data.ViewManager;
import explorer.data.ViewObserver;
import explorer.windows.w2D.SwingUtils;
import explorer.windows.w2D.utils.GView;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lib3d4j.international.Messages;

public class ICVCurrentAxes
extends JPanel
implements ViewObserver {
    private static int OFFSET = 1;
    protected JCheckBox cbNorm;
    protected JCheckBox cbCentre;
    protected JButton btnRedraw;
    protected JSpinner couleurs;
    protected JCheckBox usecolors;
    private JSpinner[] jsDims;
    private CurrentAxesTool tool;
    private ColorListener cl;

    public ICVCurrentAxes(CurrentAxesTool t) {
        this.setName(Messages.getString("tpgvarrep_title"));
        this.setLayout(new BoxLayout(this, 1));
        this.cbNorm = new JCheckBox(Messages.getString("tpgvarrep_few"), false);
        this.cbNorm.setBackground(this.getBackground());
        this.cbNorm.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ICVCurrentAxes.this.tool.normalizationChanged(ICVCurrentAxes.this.cbNorm.isSelected());
            }
        });
        this.add(this.cbNorm);
        this.cbCentre = new JCheckBox(Messages.getString("tpgvarrep_center"), false);
        this.cbCentre.setBackground(this.getBackground());
        this.cbCentre.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ICVCurrentAxes.this.tool.centerChanged(ICVCurrentAxes.this.cbCentre.isSelected());
            }
        });
        this.add(this.cbCentre);
        JPanel jpDims = new JPanel();
        jpDims.setLayout(new FlowLayout());
        this.jsDims = new JSpinner[3];
        int i = 0;
        while (i < 3) {
            this.jsDims[i] = new JSpinner();
            jpDims.add(this.jsDims[i]);
            ++i;
        }
        this.btnRedraw = new JButton(Messages.getString("draw"));
        this.btnRedraw.setBackground(this.getBackground());
        this.btnRedraw.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ICVCurrentAxes.this.tool.projectionChanged();
            }
        });
        jpDims.add(this.btnRedraw);
        this.add(jpDims);
        JPanel jpColors = new JPanel();
        jpColors.setLayout(new FlowLayout());
        this.cl = new ColorListener();
        this.usecolors = new JCheckBox(Messages.getString("color_dimension_parameter"), false);
        this.usecolors.setHorizontalTextPosition(2);
        this.usecolors.addActionListener(this.cl);
        jpColors.add(this.usecolors);
        this.couleurs = new JSpinner();
        this.couleurs.addChangeListener(this.cl);
        jpColors.add(this.couleurs);
        this.add(jpColors);
        SwingUtils.alignX(this, 0.0f);
        this.recursiveSetEnabled(this, false);
        ViewManager.getSingleton().addViewObserver(this);
        this.tool = t;
        t.setView(this);
    }

    public boolean isColorSet() {
        return this.usecolors.isSelected();
    }

    public int getColorIndice() {
        return Integer.parseInt(this.couleurs.getValue().toString()) - OFFSET;
    }

    public boolean isNorm() {
        return this.cbNorm.isSelected();
    }

    public boolean isCentre() {
        return this.cbCentre.isSelected();
    }

    public int[] getProjectionAxes() {
        int[] res = new int[3];
        int i = 0;
        while (i < 3) {
            String s = this.jsDims[i].getValue().toString();
            res[i] = s.equals("X") ? -1 : Integer.parseInt(s) - OFFSET;
            ++i;
        }
        return res;
    }

    private void manageColors() {
        this.tool.colorChanged();
    }

    @Override
    public void activeViewChanged(GView v) {
        if (v == null) {
            this.recursiveSetEnabled(this, false);
        } else if (v.getProjection() instanceof BasicProjection) {
            int max = v.getProjectiveMethod().getNbDimensions();
            int[] axes = ((BasicProjection)v.getProjection()).getAxes();
            Object[] vals = new String[max + 1];
            vals[0] = "X";
            int i = 0;
            while (i < max) {
                vals[i + 1] = "" + (i + OFFSET);
                ++i;
            }
            i = 0;
            while (i < 3) {
                SpinnerListModel s = new SpinnerListModel(vals);
                if (axes[i] != -1) {
                    s.setValue(vals[axes[i] + 1]);
                }
                this.jsDims[i].setModel(s);
                ++i;
            }
            int defaultValue = OFFSET;
            this.couleurs.removeChangeListener(this.cl);
            this.usecolors.removeActionListener(this.cl);
            if (this.tool.isColorAxisDisplay(v)) {
                defaultValue = this.tool.getColorAxisRank() + OFFSET;
                this.usecolors.setSelected(true);
            } else {
                this.usecolors.setSelected(false);
            }
            this.couleurs.setModel(new SpinnerNumberModel(defaultValue, OFFSET, max, 1));
            this.couleurs.addChangeListener(this.cl);
            this.usecolors.addActionListener(this.cl);
            this.recursiveSetEnabled(this, true);
        }
    }

    private void recursiveSetEnabled(Component c, boolean enabled) {
        c.setEnabled(enabled);
        if (c instanceof Container) {
            Component[] componentArray = ((Container)c).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component subc = componentArray[n2];
                this.recursiveSetEnabled(subc, enabled);
                ++n2;
            }
        }
    }

    private class ColorListener
    implements ActionListener,
    ChangeListener {
        private ColorListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ICVCurrentAxes.this.manageColors();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ICVCurrentAxes.this.manageColors();
        }
    }
}

