/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.icview;

import explorer.compute.tools.OutilSVM;
import explorer.data.DataManager;
import explorer.data.DatasetParamsExplorer;
import explorer.windows.w2D.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lib3d4j.international.Messages;

public class ICVSVMDisplayMode
extends JPanel
implements Observer {
    protected JLabel jlDisplayMode;
    protected JLabel jlProjectiveMethod;
    protected JLabel jlSVMComputeMode;
    protected JComboBox jcbDisplayMode;
    protected JComboBox jcbSVMComputeMode;
    private Vector<String> displayModeList;
    private Vector<String> SVMComputeModeList;
    protected JButton jbDisplay;
    protected OutilSVM parent;
    protected boolean isSelectedKernel = false;
    private DatasetParamsExplorer params;

    public ICVSVMDisplayMode(OutilSVM osvm) {
        this.parent = osvm;
        this.parent.setTpgSvmDisplayMode(this);
        this.setName(Messages.getString("tpgsvmDisplayMode_title"));
        this.setLayout(new BoxLayout(this, 1));
        this.jlSVMComputeMode = new JLabel(Messages.getString("tpgsvmDisplayMode_mode_calcule_svm"));
        this.add(this.jlSVMComputeMode);
        this.SVMComputeModeList = new Vector();
        this.SVMComputeModeList.add(Messages.getString("tpgsvmDisplayMode_svm_donnees_brute"));
        this.SVMComputeModeList.add(Messages.getString("tpgsvmDisplayMode_svm_donnees_projectees"));
        TPGSVMMouseAdapter ma = new TPGSVMMouseAdapter();
        this.jcbSVMComputeMode = new JComboBox<String>(this.SVMComputeModeList);
        this.jcbSVMComputeMode.addMouseListener(ma);
        this.add(this.jcbSVMComputeMode);
        this.jlDisplayMode = new JLabel(Messages.getString("tpgsvmDisplayMode_affichage"));
        this.add(this.jlDisplayMode);
        this.displayModeList = new Vector();
        this.displayModeList.add(Messages.getString("tpgsvmDisplayMode_plan"));
        this.displayModeList.add(Messages.getString("tpgsvmDisplayMode_coloration"));
        this.displayModeList.add(Messages.getString("tpgsvmDisplayMode_3eme_axe"));
        this.displayModeList.add(Messages.getString("tpgsvmDisplayMode_redescription_1_N"));
        this.jcbDisplayMode = new JComboBox<String>(this.displayModeList);
        this.jcbDisplayMode.setSelectedIndex(0);
        this.jcbDisplayMode.addMouseListener(ma);
        this.add(this.jcbDisplayMode);
        this.jbDisplay = new JButton(Messages.getString("draw"));
        this.jbDisplay.setBackground(this.getBackground());
        this.jbDisplay.addMouseListener(ma);
        this.add(this.jbDisplay);
        SwingUtils.alignX(this, 0.0f);
        this.params = DataManager.getSingleton().getParams();
        this.params.addObserver(this);
        this.checkRelevancy();
    }

    @Override
    public void update(Observable o, Object arg) {
        int col;
        if (o instanceof DatasetParamsExplorer && arg != null && arg instanceof Integer && (((col = ((Integer)arg).intValue()) & 2) != 0 || (col & 0x40) != 0)) {
            this.checkRelevancy();
        }
    }

    private void checkRelevancy() {
        this.setEnabled(!this.params.isMultiClassActive() && this.params.isSetClassCol());
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            this.recursiveSetEnabled(c, enabled);
            ++n2;
        }
    }

    private void recursiveSetEnabled(Component c, boolean b) {
        c.setEnabled(b);
        if (c instanceof Container) {
            Component[] componentArray = ((Container)c).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component sub = componentArray[n2];
                this.recursiveSetEnabled(sub, b);
                ++n2;
            }
        }
    }

    public int getSVMComputeModeIndex() {
        return this.jcbSVMComputeMode.getSelectedIndex();
    }

    public int getDisplayModeIndex() {
        return this.jcbDisplayMode.getSelectedIndex();
    }

    public void setIsSelectedKernel(boolean isKernel) {
        this.isSelectedKernel = isKernel;
    }

    public boolean getIsSelectedKernel() {
        return this.isSelectedKernel;
    }

    class TPGSVMMouseAdapter
    extends MouseAdapter {
        TPGSVMMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object sender = e.getSource();
            if (sender != ICVSVMDisplayMode.this.jcbSVMComputeMode && sender != ICVSVMDisplayMode.this.jcbDisplayMode && sender == ICVSVMDisplayMode.this.jbDisplay) {
                ICVSVMDisplayMode.this.parent.afficher();
            }
        }
    }
}

