/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.icview;

import explorer.compute.compute.projection.Projection;
import explorer.compute.compute.projection.ProjectiveMethod;
import explorer.data.DataManager;
import explorer.data.ViewManager;
import explorer.windows.w2D.utils.GView;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import lib3d4j.data.Source;
import lib3d4j.international.Messages;

public class ICVViewExplorer
extends JPanel {
    private JTree jt = null;
    private Map<GView, DefaultMutableTreeNode> viewmap = null;
    private Map<Projection, DefaultMutableTreeNode> pmap = null;
    private Map<ProjectiveMethod, DefaultMutableTreeNode> pmmap = null;
    private Map<Source, DefaultMutableTreeNode> srcmap = null;
    private DefaultMutableTreeNode rootNode = null;
    private DefaultTreeModel tm = null;
    private JScrollPane jsp = null;
    private TPGVETreeSelectionListener listener;

    public ICVViewExplorer() {
        this.setName(Messages.getString("viewexplorer_title"));
        this.viewmap = new HashMap<GView, DefaultMutableTreeNode>();
        this.pmap = new HashMap<Projection, DefaultMutableTreeNode>();
        this.pmmap = new HashMap<ProjectiveMethod, DefaultMutableTreeNode>();
        this.srcmap = new HashMap<Source, DefaultMutableTreeNode>();
        this.createTree();
        ViewManager.getSingleton().setExplorer(this);
        DataManager.getSingleton().setExplorer(this);
    }

    private void createTree() {
        this.listener = new TPGVETreeSelectionListener();
        this.rootNode = new DefaultMutableTreeNode();
        this.tm = new DefaultTreeModel(this.rootNode);
        this.jt = new JTree(this.tm);
        this.jt.addTreeSelectionListener(this.listener);
        this.jsp = new JScrollPane(this.jt, 22, 30);
        this.jsp.setPreferredSize(new Dimension(230, 300));
        this.jsp.setViewportView(this.jt);
        this.add(this.jsp);
    }

    public void updateView(GView gv) {
        MutableTreeNode gvnode = this.viewmap.get(gv);
        if (gvnode != null) {
            DefaultMutableTreeNode projnode = (DefaultMutableTreeNode)gvnode.getParent();
            projnode.remove(gvnode);
            if (projnode.getChildCount() == 0) {
                this.delP(projnode);
            }
            DefaultMutableTreeNode newprojnode = this.addP(gv.getProjection());
            newprojnode.add(gvnode);
        }
        this.expandAll();
    }

    public void addView(GView gv) {
        DefaultMutableTreeNode parentProj;
        Projection proj = gv.getProjection();
        DefaultMutableTreeNode parentPM = this.pmmap.get(proj.getProjectiveMethod());
        if (parentPM == null) {
            parentPM = this.addPM(proj.getProjectiveMethod());
        }
        if ((parentProj = this.pmap.get(proj)) == null) {
            parentProj = this.addP(proj);
        }
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(gv);
        parentProj.add(child);
        this.tm.insertNodeInto(child, parentProj, parentProj.getChildCount() - 1);
        this.viewmap.put(gv, child);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ICVViewExplorer.this.expandAll();
            }
        });
    }

    public void removeView(GView gv) {
        DefaultMutableTreeNode node = this.viewmap.remove(gv);
        if (node != null) {
            this.tm.removeNodeFromParent(node);
            DefaultMutableTreeNode parentProj = this.pmap.get(gv.getProjection());
            if (parentProj.isLeaf()) {
                this.tm.removeNodeFromParent(parentProj);
                this.pmap.remove(gv.getProjection());
                DefaultMutableTreeNode parentPM = this.pmmap.get(gv.getProjection().getProjectiveMethod());
                if (parentPM.isLeaf()) {
                    this.tm.removeNodeFromParent(parentPM);
                    this.pmmap.remove(gv.getProjection().getProjectiveMethod());
                }
            }
            this.expandAll();
        }
    }

    public void addSource(Source src) {
        DefaultMutableTreeNode parent = null;
        parent = src.getParent() != null ? this.srcmap.get(src.getParent()) : this.rootNode;
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(src);
        parent.add(child);
        this.tm.insertNodeInto(child, parent, parent.getChildCount() - 1);
        this.srcmap.put(src, child);
        this.expandAll();
    }

    private DefaultMutableTreeNode addPM(ProjectiveMethod pm) {
        DefaultMutableTreeNode parent = this.srcmap.get(pm.getSource());
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(pm);
        parent.add(child);
        this.tm.insertNodeInto(child, parent, parent.getChildCount() - 1);
        this.pmmap.put(pm, child);
        return child;
    }

    private DefaultMutableTreeNode addP(Projection p) {
        DefaultMutableTreeNode parent = this.pmmap.get(p.getProjectiveMethod());
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(p);
        parent.add(child);
        this.tm.insertNodeInto(child, parent, parent.getChildCount() - 1);
        this.pmap.put(p, child);
        return child;
    }

    private void delP(DefaultMutableTreeNode node) {
        this.pmap.remove(node);
        this.tm.removeNodeFromParent(node);
    }

    public void expandAll() {
        int row = 0;
        while (row < this.jt.getRowCount()) {
            this.jt.expandRow(row);
            ++row;
        }
    }

    public void reset() {
        this.viewmap = new HashMap<GView, DefaultMutableTreeNode>();
        this.pmmap = new HashMap<ProjectiveMethod, DefaultMutableTreeNode>();
        this.srcmap = new HashMap<Source, DefaultMutableTreeNode>();
        this.rootNode = new DefaultMutableTreeNode();
        this.tm = new DefaultTreeModel(this.rootNode);
        this.jt.setModel(this.tm);
    }

    public void setActiveView(GView g) {
        DefaultMutableTreeNode node = this.viewmap.get(g);
        if (node != null) {
            this.listener.setActive(false);
            this.jt.setSelectionPath(new TreePath(node.getPath()));
            this.listener.setActive(true);
        }
    }

    private class TPGVETreeSelectionListener
    implements TreeSelectionListener {
        private boolean active = true;

        private TPGVETreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (this.active) {
                DefaultMutableTreeNode dmt = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
                Object elem = dmt.getUserObject();
                if (elem instanceof Source) {
                    ViewManager.getSingleton().setActiveSource((Source)elem);
                } else if (elem instanceof GView) {
                    ViewManager.getSingleton().setActiveView((GView)elem);
                } else {
                    boolean cfr_ignored_0 = elem instanceof ProjectiveMethod;
                }
            }
        }

        public void setActive(boolean active) {
            this.active = active;
        }
    }
}

