/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.icview.classification;

import explorer.compute.tools.classification.ClassifTool;
import explorer.compute.tools.classification.OutilsClassifKmeans;
import explorer.windows.w2D.icview.classification.ClassificationView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lib3d4j.international.Messages;

public class KMeanView
extends ClassificationView {
    OutilsClassifKmeans control;
    protected int nbClasses = 5;
    protected JLabel JlNbClasses;
    protected JTextField JtfNbClasses;
    protected JButton JbValid;
    private KmdListener kmdl;

    public KMeanView(OutilsClassifKmeans t) {
        super(t, Messages.getString("tpgclassif_kmeans"));
    }

    @Override
    protected void init() {
        this.kmdl = new KmdListener();
        this.setLayout(new BoxLayout(this, 1));
        JPanel panel = new JPanel();
        this.JlNbClasses = new JLabel(Messages.getString("kmd_nbclasses"));
        panel.add(this.JlNbClasses);
        this.JtfNbClasses = new JTextField(3);
        this.JtfNbClasses.setText(new String("" + this.nbClasses));
        this.JtfNbClasses.addActionListener(this.kmdl);
        panel.add(this.JtfNbClasses);
        this.add(panel);
        this.JbValid = new JButton(Messages.getString("kmd_compute"));
        this.JbValid.addActionListener(this.kmdl);
        this.add(this.JbValid);
    }

    @Override
    protected void setControl(ClassifTool t) {
        this.control = (OutilsClassifKmeans)t;
    }

    @Override
    protected ClassifTool getControl() {
        return this.control;
    }

    public void setNbClasses(int nbc) {
        this.kmdl.setActive(false);
        this.JtfNbClasses.setText("" + nbc);
        this.kmdl.setActive(true);
    }

    class KmdListener
    implements ActionListener {
        private boolean active = true;

        KmdListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == KMeanView.this.JtfNbClasses || source == KMeanView.this.JbValid) {
                try {
                    int nbc = Integer.parseInt(KMeanView.this.JtfNbClasses.getText());
                    KMeanView.this.control.afficherKMeans(nbc);
                }
                catch (NumberFormatException nbe) {
                    System.out.println("Valeur invalide");
                }
            }
        }

        public void setActive(boolean active) {
            this.active = active;
        }
    }
}

