/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.icview.constrained;

import explorer.compute.compute.constraints.Constraint;
import explorer.compute.tools.PCTool;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import lib3d4j.international.Messages;

public class ICVConstrainedProjectionMenu
extends JPanel {
    private JButton toutannuler;
    private JButton calculer;
    private JButton sauvegarder;
    private JButton charger;
    private JButton jbRemoveOne;
    public boolean sansfenetre3D = false;
    protected PCTool pct;
    private Vector<Constraint> vListeA;
    protected JList jlContraintes;
    protected JScrollPane jspContraintes;

    public ICVConstrainedProjectionMenu(PCTool c) {
        this.pct = c;
        this.setName(Messages.getString("tpgMI_title"));
        MIMouseListener miml = new MIMouseListener();
        this.setLayout(new BoxLayout(this, 1));
        this.vListeA = new Vector();
        this.jlContraintes = new JList<Constraint>(this.vListeA);
        this.jlContraintes.setLayoutOrientation(0);
        this.jlContraintes.setSelectionMode(0);
        this.jlContraintes.setVisibleRowCount(5);
        this.jlContraintes.addMouseListener(miml);
        this.jspContraintes = new JScrollPane(this.jlContraintes);
        Dimension size = new Dimension(400, 150);
        this.jspContraintes.setPreferredSize(size);
        this.jspContraintes.setMaximumSize(size);
        this.jspContraintes.setVisible(true);
        this.add(this.jspContraintes);
        this.jbRemoveOne = new JButton(Messages.getString("tpgMI_removeone"));
        this.jbRemoveOne.addMouseListener(miml);
        this.jbRemoveOne.setEnabled(false);
        this.add(this.jbRemoveOne);
        this.toutannuler = new JButton(Messages.getString("tpgMI_toutannuler"));
        this.toutannuler.addMouseListener(miml);
        this.add(this.toutannuler);
        this.calculer = new JButton(Messages.getString("tpgMI_calculer"));
        this.calculer.addMouseListener(miml);
        this.add(this.calculer);
        this.sauvegarder = new JButton(Messages.getString("tpgMI_sauvegarder"));
        this.sauvegarder.addMouseListener(miml);
        this.add(this.sauvegarder);
        this.charger = new JButton(Messages.getString("tpgMI_charger"));
        this.charger.addMouseListener(miml);
        this.add(this.charger);
        this.pct.setMI(this);
    }

    public void addConstraints(List<Constraint> lst) {
        for (Constraint c : lst) {
            this.vListeA.add(c);
        }
    }

    public void removeAllConstraints() {
        this.viderListe();
    }

    public void remove() {
        this.pct.clean();
    }

    private void removeAction(int rank) {
        this.pct.removeConstraint(this.vListeA.get(rank));
    }

    public void redrawConstraints() {
        this.jlContraintes.updateUI();
    }

    public void addConstraint(Constraint c) {
        this.vListeA.add(c);
        this.jlContraintes.updateUI();
    }

    public void removeConstraint(Constraint c) {
        this.vListeA.remove(c);
        this.jlContraintes.updateUI();
    }

    private void viderListe() {
        this.vListeA.removeAllElements();
        this.jlContraintes.updateUI();
    }

    class MIMouseListener
    extends MouseAdapter {
        MIMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object src = e.getSource();
            if (src.equals(ICVConstrainedProjectionMenu.this.toutannuler)) {
                ICVConstrainedProjectionMenu.this.remove();
            } else if (src.equals(ICVConstrainedProjectionMenu.this.jbRemoveOne)) {
                ICVConstrainedProjectionMenu.this.removeAction(ICVConstrainedProjectionMenu.this.jlContraintes.getSelectedIndex());
                ICVConstrainedProjectionMenu.this.updateUI();
            } else if (src.equals(ICVConstrainedProjectionMenu.this.jlContraintes)) {
                ICVConstrainedProjectionMenu.this.jbRemoveOne.setEnabled(!ICVConstrainedProjectionMenu.this.jlContraintes.isSelectionEmpty());
            } else if (src.equals(ICVConstrainedProjectionMenu.this.calculer)) {
                ICVConstrainedProjectionMenu.this.pct.compute();
            } else if (src.equals(ICVConstrainedProjectionMenu.this.sauvegarder)) {
                ICVConstrainedProjectionMenu.this.pct.save();
            } else if (src.equals(ICVConstrainedProjectionMenu.this.charger)) {
                ICVConstrainedProjectionMenu.this.pct.load();
            }
        }
    }
}

