/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.icview.kernels;

import explorer.compute.kernels.ISOMAP;
import explorer.compute.kernels.Kernel;
import explorer.compute.kernels.LLE;
import explorer.compute.kernels.Lineaire;
import explorer.compute.kernels.Polynomial;
import explorer.compute.kernels.RBF;
import explorer.compute.kernels.Sigmoide;
import explorer.compute.tools.OutilSVM;
import explorer.compute.tools.OutilsType;
import explorer.data.Common;
import explorer.windows.w2D.SwingUtils;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import lib3d4j.international.Messages;

public class ICVKernels
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected JCheckBox cbActive;
    protected JCheckBox cbDoubleVisu;
    protected JButton jbISOMAP;
    protected JLabel jlbuttonISOMAP;
    protected JLabel jlParam1;
    protected JLabel jlParam2;
    protected JComboBox cobKernelType;
    protected JSpinner jsParam1;
    protected JSpinner jsParam2;
    protected JPanel jpParam;
    protected JPanel jlParam1box;
    protected JPanel jlParam2box;
    private Dimension spinnerDim;
    OutilsType toolType;
    protected boolean param1 = false;
    protected boolean param2 = false;
    protected boolean btnIsomap = false;
    private KernelActionListener actionListener = new KernelActionListener();
    protected ISOMAP ISOMAPKernel = null;

    public ICVKernels(OutilSVM osvm) {
        this.setName(Messages.getString("tpgkernels_title"));
        this.setLayout(new BoxLayout(this, 1));
        this.cbActive = new JCheckBox(Messages.getString("tpgkernels_cbActive"));
        this.cbActive.setSelected(false);
        this.cbActive.addActionListener(this.actionListener);
        this.cbActive.setBackground(this.getBackground());
        this.add(this.cbActive);
        this.cbDoubleVisu = new JCheckBox(Messages.getString("tpgkernels_doubleVisu"));
        this.cbDoubleVisu.setSelected(false);
        this.cbDoubleVisu.setBackground(this.getBackground());
        this.add(this.cbDoubleVisu);
        Vector<String> listKernelType = new Vector<String>();
        listKernelType.add(Messages.getString("tpgkernels_Lineaire"));
        listKernelType.add(Messages.getString("tpgkernels_Polynomial"));
        listKernelType.add(Messages.getString("tpgkernels_RBF"));
        listKernelType.add(Messages.getString("tpgkernels_Sigmoid"));
        listKernelType.add(Messages.getString("tpgkernels_ISOMAP"));
        listKernelType.add(Messages.getString("tpgkernels_LLE"));
        this.cobKernelType = new JComboBox(listKernelType);
        this.cobKernelType.setMaximumSize(this.cobKernelType.getPreferredSize());
        this.cobKernelType.setSelectedIndex(0);
        this.cobKernelType.addActionListener(this.actionListener);
        this.add(this.cobKernelType);
        this.jpParam = new JPanel();
        this.jpParam.setLayout(new BoxLayout(this.jpParam, 3));
        this.jlParam1box = new JPanel(new FlowLayout(0));
        this.jsParam1 = new JSpinner(new SpinnerNumberModel(1.0, 0.0, 100.0, 1.0));
        this.jlParam1box.add(this.jsParam1);
        this.jlParam1 = new JLabel(Messages.getString("tpgkernels_param1"));
        this.jlParam1box.add(this.jlParam1);
        this.jpParam.add(this.jlParam1box);
        this.jlParam2box = new JPanel(new FlowLayout(0));
        this.jsParam2 = new JSpinner(new SpinnerNumberModel(1.0, 0.0, 100.0, 1.0));
        this.jlParam2box.add(this.jsParam2);
        this.jlParam2 = new JLabel(Messages.getString("tpgkernels_param2"));
        this.jlParam2box.add(this.jlParam2);
        this.jpParam.add(this.jlParam2box);
        this.add(this.jpParam);
        this.jbISOMAP = new JButton(Messages.getString("tpgkernels_display"));
        this.jbISOMAP.addActionListener(this.actionListener);
        this.jlbuttonISOMAP = new JLabel(String.valueOf(Messages.getString("tpgkernels_treeISOMAP")) + " :");
        this.add(this.jlbuttonISOMAP);
        this.add(this.jbISOMAP);
        this.spinnerDim = this.jsParam1.getPreferredSize();
        SwingUtils.alignX(this, 0.0f);
        this.disableVisu();
    }

    public void majParam() {
        if (this.param1 && this.cbActive.isSelected()) {
            this.jsParam1.setPreferredSize(this.spinnerDim);
            this.jsParam1.setMaximumSize(this.spinnerDim);
            this.jlParam1.setVisible(true);
        } else {
            this.jsParam1.setPreferredSize(new Dimension(0, 0));
            this.jsParam1.setMaximumSize(new Dimension(0, 0));
            this.jlParam1.setVisible(false);
        }
        if (this.param2 && this.cbActive.isSelected()) {
            this.jsParam2.setPreferredSize(this.spinnerDim);
            this.jsParam2.setMaximumSize(this.spinnerDim);
            this.jlParam2.setVisible(true);
        } else {
            this.jsParam2.setPreferredSize(new Dimension(0, 0));
            this.jsParam2.setMaximumSize(new Dimension(0, 0));
            this.jlParam2.setVisible(false);
        }
        if (this.btnIsomap && this.cbActive.isSelected()) {
            this.jlbuttonISOMAP.setEnabled(true);
            this.jbISOMAP.setEnabled(true);
        } else {
            this.jlbuttonISOMAP.setEnabled(false);
            this.jbISOMAP.setEnabled(false);
        }
    }

    public Kernel getKernel() {
        Kernel res = null;
        if (this.cobKernelType.getSelectedItem() == Messages.getString("tpgkernels_Lineaire")) {
            res = new Lineaire();
        } else if (this.cobKernelType.getSelectedItem() == Messages.getString("tpgkernels_Polynomial")) {
            int n = (int)this.getParam1();
            res = new Polynomial(n);
        } else if (this.cobKernelType.getSelectedItem() == Messages.getString("tpgkernels_RBF")) {
            float sigma = this.getParam1();
            res = new RBF(sigma);
        } else if (this.cobKernelType.getSelectedItem() == Messages.getString("tpgkernels_Sigmoid")) {
            float a = this.getParam1();
            float b = this.getParam2();
            res = new Sigmoide(a, b);
        } else if (this.cobKernelType.getSelectedItem() == Messages.getString("tpgkernels_ISOMAP")) {
            this.ISOMAPKernel = new ISOMAP((int)this.getParam1());
            res = this.ISOMAPKernel;
        } else if (this.cobKernelType.getSelectedItem() == Messages.getString("tpgkernels_LLE")) {
            res = new LLE((int)this.getParam1());
        }
        return res;
    }

    public void enableVisu() {
        this.cobKernelType.setEnabled(true);
        this.cbDoubleVisu.setEnabled(true);
        this.jlbuttonISOMAP.setEnabled(true);
        this.jbISOMAP.setEnabled(true);
        this.majParam();
    }

    public void disableVisu() {
        this.cobKernelType.setEnabled(false);
        this.cbDoubleVisu.setEnabled(false);
        this.jlbuttonISOMAP.setEnabled(false);
        this.jbISOMAP.setEnabled(false);
        this.majParam();
    }

    public boolean isKernelActiveSelected() {
        return this.cbActive.isSelected();
    }

    public String getKernelType() {
        return (String)this.cobKernelType.getSelectedItem();
    }

    public float getParam1() {
        return ((SpinnerNumberModel)this.jsParam1.getModel()).getNumber().floatValue();
    }

    public float getParam2() {
        return ((SpinnerNumberModel)this.jsParam2.getModel()).getNumber().floatValue();
    }

    public void setParam1(String param1, float i, float min, float max) {
        this.jlParam1.setText(param1);
        this.jsParam1.setModel(new SpinnerNumberModel(i, min, max, 1.0));
        this.jsParam1.setPreferredSize(this.spinnerDim);
        this.jsParam1.setMaximumSize(this.spinnerDim);
    }

    public void setParam2(String param2, float i, float min, float max) {
        this.jlParam2.setText(param2);
        this.jsParam2.setModel(new SpinnerNumberModel(i, min, max, 1.0));
        this.jsParam2.setPreferredSize(this.spinnerDim);
        this.jsParam2.setMaximumSize(this.spinnerDim);
    }

    public boolean isDoubleVisuActiveSelected() {
        return this.cbDoubleVisu.isSelected();
    }

    public void setType(OutilsType t) {
        if (t != this.toolType) {
            this.toolType = t;
            this.cbActive.setSelected(false);
            this.disableVisu();
            this.cobKernelType.removeAllItems();
            if (t == OutilsType.ACP) {
                this.cobKernelType.addItem(Messages.getString("tpgkernels_Lineaire"));
                this.cobKernelType.addItem(Messages.getString("tpgkernels_Polynomial"));
                this.cobKernelType.addItem(Messages.getString("tpgkernels_RBF"));
                this.cobKernelType.addItem(Messages.getString("tpgkernels_Sigmoid"));
                this.cobKernelType.addItem(Messages.getString("tpgkernels_ISOMAP"));
                this.cobKernelType.addItem(Messages.getString("tpgkernels_LLE"));
                this.cobKernelType.setSelectedIndex(0);
                this.cbDoubleVisu.setVisible(true);
                this.jlbuttonISOMAP.setVisible(true);
                this.jbISOMAP.setVisible(true);
            } else if (t == OutilsType.MDS) {
                this.cobKernelType.addItem(Messages.getString("tpgkernels_ISOMAP"));
                this.cobKernelType.addItem(Messages.getString("tpgkernels_LLE"));
                this.cobKernelType.setSelectedIndex(0);
                this.cbDoubleVisu.setVisible(false);
                this.jlbuttonISOMAP.setVisible(false);
                this.jbISOMAP.setVisible(false);
            } else {
                this.cobKernelType.addItem(Messages.getString("tpgkernels_Lineaire"));
                this.cobKernelType.addItem(Messages.getString("tpgkernels_Polynomial"));
                this.cobKernelType.addItem(Messages.getString("tpgkernels_RBF"));
                this.cobKernelType.addItem(Messages.getString("tpgkernels_Sigmoid"));
                this.cobKernelType.addItem(Messages.getString("tpgkernels_ISOMAP"));
                this.cobKernelType.addItem(Messages.getString("tpgkernels_LLE"));
                this.cobKernelType.setSelectedIndex(0);
                this.cbDoubleVisu.setVisible(false);
                this.jlbuttonISOMAP.setVisible(false);
                this.jbISOMAP.setVisible(false);
            }
        }
    }

    class KernelActionListener
    implements ActionListener {
        private boolean isomapDisplayed = false;

        KernelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object sender = e.getSource();
            Common common = Common.getSingleton();
            if (sender == ICVKernels.this.jbISOMAP) {
                ICVKernels.this.jbISOMAP.setEnabled(false);
                if (ICVKernels.this.ISOMAPKernel != null && common.f3d != null) {
                    if (!common.f3d.isTreeVisible()) {
                        common.f3d.drawTree(ICVKernels.this.ISOMAPKernel.getProjections());
                        this.isomapDisplayed = true;
                    } else {
                        common.f3d.removeTree();
                        this.isomapDisplayed = false;
                    }
                }
                ICVKernels.this.jbISOMAP.setEnabled(true);
            }
            if (common.f3d != null) {
                if (this.isomapDisplayed) {
                    ICVKernels.this.jbISOMAP.setText(Messages.getString("tpgkernels_erase"));
                } else {
                    ICVKernels.this.jbISOMAP.setText(Messages.getString("tpgkernels_display"));
                }
            } else {
                this.isomapDisplayed = false;
                ICVKernels.this.jbISOMAP.setText(Messages.getString("tpgkernels_display"));
            }
            if (sender == ICVKernels.this.cobKernelType) {
                ICVKernels.this.param1 = false;
                ICVKernels.this.param2 = false;
                ICVKernels.this.btnIsomap = false;
                int max = Integer.MAX_VALUE;
                if (ICVKernels.this.cobKernelType.getSelectedItem() == Messages.getString("tpgkernels_Polynomial")) {
                    ICVKernels.this.param1 = true;
                    ICVKernels.this.setParam1("N", 2.0f, 1.0f, max);
                } else if (ICVKernels.this.cobKernelType.getSelectedItem() == Messages.getString("tpgkernels_RBF")) {
                    ICVKernels.this.param1 = true;
                    ICVKernels.this.setParam1("sigma", 1.0f, -2.1474836E9f, max);
                } else if (ICVKernels.this.cobKernelType.getSelectedItem() == Messages.getString("tpgkernels_Sigmoid")) {
                    ICVKernels.this.param1 = true;
                    ICVKernels.this.param2 = true;
                    ICVKernels.this.setParam1("a", 2.0f, -2.1474836E9f, max);
                    ICVKernels.this.setParam2("b", 1.0f, -2.1474836E9f, max);
                } else if (ICVKernels.this.cobKernelType.getSelectedItem() == Messages.getString("tpgkernels_ISOMAP")) {
                    ICVKernels.this.param1 = true;
                    if (common.getNbObjects() > 1) {
                        max = common.getNbObjects() - 1;
                    }
                    ICVKernels.this.setParam1(Messages.getString("tpgkernels_paramVoisin"), 2.0f, 1.0f, max);
                    ICVKernels.this.btnIsomap = true;
                } else if (ICVKernels.this.cobKernelType.getSelectedItem() == Messages.getString("tpgkernels_LLE")) {
                    ICVKernels.this.param1 = true;
                    if (common.getNbObjects() > 1) {
                        max = common.getNbObjects() - 1;
                    }
                    ICVKernels.this.setParam1(Messages.getString("tpgkernels_paramVoisin"), 2.0f, 1.0f, max);
                }
                ICVKernels.this.majParam();
            }
            if (sender == ICVKernels.this.cbActive) {
                if (ICVKernels.this.cbActive.isSelected()) {
                    ICVKernels.this.enableVisu();
                    common.getTPGSVMDisplayMode().setIsSelectedKernel(true);
                } else {
                    ICVKernels.this.disableVisu();
                    common.getTPGSVMDisplayMode().setIsSelectedKernel(false);
                }
            }
        }
    }
}

