/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.jTaskPaneGroup;

import explorer.data.Common;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lib3d4j.international.Messages;

public class ICVMisclassified
extends JPanel {
    protected JCheckBox afficherBtn;
    protected JCheckBox ellipseBtn;
    protected JButton btnSuiv;
    protected JButton btnPred;
    protected JButton btnCrop;
    protected JButton btnCropErr;
    protected JSlider sDensite;
    protected JLabel affDensite;
    protected JButton btnCubes;
    protected boolean actionSlider = true;
    protected JComboBox cbForme;
    protected JComboBox cbNbVoisins;

    public ICVMisclassified(Common c) {
        LancerCalcul lc = new LancerCalcul(c, this);
        this.setName(Messages.getString("tpgppv_title"));
        this.setLayout(new GridLayout(0, 1));
        Vector<String> v4 = new Vector<String>();
        v4.add(Messages.getString("tpgppv_cone"));
        v4.add(Messages.getString("tpgppv_lightning"));
        this.cbForme = new JComboBox(v4);
        this.cbForme.setSelectedIndex(0);
        this.add(this.cbForme);
        Vector<String> vnbppv = new Vector<String>();
        vnbppv.add("1");
        vnbppv.add("3");
        vnbppv.add("4");
        vnbppv.add("5");
        vnbppv.add("6");
        this.cbNbVoisins = new JComboBox(vnbppv);
        this.cbNbVoisins.setSelectedIndex(0);
        this.cbNbVoisins.addActionListener(new ModifyNbV(c, this));
        this.add(this.cbNbVoisins);
        this.afficherBtn = new JCheckBox(Messages.getString("tpgppv_show_errs"));
        this.afficherBtn.setSelected(false);
        this.afficherBtn.addActionListener(lc);
        this.afficherBtn.setBackground(this.getBackground());
        this.add(this.afficherBtn);
        this.ellipseBtn = new JCheckBox(Messages.getString("tpgppv_show_ellipsoid"));
        this.ellipseBtn.setSelected(false);
        this.ellipseBtn.addActionListener(lc);
        this.ellipseBtn.setBackground(this.getBackground());
        this.add(this.ellipseBtn);
        this.btnSuiv = new JButton(Messages.getString("tpgppv_nextell"));
        this.btnSuiv.setBackground(this.getBackground());
        this.btnSuiv.addActionListener(new BtnSuivClicked(c, this));
        this.add(this.btnSuiv);
        this.btnPred = new JButton(Messages.getString("tpgppv_prevell"));
        this.btnPred.setBackground(this.getBackground());
        this.btnPred.addActionListener(new BtnPredClicked(c, this));
        this.add(this.btnPred);
        this.btnCrop = new JButton(Messages.getString("tpgppv_zoom"));
        this.btnCrop.setBackground(this.getBackground());
        this.btnCrop.addActionListener(new BtnZoomMalPlaces(c, this));
        this.add(this.btnCrop);
        this.btnCropErr = new JButton(Messages.getString("tpgppv_zoom_errs"));
        this.btnCropErr.setBackground(this.getBackground());
        this.btnCropErr.addActionListener(new BtnZoomMalPlaces(c, this));
        this.add(this.btnCropErr);
        this.affDensite = new JLabel(Messages.getString("tpgppv_density"));
        this.add(this.affDensite);
        this.sDensite = new JSlider(1, 1000, 5);
        this.sDensite.setBackground(this.getBackground());
        this.sDensite.addChangeListener(new ChangeListenerTPGProcheVoisinCrop(this, c));
        this.add(this.sDensite);
        this.btnCubes = new JButton(Messages.getString("tpgppv_cubes_show"));
        this.btnCubes.addActionListener(new PpvActionListener(c));
        this.add(this.btnCubes);
    }

    public int getFormeIndex() {
        return this.cbForme.getSelectedIndex();
    }

    public void setAfficherSelected(boolean b) {
        if (this.afficherBtn.isSelected() != b) {
            this.afficherBtn.doClick();
        }
    }

    public void setAfficherEllipsesSelected(boolean b) {
        if (this.ellipseBtn.isSelected() != b) {
            this.ellipseBtn.doClick();
        }
    }

    public boolean isPredSelected() {
        return this.btnPred.isSelected();
    }

    public void setMaximumSlider(int max) {
        this.actionSlider = false;
        this.sDensite.setMaximum(max * 10);
        this.actionSlider = true;
    }

    public void setValueSlider(int value) {
        this.sDensite.setValue(value * 10);
    }

    public int getDensiteValue() {
        return this.sDensite.getValue();
    }

    public void setJDensiteValue(int i) {
        this.actionSlider = false;
        this.sDensite.setValue(i);
        this.actionSlider = true;
    }

    public boolean isSuivSelected() {
        return this.btnSuiv.isSelected();
    }

    public boolean isAfficherEllipsesCoche() {
        return this.ellipseBtn.isSelected();
    }

    public void RAZ() {
        this.afficherBtn.setSelected(false);
    }

    public boolean isAfficheCoche() {
        return this.afficherBtn.isSelected();
    }

    public void setLabelDensite(String label) {
        this.affDensite.setText(label);
    }

    public void setForme(String nomParametre) {
        if (nomParametre.equals(Messages.getString("tpgppv_cone"))) {
            this.cbForme.setSelectedIndex(0);
        } else if (nomParametre.equals(Messages.getString("tpgppv_lightning"))) {
            this.cbForme.setSelectedIndex(1);
        }
    }

    public void setNbVoisins(String nomParametre) {
        int compteur = 0;
        while (compteur < this.cbNbVoisins.getItemCount()) {
            if (nomParametre.equals(this.cbNbVoisins.getItemAt(compteur))) {
                this.cbNbVoisins.setSelectedIndex(compteur);
            }
            ++compteur;
        }
    }

    public void setDensit\u00e9(int nomParametre) {
        this.sDensite.setValue(nomParametre);
    }

    public void next() {
        this.btnSuiv.doClick();
    }

    public void previous() {
        this.btnPred.doClick();
    }

    public void ZoomEllipso\u00efde() {
        this.btnCrop.doClick();
    }

    public void ZoomMalClass\u00e9s() {
        this.btnCropErr.doClick();
    }

    public void Cube() {
        this.btnCubes.doClick();
    }

    final class BtnPredClicked
    implements ActionListener {
        Common c;
        ICVMisclassified t;

        public BtnPredClicked(Common c, ICVMisclassified t) {
            this.t = t;
            this.c = c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.c.getTMalPlaces().choisirEllipsePrecedente();
        }
    }

    final class BtnSuivClicked
    implements ActionListener {
        Common c;
        ICVMisclassified t;

        public BtnSuivClicked(Common c, ICVMisclassified t) {
            this.t = t;
            this.c = c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.c.getTMalPlaces().choisirEllipseSuivante();
        }
    }

    final class BtnZoomMalPlaces
    implements ActionListener {
        Common c;
        ICVMisclassified t;

        public BtnZoomMalPlaces(Common c, ICVMisclassified t) {
            this.t = t;
            this.c = c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ICVMisclassified.this.btnCrop) {
                if (this.c.getTMalPlaces().isEllipsesTracees()) {
                    this.t.afficherBtn.setSelected(false);
                }
            } else {
                this.t.afficherBtn.setSelected(false);
            }
        }
    }

    class ChangeListenerTPGProcheVoisinCrop
    implements ChangeListener {
        ICVMisclassified t;
        Common c;

        ChangeListenerTPGProcheVoisinCrop(ICVMisclassified t, Common c) {
            this.t = t;
            this.c = c;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (ICVMisclassified.this.actionSlider) {
                this.c.getTMalPlaces().setDensite((float)this.t.getDensiteValue() / 10.0f);
            }
        }
    }

    final class LancerCalcul
    implements ActionListener {
        Common c;
        ICVMisclassified t;

        public LancerCalcul(Common c, ICVMisclassified t) {
            this.t = t;
            this.c = c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.c.param.getClassCol() == -1 && this.t.isAfficheCoche()) {
                this.t.RAZ();
                JOptionPane.showMessageDialog(null, Messages.getString("warning_classattr"), Messages.getString("warning"), 2);
                this.c.showVisu();
            } else {
                this.c.getTMalPlaces().afficherPointsMalPlaces(this.t.getFormeIndex(), this.t.isAfficheCoche(), this.t.isAfficherEllipsesCoche());
                System.out.println("nb mal classes : " + this.c.getTMalPlaces().getNbMalClasses());
                this.c.getTMalPlaces().confusionMatrix(System.out);
            }
        }
    }

    class ModifyNbV
    implements ActionListener {
        Common c;
        ICVMisclassified t;

        ModifyNbV(Common c, ICVMisclassified t) {
            this.t = t;
            this.c = c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.c.getTMalPlaces().setNbVoisins(Integer.parseInt((String)this.t.cbNbVoisins.getSelectedItem()));
        }
    }

    final class PpvActionListener
    implements ActionListener {
        private Common c;
        boolean cubesOn = false;

        public PpvActionListener(Common c) {
            this.c = c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ICVMisclassified.this.btnCubes) {
                System.out.println("Trac\u00e9 cubes d\u00e9sactiv\u00e9");
            }
        }
    }
}

