/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.utils;

import explorer.compute.compute.projection.ProjectiveMethod;
import explorer.data.ViewObserver;
import explorer.windows.w2D.utils.GView;
import explorer.windows.w2D.utils.SelectionListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import lib3d4j.display3D.java3D.CentralSelection;
import lib3d4j.display3D.java3D.CentralSelectionObserver;
import lib3d4j.international.Messages;

public class AttributesFrame
extends JFrame
implements SelectionListener,
CentralSelectionObserver,
ViewObserver {
    private static final long serialVersionUID = 1L;
    private JMenuBar menubar;
    private JTable table;
    private TableRowSorter<TableModel> sorter;
    private AttributesTableModel model;
    private AttributesTableColumnModel tcModel;
    private ColorProvider provider = new ColorProvider();
    private JCheckBoxMenuItem rFilter = null;
    private JCheckBoxMenuItem[] cFilter = null;
    private JScrollPane scroller = null;
    private CentralSelection cs = null;
    private HashMap<Integer, Integer> veritableIndex;
    private ProjectiveMethod currentPM;

    public AttributesFrame(String[] headings, Object[][] data) {
        headings = this.ajouterCoord(headings);
        this.veritableIndex = new HashMap();
        this.model = new AttributesTableModel(headings, data);
        this.tcModel = new AttributesTableColumnModel(headings);
        this.setLayout(new BorderLayout());
        this.setTitle(Messages.getString("attr_title"));
        this.creeMenu(headings);
        this.setSize(600, 300);
        this.setLocationRelativeTo(null);
        this.setResizable(true);
        this.setJMenuBar(this.menubar);
        this.construireTable();
        this.scroller = new JScrollPane(this.table);
        this.getContentPane().add((Component)this.scroller, "Center");
        this.setVisible(true);
        this.hideCoord(headings);
        this.cs = CentralSelection.getSingleton();
        this.cs.reference(this);
    }

    @Override
    public void dispose() {
        this.cs.dereference(this);
        super.dispose();
    }

    private Object[][] ajouterProjected3D(Object[][] data) {
        if (this.currentPM.getSource().getType() == 0) {
            int j;
            Object[][] dataWithProjection3D = new Object[data.length][data[0].length + this.currentPM.getDataProjected3D()[0].length];
            int i = 0;
            while (i < data.length) {
                j = 0;
                while (j < data[i].length) {
                    dataWithProjection3D[i][j] = data[i][j];
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < data.length) {
                j = data[i].length;
                while (j < data[i].length + this.currentPM.getDataProjected3D()[0].length) {
                    dataWithProjection3D[i][j] = Float.valueOf(this.currentPM.getDataProjected3D()[i][j - data[i].length]);
                    ++j;
                }
                ++i;
            }
            return dataWithProjection3D;
        }
        return data;
    }

    private String[] ajouterDataProjected3D(String[] headings) {
        if (this.currentPM.getSource().getType() == 0) {
            int longeurTotale = headings.length + this.currentPM.getDataProjected3D()[0].length;
            String[] newheadings = new String[longeurTotale];
            int compteur = 0;
            while (compteur < headings.length) {
                newheadings[compteur] = headings[compteur];
                ++compteur;
            }
            int compteurData = headings.length;
            while (compteurData < longeurTotale) {
                newheadings[compteurData] = "dataProjected3D" + (compteurData - headings.length);
                ++compteurData;
            }
            return newheadings;
        }
        return headings;
    }

    public void hideCoord(String[] headings) {
        int longueurDataProjected3D = 0;
        if (this.currentPM.getSource().getType() == 0) {
            longueurDataProjected3D = this.currentPM.getDataProjected3D()[0].length;
        }
        int i = headings.length - 3 - longueurDataProjected3D;
        while (i < headings.length) {
            this.tcModel.setColumnVisible(i, false);
            ++i;
        }
    }

    public String[] ajouterCoord(String[] headings) {
        String[] newheadings = new String[headings.length + 3];
        int compteur = 0;
        while (compteur < headings.length) {
            newheadings[compteur] = headings[compteur];
            ++compteur;
        }
        newheadings[compteur] = "Coord. x";
        newheadings[compteur + 1] = "Coord. y";
        newheadings[compteur + 2] = "Coord. z";
        return newheadings;
    }

    public JMenuBar creeMenu(String[] headings) {
        int longueurDataProjected3D = 0;
        if (this.currentPM.getSource().getType() == 0) {
            longueurDataProjected3D = this.currentPM.getDataProjected3D()[0].length;
        }
        this.menubar = new JMenuBar();
        JMenu menuRows = new JMenu(Messages.getString("attr_rows"));
        MenuActionListener mal = new MenuActionListener();
        this.rFilter = new JCheckBoxMenuItem(Messages.getString("attr_filter"));
        this.rFilter.addActionListener(mal);
        menuRows.add(this.rFilter);
        this.menubar.add(menuRows);
        JMenu menuColumns = new JMenu(Messages.getString("attr_cols"));
        JMenu menuComplementary = new JMenu(Messages.getString("attr_complementary"));
        this.cFilter = new JCheckBoxMenuItem[headings.length];
        int i = 1;
        while (i < headings.length - 3 - longueurDataProjected3D) {
            this.cFilter[i] = new JCheckBoxMenuItem(headings[i]);
            this.cFilter[i].setSelected(true);
            this.cFilter[i].addActionListener(mal);
            menuComplementary.add(this.cFilter[i]);
            ++i;
        }
        menuColumns.add(menuComplementary);
        JMenu menuCoordinates = new JMenu(Messages.getString("attr_coordinates"));
        int i2 = headings.length - 3 - longueurDataProjected3D;
        while (i2 < headings.length - longueurDataProjected3D) {
            this.cFilter[i2] = new JCheckBoxMenuItem(headings[i2]);
            this.cFilter[i2].setSelected(false);
            this.cFilter[i2].addActionListener(mal);
            menuCoordinates.add(this.cFilter[i2]);
            ++i2;
        }
        menuColumns.add(menuCoordinates);
        this.menubar.add(menuColumns);
        return this.menubar;
    }

    public Vector<Object> construireVect1(Object[] tab) {
        Vector<Object> v = new Vector<Object>();
        int i = 0;
        while (i < tab.length) {
            v.add(tab[i]);
            ++i;
        }
        return v;
    }

    public Vector<Object> construireVect2(Object[][] tab) {
        Vector<Object> w = new Vector<Object>();
        int n = 0;
        int j = 0;
        while (n <= tab.length) {
            Vector<Object> v = new Vector<Object>();
            int i = 0;
            while (i < tab[j].length) {
                v.insertElementAt(tab[j][i], i);
                ++n;
                ++i;
            }
            w.addAll(v);
            ++j;
        }
        return w;
    }

    public void construireTable() {
        this.sorter = new TableRowSorter<AttributesTableModel>(this.model);
        this.table = new JTable(this.model);
        this.table.setColumnModel(this.tcModel);
        this.registerRendererForClass(this.table, String.class);
        this.registerRendererForClass(this.table, Integer.class);
        this.registerRendererForClass(this.table, Float.class);
        TableCellRenderer BRenderer = this.table.getDefaultRenderer(Boolean.class);
        SelectionRenderer colorRenderer = new SelectionRenderer(BRenderer, this.provider);
        this.table.setDefaultRenderer(Boolean.class, colorRenderer);
        this.table.setRowSorter(this.sorter);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.table.setFillsViewportHeight(true);
        this.table.setSelectionMode(0);
        AttributesLSListener alsl = new AttributesLSListener();
        this.table.getSelectionModel().addListSelectionListener(alsl);
    }

    private void registerRendererForClass(JTable table, Class classe) {
        DefaultTableCellRenderer defaultRenderer = (DefaultTableCellRenderer)table.getDefaultRenderer(classe);
        SelectionRenderer colorRenderer = new SelectionRenderer(defaultRenderer, this.provider);
        table.setDefaultRenderer(classe, colorRenderer);
    }

    @Override
    public void activeViewChanged(GView v) {
        if (v.getProjectiveMethod() != this.currentPM) {
            this.currentPM = v.getProjectiveMethod();
        }
    }

    public boolean getCurrentFilter() {
        return this.model.currentFilter;
    }

    @Override
    public void setSelected(int row, boolean sel) {
        this.model.setSelected(row, sel);
        if (this.rFilter.isSelected()) {
            this.model.setVisible(row, sel);
        }
        this.repaint();
    }

    @Override
    public void selectionStateChanged(int index) {
        this.cs.flipState(index, this);
    }

    @Override
    public void onSelectionChange() {
        int lastUse = this.cs.getLastUse();
        boolean lastState = this.cs.isSelected(lastUse);
        if (this.model.currentFilter) {
            this.model.setVisible(lastUse, lastState);
            this.repaint();
        }
        this.setSelected(lastUse, lastState);
    }

    class AttributesLSListener
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent event) {
            int viewRow = AttributesFrame.this.table.getSelectedRow();
            if (viewRow >= 0) {
                int modelRow = AttributesFrame.this.table.convertRowIndexToModel(viewRow);
                boolean adjust = event.getValueIsAdjusting();
                if (!adjust && !AttributesFrame.this.model.currentFilter) {
                    boolean newState = !AttributesFrame.this.model.isSelectedClick(modelRow);
                    AttributesFrame.this.model.setSelected(modelRow, newState);
                    AttributesFrame.this.selectionStateChanged(modelRow);
                    AttributesFrame.this.table.clearSelection();
                }
            }
        }
    }

    class AttributesTableColumnModel
    extends DefaultTableColumnModel {
        private boolean[] visibleColumn = null;
        private int visibleColumnCount;
        private int[] visibleColumnIndex;

        public AttributesTableColumnModel(String[] headings) {
            int i = 0;
            String[] stringArray = headings;
            int n = headings.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                TableColumn tc = new TableColumn(i);
                tc.setHeaderValue(s);
                this.addColumn(tc);
                ++i;
                ++n2;
            }
            this.initAll();
        }

        private void initAll() {
            this.visibleColumnCount = this.tableColumns.size();
            this.visibleColumn = new boolean[this.visibleColumnCount];
            this.visibleColumnIndex = new int[this.visibleColumnCount];
            int i = 0;
            while (i < this.visibleColumnCount) {
                this.visibleColumn[i] = true;
                this.visibleColumnIndex[i] = i;
                ++i;
            }
        }

        public void setColumnVisible(int col, boolean visible) {
            if (this.visibleColumn[col] != visible) {
                if (visible) {
                    int rank = 0;
                    while (rank < this.visibleColumnCount && this.visibleColumnIndex[rank] < col) {
                        ++rank;
                    }
                    int i = this.visibleColumnCount;
                    while (i > rank) {
                        this.visibleColumnIndex[i] = this.visibleColumnIndex[i - 1];
                        --i;
                    }
                    this.visibleColumnIndex[rank] = col;
                    ++this.visibleColumnCount;
                } else {
                    int rank = 0;
                    while (rank < this.visibleColumnCount && this.visibleColumnIndex[rank] != col) {
                        ++rank;
                    }
                    int i = rank;
                    while (i < this.visibleColumnCount - 1) {
                        this.visibleColumnIndex[i] = this.visibleColumnIndex[i + 1];
                        ++i;
                    }
                    --this.visibleColumnCount;
                }
                this.visibleColumn[col] = visible;
            }
        }

        @Override
        public Enumeration<TableColumn> getColumns() {
            Vector<TableColumn> al = new Vector<TableColumn>();
            int i = 0;
            while (i < this.visibleColumnCount) {
                al.add((TableColumn)this.tableColumns.elementAt(this.visibleColumnIndex[i]));
                ++i;
            }
            return al.elements();
        }

        @Override
        public int getColumnCount() {
            return this.visibleColumnCount;
        }

        @Override
        public TableColumn getColumn(int columnIndex) {
            return (TableColumn)this.tableColumns.elementAt(this.visibleColumnIndex[columnIndex]);
        }
    }

    class AttributesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private boolean[] selected = null;
        private boolean[] visible = null;
        private int visibleCount = 0;
        private int[] visibleIndex = null;
        private String[] columnNames = null;
        private Object[][] data = null;
        private boolean currentFilter = false;

        public AttributesTableModel(String[] columnNames, Object[][] data) {
            this.columnNames = columnNames;
            this.data = data;
            this.selected = new boolean[data.length];
            this.visible = new boolean[data.length];
            this.visibleIndex = new int[data.length];
            int i = 0;
            while (i < this.selected.length) {
                this.selected[i] = false;
                this.visible[i] = true;
                this.visibleIndex[i] = i;
                AttributesFrame.this.veritableIndex.put((Integer)data[i][0], i);
                ++i;
            }
            this.visibleCount = data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.visibleCount;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data[this.visibleIndex[rowIndex]][columnIndex];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col >= 2;
        }

        public void setSelected(int row, boolean sel) {
            this.selected[row] = sel;
        }

        public boolean isSelected(int row) {
            return this.selected[this.visibleIndex[(Integer)AttributesFrame.this.veritableIndex.get(row)]];
        }

        public boolean isSelectedClick(int row) {
            return this.selected[this.visibleIndex[row]];
        }

        public void setVisible(int row, boolean visible) {
            if (this.visible[row] != visible) {
                List<RowSorter.SortKey> sk = null;
                if (AttributesFrame.this.sorter.getSortKeys() != null) {
                    sk = AttributesFrame.this.sorter.getSortKeys();
                    AttributesFrame.this.sorter.setSortKeys(null);
                }
                if (visible) {
                    int rank = 0;
                    while (rank < this.visibleCount && this.visibleIndex[rank] < row) {
                        ++rank;
                    }
                    int i = this.visibleCount;
                    while (i > rank) {
                        this.visibleIndex[i] = this.visibleIndex[i - 1];
                        --i;
                    }
                    this.visibleIndex[rank] = row;
                    ++this.visibleCount;
                } else {
                    int rank = 0;
                    while (rank < this.visibleCount && this.visibleIndex[rank] != row) {
                        ++rank;
                    }
                    int i = rank;
                    while (i < this.visibleCount - 1) {
                        this.visibleIndex[i] = this.visibleIndex[i + 1];
                        ++i;
                    }
                    --this.visibleCount;
                }
                this.visible[row] = visible;
                AttributesFrame.this.sorter.setSortKeys(sk);
            }
        }

        public void filterSelected(boolean sel) {
            if (sel) {
                this.currentFilter = true;
                int i = 0;
                while (i < this.selected.length) {
                    this.setVisible(i, this.selected[i]);
                    ++i;
                }
            } else {
                this.currentFilter = false;
                int i = 0;
                while (i < this.visible.length) {
                    if (AttributesFrame.this.sorter.getSortKeys() != null) {
                        AttributesFrame.this.sorter.setSortKeys(null);
                    }
                    this.visible[i] = true;
                    this.visibleIndex[i] = i;
                    ++i;
                }
                this.visibleCount = this.visible.length;
            }
        }
    }

    class ColorProvider {
        ColorProvider() {
        }

        public Color getForeground(int row, int column) {
            return Color.black;
        }

        public Color getBackground(int row, int column) {
            int realIndex = !AttributesFrame.this.model.currentFilter ? Integer.valueOf(AttributesFrame.this.table.getValueAt(row, 0).toString()) : row;
            if (AttributesFrame.this.model.isSelected(realIndex)) {
                return Color.LIGHT_GRAY;
            }
            return Color.white;
        }
    }

    class MenuActionListener
    implements ActionListener {
        MenuActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == AttributesFrame.this.rFilter) {
                AttributesFrame.this.model.filterSelected(AttributesFrame.this.rFilter.isSelected());
            } else {
                int i = 0;
                while (i < AttributesFrame.this.cFilter.length && AttributesFrame.this.cFilter[i] != src) {
                    ++i;
                }
                if (i < AttributesFrame.this.cFilter.length) {
                    AttributesFrame.this.tcModel.setColumnVisible(i, AttributesFrame.this.cFilter[i].isSelected());
                }
            }
            AttributesFrame.this.repaint();
        }
    }

    class SelectionRenderer
    extends DefaultTableCellRenderer {
        protected TableCellRenderer renderer;
        protected ColorProvider provider;
        JLabel label = new JLabel();

        public SelectionRenderer(TableCellRenderer aRenderer, ColorProvider provider) {
            this.renderer = aRenderer;
            this.provider = provider;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color bgrd = null;
            Color fgrd = null;
            if (isSelected) {
                fgrd = table.getSelectionForeground();
                bgrd = table.getSelectionBackground();
            } else {
                int mcol = table.convertColumnIndexToModel(column);
                fgrd = this.provider.getForeground(row, mcol);
                bgrd = this.provider.getBackground(row, mcol);
            }
            Component c = this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            c.setBackground(bgrd);
            c.setForeground(fgrd);
            return c;
        }
    }
}

