/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.utils;

import explorer.data.DataManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import lib3d4j.data.DescriptionData;
import lib3d4j.international.Messages;

public class CaracTable
extends JFrame {
    private TableRowSorter<TableModel> sorter;
    private AttributesTableModel model;
    private AttributesTableColumnModel tcModel;
    private JScrollPane scroller = null;
    private JTable table;
    private int nbColonnes;
    private DescriptionData dd = DataManager.getSingleton().getCompAttr();

    public CaracTable(int[] points, String s) {
        this.nbColonnes = this.dd.getColNamesWithIndice().length;
        this.model = new AttributesTableModel(points, this.columnNames());
        this.tcModel = new AttributesTableColumnModel(this.model.columnNames);
        this.setLayout(new BorderLayout());
        this.setTitle(String.valueOf(Messages.getString("carac_title")) + " " + s);
        this.setSize(400, 300);
        this.setLocation(275, 470);
        this.setResizable(true);
        this.initTable();
        this.scroller = new JScrollPane(this.table);
        this.getContentPane().add((Component)this.scroller, "Center");
        this.setVisible(true);
    }

    private void initTable() {
        this.sorter = new TableRowSorter<AttributesTableModel>(this.model);
        this.table = new JTable(this.model);
        this.table.setColumnModel(this.tcModel);
        this.table.setRowSorter(this.sorter);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.table.setFillsViewportHeight(true);
    }

    private String[] columnNames() {
        return this.dd.getColNamesWithIndice();
    }

    private Object[][] listeToTab(int[] points) {
        int nbpts = points.length;
        Object[][] tab = new Object[nbpts][this.nbColonnes];
        int i = 0;
        while (i < nbpts) {
            tab[i][0] = points[i];
            int j = 1;
            while (j < this.nbColonnes) {
                tab[i][j] = this.dd.getCompAttrValue(points[i], j - 1);
                ++j;
            }
            ++i;
        }
        return tab;
    }

    class AttributesTableColumnModel
    extends DefaultTableColumnModel {
        public AttributesTableColumnModel(String[] headings) {
            int i = 0;
            String[] stringArray = headings;
            int n = headings.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                TableColumn tc = new TableColumn(i);
                tc.setHeaderValue(s);
                this.addColumn(tc);
                ++i;
                ++n2;
            }
        }
    }

    class AttributesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private boolean[] selected = null;
        private boolean[] visible = null;
        private String[] columnNames = null;
        private Object[][] data = null;
        private int visibleCount = 0;
        private int[] visibleIndex = null;

        public AttributesTableModel(int[] points, String[] columnNames) {
            this.columnNames = columnNames;
            this.data = CaracTable.this.listeToTab(points);
            this.visibleCount = this.data.length;
            this.selected = new boolean[this.data.length];
            this.visible = new boolean[this.data.length];
            this.visibleIndex = new int[this.data.length];
            int i = 0;
            while (i < this.selected.length) {
                this.selected[i] = false;
                this.visible[i] = true;
                this.visibleIndex[i] = i;
                ++i;
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.visibleCount;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data[this.visibleIndex[rowIndex]][columnIndex];
        }
    }
}

