/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.utils;

import java.awt.Dimension;
import java.awt.Frame;
import java.io.IOException;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import lib3d4j.international.Messages;

public class HelpContentDialog
extends JDialog {
    private static final long serialVersionUID = 1L;

    public HelpContentDialog(Frame owner) {
        super(owner);
        this.setTitle(Messages.getString("helpcontenttitle"));
        this.add(this.getPane());
        this.setLocation(100, 100);
        this.setPreferredSize(new Dimension(800, 600));
        this.setMinimumSize(new Dimension(450, 200));
        this.pack();
    }

    private JScrollPane getPane() {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.addHyperlinkListener(new MyHyperlinkListener(editorPane));
        try {
            HTMLDocument desc = new HTMLDocument();
            URL helpBase = new URL("http://www.univ-orleans.fr/lifo/software/Explorer3D/documentation");
            desc.setBase(helpBase);
            URL helpURL = new URL("http://www.univ-orleans.fr/lifo/software/Explorer3D/documentation/index.html");
            editorPane.setPage(helpURL);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, Messages.getString("errorhelpfile"), Messages.getString("warning"), 2);
        }
        JScrollPane editorScrollPane = new JScrollPane(editorPane);
        editorScrollPane.setVerticalScrollBarPolicy(20);
        editorScrollPane.setHorizontalScrollBarPolicy(31);
        editorScrollPane.setPreferredSize(new Dimension(800, 600));
        return editorScrollPane;
    }

    class MyHyperlinkListener
    implements HyperlinkListener {
        JEditorPane parent;

        public MyHyperlinkListener(JEditorPane parent) {
            this.parent = parent;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    this.parent.setPage(e.getURL());
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(null, Messages.getString("errorhelpfile"), Messages.getString("warning"), 2);
                }
            }
        }
    }
}

